/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.healthcare.edit.actions;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.database.ConnectionPool;
import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.controller.SecurityHook;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.base.CustomField;
import org.aspcfs.modules.base.CustomFieldCategory;
import org.aspcfs.modules.base.CustomFieldCategoryList;
import org.aspcfs.modules.base.CustomFieldGroup;
import org.aspcfs.modules.base.CustomFieldRecord;
import org.aspcfs.modules.base.CustomFieldRecordList;
import org.aspcfs.modules.healthcare.edit.base.FolderInsertRecord;
import org.aspcfs.modules.healthcare.edit.base.TransactionRecord;
import org.aspcfs.modules.healthcare.edit.base.TransactionRecordList;
import org.aspcfs.modules.login.base.AuthenticationItem;
import org.aspcfs.modules.system.base.Site;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.SMTPMessage;
import org.aspcfs.utils.Template;

public final class ProcessCalculation
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDefault(ActionContext context) {
        ConnectionElement ce;
        StringBuffer sb;
        int month;
        Calendar cal;
        SystemStatus systemStatus;
        block52: {
            Connection db;
            block51: {
                String test = context.getRequest().getParameter("test");
                db = null;
                HashMap<Integer, String> errors = new HashMap<Integer, String>();
                systemStatus = this.getSystemStatus(context);
                int providerRecordsInserted = 0;
                TransactionRecordList recordList = null;
                CustomFieldCategoryList fullCategoryList = null;
                CustomFieldCategory providerTransDetails = null;
                CustomFieldCategory officeTransDetails = null;
                fullCategoryList = new CustomFieldCategoryList();
                fullCategoryList.setLinkModuleId(1);
                fullCategoryList.setIncludeEnabled(1);
                fullCategoryList.setIncludeScheduled(1);
                HashMap<String, Integer> providerOrgMapping = new HashMap<String, Integer>();
                HashMap<String, ArrayList> payorOrgMapping = new HashMap<String, ArrayList>();
                HashMap<String, FolderInsertRecord> providerTransactions = new HashMap<String, FolderInsertRecord>();
                HashMap officeTransactions = new HashMap();
                ConnectionPool sqlDriver = null;
                ConnectionElement connectionElement = null;
                Connection prodDb = null;
                Date dateToProcess = null;
                cal = Calendar.getInstance();
                String dateString = context.getRequest().getParameter("date");
                if (dateString != null) {
                    dateToProcess = DateUtils.parseDateString(dateString);
                    cal.setTime(dateToProcess);
                } else {
                    cal.add(5, -1);
                    dateToProcess = new Date(cal.getTimeInMillis());
                }
                month = cal.get(2) + 1;
                recordList = new TransactionRecordList();
                recordList.setPerformed(dateToProcess);
                sb = new StringBuffer();
                ce = null;
                try {
                    ArrayList tempArray;
                    AuthenticationItem auth = new AuthenticationItem();
                    ce = auth.getConnectionElement(context);
                    db = this.getConnection(context, ce);
                    SystemStatus thisSystem = this.getSystemStatus(context, ce);
                    if (thisSystem == null) {
                        Site thisSite = SecurityHook.retrieveSite(context.getServletContext(), context.getRequest());
                        thisSystem = SecurityHook.retrieveSystemStatus(context.getServletContext(), db, ce, thisSite.getLanguage());
                    }
                    sqlDriver = new ConnectionPool();
                    sqlDriver.setMaxConnections(2);
                    sqlDriver.setMaxIdleTimeSeconds(600);
                    sqlDriver.setMaxDeadTimeSeconds(3600);
                    sqlDriver.setAllowShrinking(true);
                    if (System.getProperty("DEBUG") != null) {
                        sqlDriver.setDebug(true);
                    }
                    connectionElement = new ConnectionElement(this.getValue(context, ce, "DATABASE.URL"), this.getValue(context, ce, "DATABASE.USERNAME"), this.getValue(context, ce, "DATABASE.PASSWORD"));
                    connectionElement.setAllowCloseOnIdle(true);
                    connectionElement.setDriver(this.getValue(context, ce, "DATABASE.DRIVER"));
                    prodDb = sqlDriver.getConnection(connectionElement);
                    recordList.buildList(db);
                    providerTransDetails = new CustomFieldCategory(prodDb, this.getValueAsInt(context, ce, "PROVIDER_TRANSACTION_DETAILS"));
                    providerTransDetails.setLinkModuleId(1);
                    providerTransDetails.setIncludeEnabled(1);
                    providerTransDetails.setIncludeScheduled(1);
                    providerTransDetails.setBuildResources(true);
                    providerTransDetails.setEnteredBy(this.getValueAsInt(context, ce, "ENTERED_BY"));
                    providerTransDetails.setModifiedBy(this.getValueAsInt(context, ce, "ENTERED_BY"));
                    providerTransDetails.buildResources(prodDb);
                    officeTransDetails = new CustomFieldCategory(prodDb, this.getValueAsInt(context, ce, "OFFICE_TRANSACTION_DETAILS"));
                    officeTransDetails.setLinkModuleId(1);
                    officeTransDetails.setIncludeEnabled(1);
                    officeTransDetails.setIncludeScheduled(1);
                    officeTransDetails.setBuildResources(true);
                    officeTransDetails.setEnteredBy(this.getValueAsInt(context, ce, "ENTERED_BY"));
                    officeTransDetails.setModifiedBy(this.getValueAsInt(context, ce, "ENTERED_BY"));
                    officeTransDetails.buildResources(prodDb);
                    fullCategoryList.buildList(prodDb);
                    CustomFieldCategory providerCategory = fullCategoryList.getCategory(this.getValueAsInt(context, ce, "OFFICE_PROVIDER_DETAILS"));
                    providerCategory.setBuildResources(true);
                    providerCategory.buildResources(prodDb);
                    CustomFieldRecordList providerRecords = new CustomFieldRecordList();
                    providerRecords.setLinkModuleId(1);
                    providerRecords.setCategoryId(providerCategory.getId());
                    providerRecords.buildList(prodDb);
                    providerRecords.buildRecordColumns(prodDb, providerCategory);
                    for (CustomFieldRecord rec : providerRecords) {
                        for (CustomFieldGroup thisGrp : providerCategory) {
                            Iterator fields = thisGrp.iterator();
                            if (!fields.hasNext()) continue;
                            CustomField thisField = ((CustomField)fields.next()).duplicate();
                            thisField.setRecordId(rec.getId());
                            thisField.buildResources(prodDb);
                            providerOrgMapping.put(thisField.getValueHtml(), new Integer(rec.getLinkItemId()));
                            if (System.getProperty("DEBUG") == null) continue;
                            System.out.println("ProcessCalculation-> Adding to providerOrgMapping: " + thisField.getValueHtml() + " | " + rec.getLinkItemId());
                        }
                    }
                    CustomFieldCategory payorCategory = fullCategoryList.getCategory(this.getValueAsInt(context, ce, "OFFICE_PAYOR_DETAILS"));
                    payorCategory.setBuildResources(true);
                    payorCategory.buildResources(prodDb);
                    CustomFieldRecordList payorRecords = new CustomFieldRecordList();
                    payorRecords.setLinkModuleId(1);
                    payorRecords.setCategoryId(payorCategory.getId());
                    payorRecords.buildList(prodDb);
                    payorRecords.buildRecordColumns(prodDb, payorCategory);
                    for (CustomFieldRecord rec : payorRecords) {
                        for (CustomFieldGroup thisGrp : payorCategory) {
                            Iterator fields = thisGrp.iterator();
                            if (!fields.hasNext()) continue;
                            CustomField thisField = ((CustomField)fields.next()).duplicate();
                            thisField.setRecordId(rec.getId());
                            thisField.buildResources(prodDb);
                            if (payorOrgMapping.get(thisField.getValueHtml()) == null) {
                                tempArray = new ArrayList();
                                tempArray.add(new Integer(rec.getLinkItemId()));
                                payorOrgMapping.put(thisField.getValueHtml(), tempArray);
                                continue;
                            }
                            tempArray = (ArrayList)payorOrgMapping.get(thisField.getValueHtml());
                            tempArray.add(new Integer(rec.getLinkItemId()));
                            payorOrgMapping.remove(thisField.getValueHtml());
                            payorOrgMapping.put(thisField.getValueHtml(), tempArray);
                        }
                    }
                    ArrayList providerTransactionDetailsIds = providerTransDetails.getFormFieldIds();
                    ArrayList officeTransactionDetailsIds = officeTransDetails.getFormFieldIds();
                    Iterator i = recordList.iterator();
                    while (i.hasNext()) {
                        FolderInsertRecord pfir;
                        FolderInsertRecord tempFir;
                        boolean hasErrors = false;
                        TransactionRecord thisRec = (TransactionRecord)((Object)i.next());
                        if (providerOrgMapping.get(thisRec.getTaxId()) == null) {
                            hasErrors = true;
                            errors.put(new Integer(thisRec.getId()), new String("Error: Provider with tax ID = " + thisRec.getTaxId() + " not found in Centric CRM!"));
                        } else if (!payorOrgMapping.containsKey(thisRec.getPayerId())) {
                            hasErrors = true;
                            errors.put(new Integer(thisRec.getId()), new String("Error: Payor with ID = " + thisRec.getPayerId() + " not found in Centric CRM!"));
                        }
                        if (!hasErrors && !(tempArray = (ArrayList)payorOrgMapping.get(thisRec.getPayerId())).contains((Integer)providerOrgMapping.get(thisRec.getTaxId()))) {
                            hasErrors = true;
                            errors.put(new Integer(thisRec.getId()), new String("Error: Payor with ID = " + thisRec.getPayerId() + " not associated with Provider " + thisRec.getTaxId() + " in Centric CRM!"));
                        }
                        if (!hasErrors && !(tempFir = new FolderInsertRecord()).process(thisRec)) {
                            hasErrors = true;
                            errors.put(new Integer(thisRec.getId()), new String("Error: Transaction Type " + thisRec.getType() + " not recognized"));
                        }
                        if (hasErrors) continue;
                        FolderInsertRecord fir = (FolderInsertRecord)((Object)providerTransactions.get(thisRec.getTaxId()));
                        if (fir == null) {
                            fir = new FolderInsertRecord(thisRec.getTransactionId(), thisRec.getPayerId());
                            providerTransactions.put(thisRec.getTaxId(), fir);
                        }
                        fir.process(thisRec);
                        HashMap<String, FolderInsertRecord> officePayors = (HashMap<String, FolderInsertRecord>)officeTransactions.get(thisRec.getTaxId());
                        if (officePayors == null) {
                            officePayors = new HashMap<String, FolderInsertRecord>();
                            officeTransactions.put(thisRec.getTaxId(), officePayors);
                        }
                        if ((pfir = (FolderInsertRecord)((Object)officePayors.get(thisRec.getPayerId()))) == null) {
                            pfir = new FolderInsertRecord(thisRec.getTransactionId(), thisRec.getPayerId());
                            officePayors.put(thisRec.getPayerId(), pfir);
                        }
                        pfir.process(thisRec);
                    }
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("ProcessCalculation-> Updating MTD values");
                    }
                    for (String taxId : officeTransactions.keySet()) {
                        HashMap officePayors = (HashMap)officeTransactions.get(taxId);
                        officeTransDetails.setLinkItemId((Integer)providerOrgMapping.get(taxId));
                        officeTransDetails.setBuildResources(true);
                        CustomFieldRecordList officeRecords = new CustomFieldRecordList();
                        officeRecords.setLinkModuleId(1);
                        officeRecords.setLinkItemId((Integer)providerOrgMapping.get(taxId));
                        officeRecords.setCategoryId(officeTransDetails.getId());
                        officeRecords.buildList(prodDb);
                        officeRecords.buildRecordColumns(prodDb, officeTransDetails);
                        if (System.getProperty("DEBUG") != null) {
                            System.out.println("ProcessCalculation-> Built list for: " + officeRecords.getLinkItemId() + " (" + officeRecords.size() + ")");
                        }
                        for (String payorId : officePayors.keySet()) {
                            FolderInsertRecord val = (FolderInsertRecord)((Object)officePayors.get(payorId));
                            if (System.getProperty("DEBUG") != null) {
                                System.out.println("ProcessCalculation-> TaxId: " + taxId + " PayorId: " + payorId + " Status: " + (val != null) + " OrgId: " + (Integer)providerOrgMapping.get(taxId));
                            }
                            ArrayList<String> previousValues = new ArrayList<String>();
                            int foundId = -1;
                            Iterator op = officeRecords.iterator();
                            while (op.hasNext() && foundId == -1) {
                                CustomFieldRecord rec = (CustomFieldRecord)op.next();
                                officeTransDetails.setRecordId(rec.getId());
                                officeTransDetails.buildResources(prodDb);
                                Iterator grps = officeTransDetails.iterator();
                                while (grps.hasNext() && foundId == -1) {
                                    CustomField payorIdField;
                                    CustomFieldGroup thisGrp = (CustomFieldGroup)grps.next();
                                    Iterator fields = thisGrp.iterator();
                                    if (!fields.hasNext() || !(payorIdField = ((CustomField)fields.next()).duplicate()).getValueHtml().equals(val.getPayorId())) continue;
                                    CustomField thisField = (CustomField)fields.next();
                                    Date tempDate = DateUtils.parseDateString(thisField.getValueHtml(), "MM/dd/yyy");
                                    Calendar tempCal = Calendar.getInstance();
                                    tempCal.setTime(tempDate);
                                    int tempMonth = tempCal.get(2);
                                    if (month != ++tempMonth || cal.get(1) != tempCal.get(1)) continue;
                                    if (System.getProperty("DEBUG") != null) {
                                        System.out.println("ProcessCalculation-> Date found: " + tempMonth + "/" + tempCal.get(1));
                                    }
                                    for (int z = 0; z < 8; ++z) {
                                        CustomField innerField = (CustomField)fields.next();
                                        previousValues.add(innerField.getEnteredValue());
                                    }
                                    foundId = rec.getId();
                                    val.updateTotals(previousValues);
                                }
                            }
                            context.getRequest().setAttribute("cf" + officeTransactionDetailsIds.get(0), (Object)val.getPayorId());
                            context.getRequest().setAttribute("cf" + officeTransactionDetailsIds.get(1), (Object)recordList.getPerformedString());
                            context.getRequest().setAttribute("cf" + officeTransactionDetailsIds.get(2), (Object)(val.getEligibility() + ""));
                            context.getRequest().setAttribute("cf" + officeTransactionDetailsIds.get(3), (Object)(val.getClaimStatus() + ""));
                            context.getRequest().setAttribute("cf" + officeTransactionDetailsIds.get(4), (Object)(val.getReferral() + ""));
                            context.getRequest().setAttribute("cf" + officeTransactionDetailsIds.get(5), (Object)(val.getAdvice() + ""));
                            context.getRequest().setAttribute("cf" + officeTransactionDetailsIds.get(6), (Object)(val.getDental() + ""));
                            context.getRequest().setAttribute("cf" + officeTransactionDetailsIds.get(7), (Object)(val.getProfessional() + ""));
                            context.getRequest().setAttribute("cf" + officeTransactionDetailsIds.get(8), (Object)(val.getInstitutional() + ""));
                            context.getRequest().setAttribute("cf" + officeTransactionDetailsIds.get(9), (Object)(val.getClaimRemittance() + ""));
                            officeTransDetails.setParameters(context);
                            if (foundId > -1) {
                                if (System.getProperty("DEBUG") != null) {
                                    System.out.println("ProcessCalculation-> ...updating");
                                }
                                officeTransDetails.setRecordId(foundId);
                                if (test != null) continue;
                                officeTransDetails.update(prodDb);
                                continue;
                            }
                            if (System.getProperty("DEBUG") != null) {
                                System.out.println("ProcessCalculation-> ...inserting");
                            }
                            if (test != null) continue;
                            officeTransDetails.insert(prodDb);
                        }
                    }
                    for (String key : providerTransactions.keySet()) {
                        FolderInsertRecord val = (FolderInsertRecord)((Object)providerTransactions.get(key));
                        providerTransDetails.setLinkItemId((Integer)providerOrgMapping.get(key));
                        context.getRequest().setAttribute("cf" + providerTransactionDetailsIds.get(0), (Object)key);
                        context.getRequest().setAttribute("cf" + providerTransactionDetailsIds.get(1), (Object)recordList.getPerformedString());
                        context.getRequest().setAttribute("cf" + providerTransactionDetailsIds.get(2), (Object)(val.getEligibility() + ""));
                        context.getRequest().setAttribute("cf" + providerTransactionDetailsIds.get(3), (Object)(val.getClaimStatus() + ""));
                        context.getRequest().setAttribute("cf" + providerTransactionDetailsIds.get(4), (Object)(val.getReferral() + ""));
                        context.getRequest().setAttribute("cf" + providerTransactionDetailsIds.get(5), (Object)(val.getAdvice() + ""));
                        context.getRequest().setAttribute("cf" + providerTransactionDetailsIds.get(6), (Object)(val.getDental() + ""));
                        context.getRequest().setAttribute("cf" + providerTransactionDetailsIds.get(7), (Object)(val.getProfessional() + ""));
                        context.getRequest().setAttribute("cf" + providerTransactionDetailsIds.get(8), (Object)(val.getInstitutional() + ""));
                        context.getRequest().setAttribute("cf" + providerTransactionDetailsIds.get(9), (Object)(val.getClaimRemittance() + ""));
                        providerTransDetails.setParameters(context);
                        if (System.getProperty("DEBUG") != null) {
                            System.out.println("ProcessCalculation-> Inserting provider transactions: " + key);
                        }
                        if (test != null || providerTransDetails.insert(prodDb) <= -1) continue;
                        ++providerRecordsInserted;
                    }
                    if (systemStatus != null) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("${recordList.size}", "" + recordList.size());
                        map.put("${providerRecordsInserted}", "" + providerRecordsInserted);
                        map.put("${errors.size}", "" + errors.size());
                        sb.append(this.getLabel(map, systemStatus.getLabel("mail.body.transactionDataSet1")));
                    } else {
                        sb.append(recordList.size() + " total record(s) processed<br>");
                        sb.append(providerRecordsInserted + " Provider Transaction Details record(s) inserted<br>");
                        sb.append(errors.size() + " record(s) rejected<br><br>");
                    }
                    for (Integer k : errors.keySet()) {
                        String em = (String)errors.get(k);
                        TransactionRecord tempRec = new TransactionRecord(db, k);
                        if (systemStatus != null) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("${tempRec.transactionId}", tempRec.getTransactionId());
                            map.put("${tempRec.taxId}", "" + tempRec.getTaxId());
                            map.put("${tempRec.nameLast}", tempRec.getNameLast());
                            map.put("${tempRec.payerId}", "" + tempRec.getPayerId());
                            map.put("${em}", em);
                            sb.append(this.getLabel(map, systemStatus.getLabel("mail.body.transactionDataSet2")));
                            continue;
                        }
                        sb.append("-------------------------<br><br>");
                        sb.append("Transaction ID : " + tempRec.getTransactionId() + "<br>");
                        sb.append("Provider Tax ID: " + tempRec.getTaxId() + "<br>");
                        sb.append("Provider Last Name: " + tempRec.getNameLast() + "<br>");
                        sb.append("Vendor (Payer) ID: " + tempRec.getPayerId() + "<br><br>");
                        sb.append(em + "<br><br>");
                    }
                    prodDb.close();
                    if (sqlDriver == null) break block51;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block52;
                }
                finally {
                    if (sqlDriver != null) {
                        sqlDriver.free(prodDb);
                        sqlDriver.closeAllConnections();
                        sqlDriver = null;
                    }
                    this.freeConnection(context, db);
                }
                sqlDriver.free(prodDb);
                sqlDriver.closeAllConnections();
                sqlDriver = null;
            }
            this.freeConnection(context, db);
        }
        if (ce != null) {
            SMTPMessage mail = new SMTPMessage();
            mail.setHost(ProcessCalculation.getPref(context, "MAILSERVER"));
            mail.setFrom(ProcessCalculation.getPref(context, "EMAILADDRESS"));
            mail.setType("text/html");
            mail.setTo(this.getValue(context, ce, "ERROR_REPORT_ADDRESS"));
            if (systemStatus != null) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("${month}", "" + month);
                map.put("${dayOfMonth}", "" + cal.get(5));
                map.put("${year}", "" + cal.get(1));
                String subject = systemStatus.getLabel("mail.subject.transactionDataSummery");
                mail.setSubject(this.getLabel(map, subject));
                if (sb.length() == 0) {
                    mail.setBody(systemStatus.getLabel("mail.body.mailProcessingError"));
                } else {
                    mail.setBody(sb.toString());
                }
            } else {
                mail.setSubject("EDIT transaction data summary: " + month + "/" + cal.get(5) + "/" + cal.get(1));
                if (sb.length() == 0) {
                    mail.setBody("* A PROCESSING ERROR HAS OCCURRED, THE APPLICATION NEEDS TO BE CHECKED");
                } else {
                    mail.setBody(sb.toString());
                }
            }
            if (mail.send() == 2) {
                System.err.println(mail.getErrorMsg());
            } else {
                System.err.println("ProcessCalculation-> Sending report to " + this.getValue(context, ce, "ERROR_REPORT_ADDRESS"));
            }
        }
        return "-none-";
    }

    private int getValueAsInt(ActionContext context, ConnectionElement ce, String param) {
        return this.getSystemStatus(context, ce).getValueAsInt("org.aspcfs.modules.healthcare.edit.actions.ProcessCalculation", param);
    }

    private String getValue(ActionContext context, ConnectionElement ce, String param) {
        return this.getSystemStatus(context, ce).getValue("org.aspcfs.modules.healthcare.edit.actions.ProcessCalculation", param);
    }

    public String getLabel(HashMap map, String input) {
        Template template = new Template(input);
        template.setParseElements(map);
        return template.getParsedText();
    }
}

