/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.healthcare.edit.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.util.ArrayList;
import org.aspcfs.modules.healthcare.edit.base.TransactionRecord;
import org.aspcfs.utils.StringUtils;

public class FolderInsertRecord
extends GenericBean {
    private String id = null;
    private String payorId = null;
    private String providerId = null;
    private int eligibility = 0;
    private int claimStatus = 0;
    private int referral = 0;
    private int advice = 0;
    private int dental = 0;
    private int professional = 0;
    private int institutional = 0;
    private int claimRemittance = 0;

    public FolderInsertRecord() {
    }

    public FolderInsertRecord(String transId, String payor) {
        this.id = transId;
        this.payorId = payor;
    }

    public FolderInsertRecord(String transId, String payor, String provider) {
        this.id = transId;
        this.payorId = payor;
        this.providerId = provider;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPayorId() {
        return this.payorId;
    }

    public void setPayorId(String payorId) {
        this.payorId = payorId;
    }

    public boolean process(TransactionRecord tr) {
        if (tr.getType().equals("270")) {
            this.setEligibility(this.getEligibility() + 1);
        } else if (tr.getType().equals("276")) {
            this.setClaimStatus(this.getClaimStatus() + 1);
        } else if (tr.getType().equals("278REQ")) {
            this.setReferral(this.getReferral() + 1);
        } else if (tr.getType().equals("824")) {
            this.setAdvice(this.getAdvice() + 1);
        } else if (tr.getType().equals("837D")) {
            this.setDental(this.getDental() + 1);
        } else if (tr.getType().equals("837P")) {
            this.setProfessional(this.getProfessional() + 1);
        } else if (tr.getType().equals("837I")) {
            this.setInstitutional(this.getInstitutional() + 1);
        } else if (tr.getType().equals("835")) {
            this.setClaimRemittance(this.getClaimRemittance() + 1);
        } else {
            return false;
        }
        return true;
    }

    public int getEligibility() {
        return this.eligibility;
    }

    public void setEligibility(int eligibility) {
        this.eligibility = eligibility;
    }

    public void setEligibility(String eligibility) {
        this.eligibility = Integer.parseInt(eligibility);
    }

    public int getClaimStatus() {
        return this.claimStatus;
    }

    public void setClaimStatus(int claimStatus) {
        this.claimStatus = claimStatus;
    }

    public void setClaimStatus(String claimStatus) {
        this.claimStatus = Integer.parseInt(claimStatus);
    }

    public int getReferral() {
        return this.referral;
    }

    public void setReferral(int referral) {
        this.referral = referral;
    }

    public void setReferral(String referral) {
        this.referral = Integer.parseInt(referral);
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public int getDental() {
        return this.dental;
    }

    public void setDental(int dental) {
        this.dental = dental;
    }

    public void setDental(String dental) {
        this.dental = Integer.parseInt(dental);
    }

    public int getProfessional() {
        return this.professional;
    }

    public void setProfessional(int professional) {
        this.professional = professional;
    }

    public void setProfessional(String professional) {
        this.professional = Integer.parseInt(professional);
    }

    public int getInstitutional() {
        return this.institutional;
    }

    public void setInstitutional(int institutional) {
        this.institutional = institutional;
    }

    public void setInstitutional(String institutional) {
        this.institutional = Integer.parseInt(institutional);
    }

    public int getClaimRemittance() {
        return this.claimRemittance;
    }

    public void setClaimRemittance(int claimRemittance) {
        this.claimRemittance = claimRemittance;
    }

    public void setClaimRemittance(String claimRemittance) {
        this.claimRemittance = Integer.parseInt(claimRemittance);
    }

    public int getAdvice() {
        return this.advice;
    }

    public void setAdvice(int advice) {
        this.advice = advice;
    }

    public void setAdvice(String advice) {
        this.advice = Integer.parseInt(advice);
    }

    public void updateTotals(ArrayList oldVals) {
        this.eligibility = this.getEligibility() + StringUtils.parseInt((String)oldVals.get(0), 0);
        this.claimStatus = this.getClaimStatus() + StringUtils.parseInt((String)oldVals.get(1), 0);
        this.referral = this.getReferral() + StringUtils.parseInt((String)oldVals.get(2), 0);
        this.advice = this.getAdvice() + StringUtils.parseInt((String)oldVals.get(3), 0);
        this.dental = this.getDental() + StringUtils.parseInt((String)oldVals.get(4), 0);
        this.professional = this.getProfessional() + StringUtils.parseInt((String)oldVals.get(5), 0);
        this.institutional = this.getInstitutional() + StringUtils.parseInt((String)oldVals.get(6), 0);
        this.claimRemittance = this.getClaimRemittance() + StringUtils.parseInt((String)oldVals.get(7), 0);
    }
}

