/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.healthcare.edit.base;

import com.darkhorseventures.framework.actions.ActionContext;
import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;

public class TransactionRecord
extends GenericBean {
    protected int id = -1;
    protected String taxId = null;
    protected String licenseNumber = null;
    protected String npi = null;
    protected String providerId = null;
    protected String nameLast = null;
    protected String nameFirst = null;
    protected String payerId = null;
    protected String type = null;
    protected String transactionId = null;
    protected String transactionDate = null;
    protected String transactionTime = null;
    protected Date performedDate = null;
    protected Timestamp performed = null;
    protected Timestamp entered = null;

    public TransactionRecord() {
    }

    public TransactionRecord(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public TransactionRecord(Connection db, String id) throws SQLException {
        this.queryRecord(db, Integer.parseInt(id));
    }

    public TransactionRecord(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public String getTransactionDate() {
        return this.transactionDate;
    }

    public void setTransactionDate(String transactionDate) {
        this.transactionDate = transactionDate;
        this.setPerformedDate(transactionDate);
        this.processPerformed();
    }

    public Date getPerformedDate() {
        return this.performedDate;
    }

    public void setPerformedDate(Date performedDate) {
        this.performedDate = performedDate;
    }

    public void setPerformedDate(String tmp) {
        this.performedDate = DateUtils.parseDateString(tmp, "yyyy-MM-dd");
    }

    public String getPerformedDateString() {
        String tmp = "";
        try {
            return DateFormat.getDateInstance(3).format(this.performedDate);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public String getTransactionTime() {
        return this.transactionTime;
    }

    public void setTransactionTime(String transactionTime) {
        this.transactionTime = transactionTime;
        this.processPerformed();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setId(String id) {
        this.id = Integer.parseInt(id);
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    public void setProviderTaxID(String taxId) {
        this.setTaxId(taxId);
    }

    public String getTaxId() {
        return this.taxId;
    }

    public String getLicenseNumber() {
        return this.licenseNumber;
    }

    public void setLicenseNumber(String licenseNumber) {
        this.licenseNumber = licenseNumber;
    }

    public String getNpi() {
        return this.npi;
    }

    public void setNpi(String npi) {
        this.npi = npi;
    }

    public void setProviderNPI(String npi) {
        this.setNpi(npi);
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public String getNameLast() {
        return this.nameLast;
    }

    public void setNameLast(String nameLast) {
        this.nameLast = nameLast;
    }

    public void setProviderLastName(String nameLast) {
        this.setNameLast(nameLast);
    }

    public String getNameFirst() {
        return this.nameFirst;
    }

    public void setNameFirst(String nameFirst) {
        this.nameFirst = nameFirst;
    }

    public void setProviderFirstName(String nameFirst) {
        this.setNameFirst(nameFirst);
    }

    public String getPayerId() {
        return this.payerId;
    }

    public void setPayerId(String payerId) {
        this.payerId = payerId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type != null ? type.toUpperCase() : null;
    }

    public void setTransactionType(String type) {
        this.setType(type);
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setTransactionID(String transactionId) {
        this.setTransactionId(transactionId);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setPerformed(Timestamp tmp) {
        this.performed = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DateUtils.parseTimestampString(tmp);
    }

    public void setPerformed(String tmp) {
        this.performed = DateUtils.parseTimestampString(tmp, "yyyy-MM-dd hh:mm:ss a");
    }

    private void processPerformed() {
        if (this.transactionDate != null && this.transactionTime != null) {
            this.setPerformed(this.transactionDate + " " + this.transactionTime);
        }
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public Timestamp getPerformed() {
        return this.performed;
    }

    public String getEnteredString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public String getPerformedString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.performed);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "billing_transaction_id_seq");
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO billing_transaction (tax_id, license_no, npi, provider_id, namelast, namefirst, payer_id, " + DatabaseUtils.addQuotes(db, "type") + ", ");
        if (this.performedDate != null) {
            sql.append("date_performed, ");
        }
        if (this.performed != null) {
            sql.append("performed, ");
        }
        if (this.id > -1) {
            sql.append("transaction_id, ");
        }
        if (this.entered != null) {
            sql.append("entered, ");
        }
        sql.append("trans_id ) ");
        sql.append("VALUES (?, ?, ?, ?, ?, ?, ?, ?, ");
        if (this.performedDate != null) {
            sql.append("?, ");
        }
        if (this.performed != null) {
            sql.append("?, ");
        }
        if (this.id > -1) {
            sql.append("?, ");
        }
        if (this.entered != null) {
            sql.append("?, ");
        }
        sql.append("?) ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.getTaxId());
        pst.setString(++i, this.getLicenseNumber());
        pst.setString(++i, this.getNpi());
        pst.setString(++i, this.getProviderId());
        pst.setString(++i, this.getNameLast());
        pst.setString(++i, this.getNameFirst());
        pst.setString(++i, this.getPayerId());
        pst.setString(++i, this.getType());
        if (this.performedDate != null) {
            pst.setDate(++i, this.performedDate);
        }
        if (this.performed != null) {
            pst.setTimestamp(++i, this.performed);
        }
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.entered != null) {
            pst.setTimestamp(++i, this.entered);
        }
        pst.setString(++i, this.getTransactionId());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "billing_transaction_id_seq", this.id);
        return true;
    }

    public boolean insert(Connection db, ActionContext context) throws SQLException {
        return this.insert(db);
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("TransactionRecord ID not specified.");
        }
        int resultCount = 0;
        PreparedStatement pst = db.prepareStatement("DELETE FROM billing_transaction WHERE id = ? ");
        pst.setInt(1, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        if (resultCount == 0) {
            this.errors.put("actionError", "Transaction Record (ID: " + this.getId() + ") could not be deleted.");
            return false;
        }
        return true;
    }

    private void queryRecord(Connection db, int id) throws SQLException {
        if (id < 0) {
            throw new SQLException("TransactionRecord ID not specified.");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT bt.* FROM billing_transaction bt WHERE bt.id = ? ");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (!rs.next()) {
            rs.close();
            pst.close();
            throw new SQLException("Transaction Record not found.");
        }
        this.buildRecord(rs);
        rs.close();
        pst.close();
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("id");
        this.taxId = rs.getString("tax_id");
        this.licenseNumber = rs.getString("license_no");
        this.npi = rs.getString("npi");
        this.providerId = rs.getString("provider_id");
        this.nameLast = rs.getString("nameLast");
        this.nameFirst = rs.getString("nameFirst");
        this.payerId = rs.getString("payer_id");
        this.type = rs.getString("type");
        this.transactionId = rs.getString("trans_id");
        this.performedDate = rs.getDate("date_performed");
        this.performed = rs.getTimestamp("performed");
        this.entered = rs.getTimestamp("entered");
    }
}

