/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.healthcare.edit.base;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.Vector;
import org.aspcfs.modules.healthcare.edit.base.TransactionRecord;
import org.aspcfs.utils.web.PagedListInfo;

public class TransactionRecordList
extends Vector {
    private PagedListInfo pagedListInfo = null;
    private Date performed = null;

    public Date getPerformed() {
        return this.performed;
    }

    public void setPerformed(Date performed) {
        this.performed = performed;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setPagedListInfo(PagedListInfo pagedListInfo) {
        this.pagedListInfo = pagedListInfo;
    }

    public String getPerformedString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.performed);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        while (rs.next()) {
            TransactionRecord thisTransaction = this.getObject(rs);
            this.add(thisTransaction);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
    }

    public TransactionRecord getObject(ResultSet rs) throws SQLException {
        TransactionRecord thisTransaction = new TransactionRecord(rs);
        return thisTransaction;
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM billing_transaction bt WHERE bt.id >= 0 ");
        this.createFilter(sqlFilter);
        sqlOrder.append("ORDER BY bt.id ");
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("bt.* FROM billing_transaction bt WHERE bt.id > 0 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        return rs;
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.performed != null) {
            sqlFilter.append("AND date_performed = ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.performed != null) {
            pst.setDate(++i, this.performed);
        }
        return i;
    }
}

