/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.help.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.webutils.FileDownload;
import java.net.SocketException;
import java.sql.Connection;
import java.util.StringTokenizer;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.PermissionCategoryList;
import org.aspcfs.modules.help.base.HelpBusinessRule;
import org.aspcfs.modules.help.base.HelpFeature;
import org.aspcfs.modules.help.base.HelpItem;
import org.aspcfs.modules.help.base.HelpNote;
import org.aspcfs.modules.help.base.HelpTip;
import org.aspcfs.utils.web.LookupElement;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.RequestUtils;

public final class QA
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDefault(ActionContext context) {
        if (!this.hasPermission(context, "qa-view")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            String module = context.getRequest().getParameter("module");
            String section = context.getRequest().getParameter("section");
            String subsection = context.getRequest().getParameter("sub");
            db = this.getConnection(context);
            HelpItem thisItem = new HelpItem();
            thisItem.setModule(module);
            thisItem.setSection(section);
            thisItem.setSubsection(subsection);
            thisItem.setBuildFeatures(true);
            thisItem.setBuildRules(true);
            thisItem.setBuildNotes(true);
            thisItem.setBuildTips(true);
            thisItem.processRecord(db, this.getUserId(context));
            context.getRequest().setAttribute("Help", (Object)thisItem);
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return QA.getReturn(context, "QA");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyIntro(ActionContext context) {
        if (!this.hasPermission(context, "qa-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        String helpId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            HelpItem thisItem = new HelpItem(db, Integer.parseInt(helpId));
            context.getRequest().setAttribute("Help", (Object)thisItem);
            PermissionCategoryList pcl = new PermissionCategoryList();
            pcl.setEmptyHtmlSelectRecord("-None-");
            pcl.buildList(db);
            context.getRequest().setAttribute("permissionCategoryList", (Object)pcl);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return QA.getReturn(context, "ModifyIntro");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveIntro(ActionContext context) {
        if (!this.hasPermission(context, "qa-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        HelpItem thisItem = (HelpItem)((Object)context.getFormBean());
        try {
            db = this.getConnection(context);
            thisItem.setModifiedBy(this.getUserId(context));
            thisItem.update(db);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("refreshUrl", (Object)("QA.do?module=" + thisItem.getModule() + (thisItem.getSection() != null ? "&section=" + thisItem.getSection() : "") + (thisItem.getSubsection() != null ? "&subsection=" + thisItem.getSubsection() : "") + RequestUtils.addLinkParams(context.getRequest(), "popup")));
        return QA.getReturn(context, "SaveIntro");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPrepareFeature(ActionContext context) {
        if (!this.hasPermission(context, "qa-add")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            LookupList generalFeatures = new LookupList(db, "lookup_help_features");
            context.getRequest().setAttribute("GeneralFeatures", (Object)generalFeatures);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return QA.getReturn(context, "FeaturePrepare");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyFeature(ActionContext context) {
        if (!this.hasPermission(context, "qa-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        String featureId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            HelpFeature thisFeature = new HelpFeature(db, Integer.parseInt(featureId));
            context.getRequest().setAttribute("Feature", (Object)thisFeature);
            LookupList generalFeatures = new LookupList(db, "lookup_help_features");
            context.getRequest().setAttribute("GeneralFeatures", (Object)generalFeatures);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return QA.getReturn(context, "FeatureModify");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveFeature(ActionContext context) {
        Connection db = null;
        boolean recordInserted = false;
        int resultCount = -1;
        HelpFeature thisFeature = (HelpFeature)((Object)context.getFormBean());
        if (thisFeature.getLinkFeatureId() > 0 ? !this.hasPermission(context, "qa-edit") : !this.hasPermission(context, "qa-add")) {
            return "PermissionError";
        }
        try {
            db = this.getConnection(context);
            thisFeature.setModifiedBy(this.getUserId(context));
            if (thisFeature.getLinkFeatureId() > 0) {
                LookupElement thisElement = new LookupElement(db, thisFeature.getLinkFeatureId(), "lookup_help_features");
                thisFeature.setDescription(thisElement.getDescription());
            }
            if (thisFeature.getComplete()) {
                thisFeature.setCompletedBy(this.getUserId(context));
            }
            if (thisFeature.getId() > 0) {
                resultCount = thisFeature.update(db);
            } else {
                thisFeature.setEnteredBy(this.getUserId(context));
                recordInserted = thisFeature.insert(db);
            }
            HelpItem thisItem = new HelpItem(db, thisFeature.getLinkHelpId());
            context.getRequest().setAttribute("refreshUrl", (Object)("QA.do?module=" + thisItem.getModule() + (thisItem.getSection() != null ? "&section=" + thisItem.getSection() : "") + (thisItem.getSubsection() != null ? "&subsection=" + thisItem.getSubsection() : "") + RequestUtils.addLinkParams(context.getRequest(), "popup")));
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        String target = context.getRequest().getParameter("target");
        if (resultCount == 1) {
            if ("loop".equals(target)) {
                context.getRequest().setAttribute("redirectUrl", (Object)("HelpFeatures.do?command=PrepareFeature&linkHelpId=" + thisFeature.getLinkHelpId() + "&target=" + target));
                return QA.getReturn(context, "FeatureReInsert");
            }
            return QA.getReturn(context, "FeatureUpdate");
        }
        if (recordInserted) {
            if ("loop".equals(target)) {
                context.getRequest().setAttribute("redirectUrl", (Object)("HelpFeatures.do?command=PrepareFeature&linkHelpId=" + thisFeature.getLinkHelpId() + "&target=" + target));
                return QA.getReturn(context, "FeatureReInsert");
            }
            return QA.getReturn(context, "FeatureInsert");
        }
        if (thisFeature.getId() > 0) {
            context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        } else {
            this.processErrors(context, thisFeature.getErrors());
        }
        return QA.getReturn(context, "FeaturePrepare");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteFeature(ActionContext context) {
        if (!this.hasPermission(context, "qa-delete")) {
            return "PermissionError";
        }
        Connection db = null;
        String featureId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            HelpFeature thisFeature = new HelpFeature(db, Integer.parseInt(featureId));
            thisFeature.delete(db);
            HelpItem thisItem = new HelpItem(db, thisFeature.getLinkHelpId());
            context.getRequest().setAttribute("Help", (Object)thisItem);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return QA.getReturn(context, "FeatureDelete");
    }

    public String executeCommandProcessFeature(ActionContext context) {
        if (!this.hasPermission(context, "qa-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        int count = 0;
        String id = context.getRequest().getParameter("id");
        try {
            StringTokenizer st = new StringTokenizer(id, "|");
            String fileName = st.nextToken();
            String imageType = st.nextToken();
            int featureId = Integer.parseInt(st.nextToken());
            int status = Integer.parseInt(st.nextToken());
            db = this.getConnection(context);
            HelpFeature thisFeature = new HelpFeature(db, featureId);
            if (status == HelpFeature.DONE) {
                thisFeature.setComplete(true);
                thisFeature.setCompletedBy(this.getUserId(context));
            } else {
                thisFeature.setComplete(false);
            }
            count = thisFeature.update(db);
            this.freeConnection(context, db);
            if (count != -1) {
                String filePath = context.getServletContext().getRealPath("/") + "images" + fs + fileName;
                FileDownload fileDownload = new FileDownload();
                fileDownload.setFullPath(filePath);
                fileDownload.setDisplayName(fileName);
                if (fileDownload.fileExists()) {
                    fileDownload.sendFile(context, "image/" + imageType);
                } else {
                    System.err.println("Image-> Trying to send a file that does not exist");
                }
            } else {
                this.processErrors(context, thisFeature.getErrors());
            }
        }
        catch (SocketException se) {
            System.out.println("HelpFeature -> ProcessImage : Download canceled or connection lost");
        }
        catch (Exception e) {
            this.freeConnection(context, db);
            System.out.println(e.toString());
            context.getRequest().setAttribute("Error", (Object)e);
            return "SystemError";
        }
        return "-none-";
    }

    public String executeCommandPrepareRule(ActionContext context) {
        if (!this.hasPermission(context, "qa-add")) {
            return "PermissionError";
        }
        return QA.getReturn(context, "RulePrepare");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyRule(ActionContext context) {
        if (!this.hasPermission(context, "qa-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        String ruleId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            HelpBusinessRule thisRule = new HelpBusinessRule(db, Integer.parseInt(ruleId));
            context.getRequest().setAttribute("BusinessRule", (Object)thisRule);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return QA.getReturn(context, "RuleModify");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveRule(ActionContext context) {
        Connection db = null;
        boolean recordInserted = false;
        int resultCount = -1;
        HelpBusinessRule thisRule = (HelpBusinessRule)((Object)context.getFormBean());
        try {
            db = this.getConnection(context);
            thisRule.setModifiedBy(this.getUserId(context));
            if (thisRule.getId() > 0) {
                if (!this.hasPermission(context, "qa-edit")) {
                    String string = "PermissionError";
                    return string;
                }
                thisRule.setCompletedBy(this.getUserId(context));
                resultCount = thisRule.update(db);
            } else {
                if (!this.hasPermission(context, "qa-add")) {
                    String string = "PermissionError";
                    return string;
                }
                thisRule.setEnteredBy(this.getUserId(context));
                recordInserted = thisRule.insert(db);
            }
            HelpItem thisItem = new HelpItem(db, thisRule.getLinkHelpId());
            context.getRequest().setAttribute("refreshUrl", (Object)("QA.do?module=" + thisItem.getModule() + (thisItem.getSection() != null ? "&section=" + thisItem.getSection() : "") + (thisItem.getSubsection() != null ? "&subsection=" + thisItem.getSubsection() : "") + RequestUtils.addLinkParams(context.getRequest(), "popup")));
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        String target = context.getRequest().getParameter("target");
        if (resultCount == 1) {
            if ("loop".equals(target)) {
                context.getRequest().setAttribute("redirectUrl", (Object)("HelpRules.do?command=PrepareRule&linkHelpId=" + thisRule.getLinkHelpId() + "&target=" + target));
                return QA.getReturn(context, "RuleReInsert");
            }
            return QA.getReturn(context, "RuleUpdate");
        }
        if (recordInserted) {
            if ("loop".equals(target)) {
                context.getRequest().setAttribute("redirectUrl", (Object)("HelpRules.do?command=PrepareRule&linkHelpId=" + thisRule.getLinkHelpId() + "&target=" + target));
                return QA.getReturn(context, "RuleReInsert");
            }
            return QA.getReturn(context, "RuleInsert");
        }
        if (thisRule.getId() > 0) {
            context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        } else {
            this.processErrors(context, thisRule.getErrors());
        }
        return QA.getReturn(context, "RulePrepare");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteRule(ActionContext context) {
        if (!this.hasPermission(context, "qa-delete")) {
            return "PermissionError";
        }
        Connection db = null;
        String ruleId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            HelpBusinessRule thisRule = new HelpBusinessRule(db, Integer.parseInt(ruleId));
            thisRule.delete(db);
            HelpItem thisItem = new HelpItem(db, thisRule.getLinkHelpId());
            context.getRequest().setAttribute("Help", (Object)thisItem);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return QA.getReturn(context, "RuleDelete");
    }

    public String executeCommandProcessRule(ActionContext context) {
        if (!this.hasPermission(context, "qa-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        int count = 0;
        String id = context.getRequest().getParameter("id");
        try {
            StringTokenizer st = new StringTokenizer(id, "|");
            String fileName = st.nextToken();
            String imageType = st.nextToken();
            int itemId = Integer.parseInt(st.nextToken());
            int status = Integer.parseInt(st.nextToken());
            db = this.getConnection(context);
            HelpBusinessRule thisRule = new HelpBusinessRule(db, itemId);
            if (status == HelpBusinessRule.DONE) {
                thisRule.setComplete(true);
                thisRule.setCompletedBy(this.getUserId(context));
            } else {
                thisRule.setComplete(false);
            }
            count = thisRule.update(db);
            this.freeConnection(context, db);
            if (count != -1) {
                String filePath = context.getServletContext().getRealPath("/") + "images" + fs + fileName;
                FileDownload fileDownload = new FileDownload();
                fileDownload.setFullPath(filePath);
                fileDownload.setDisplayName(fileName);
                if (fileDownload.fileExists()) {
                    fileDownload.sendFile(context, "image/" + imageType);
                } else {
                    System.err.println("Image-> Trying to send a file that does not exist");
                }
            } else {
                this.processErrors(context, thisRule.getErrors());
            }
        }
        catch (SocketException se) {
            System.out.println("HelpBusinessRule -> ProcessImage : Download canceled or connection lost");
        }
        catch (Exception e) {
            this.freeConnection(context, db);
            System.out.println(e.toString());
            context.getRequest().setAttribute("Error", (Object)e);
            return "SystemError";
        }
        return "-none-";
    }

    public String executeCommandPrepareTip(ActionContext context) {
        if (!this.hasPermission(context, "qa-add")) {
            return "PermissionError";
        }
        return QA.getReturn(context, "TipPrepare");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyTip(ActionContext context) {
        if (!this.hasPermission(context, "qa-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        String tipId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            HelpTip thisTip = new HelpTip(db, Integer.parseInt(tipId));
            context.getRequest().setAttribute("Tip", (Object)thisTip);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return QA.getReturn(context, "TipModify");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveTip(ActionContext context) {
        Connection db = null;
        boolean recordInserted = false;
        int resultCount = -1;
        HelpTip thisTip = (HelpTip)((Object)context.getFormBean());
        try {
            db = this.getConnection(context);
            thisTip.setModifiedBy(this.getUserId(context));
            if (thisTip.getId() > 0) {
                if (!this.hasPermission(context, "qa-edit")) {
                    String string = "PermissionError";
                    return string;
                }
                resultCount = thisTip.update(db);
            } else {
                if (!this.hasPermission(context, "qa-add")) {
                    String string = "PermissionError";
                    return string;
                }
                thisTip.setEnteredBy(this.getUserId(context));
                recordInserted = thisTip.insert(db);
            }
            HelpItem thisItem = new HelpItem(db, thisTip.getLinkHelpId());
            context.getRequest().setAttribute("refreshUrl", (Object)("QA.do?module=" + thisItem.getModule() + (thisItem.getSection() != null ? "&section=" + thisItem.getSection() : "") + (thisItem.getSubsection() != null ? "&subsection=" + thisItem.getSubsection() : "") + RequestUtils.addLinkParams(context.getRequest(), "popup")));
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        String target = context.getRequest().getParameter("target");
        if (resultCount == 1) {
            if ("loop".equals(target)) {
                context.getRequest().setAttribute("redirectUrl", (Object)("HelpTips.do?command=PrepareTip&linkHelpId=" + thisTip.getLinkHelpId() + "&target=" + target));
                return QA.getReturn(context, "TipReInsert");
            }
            return QA.getReturn(context, "TipUpdate");
        }
        if (recordInserted) {
            if ("loop".equals(target)) {
                context.getRequest().setAttribute("redirectUrl", (Object)("HelpTips.do?command=PrepareTip&linkHelpId=" + thisTip.getLinkHelpId() + "&target=" + target));
                return QA.getReturn(context, "TipReInsert");
            }
            return QA.getReturn(context, "TipInsert");
        }
        if (thisTip.getId() > 0) {
            context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        } else {
            this.processErrors(context, thisTip.getErrors());
        }
        return QA.getReturn(context, "TipPrepare");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteTip(ActionContext context) {
        if (!this.hasPermission(context, "qa-delete")) {
            return "PermissionError";
        }
        Connection db = null;
        String tipId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            HelpTip thisTip = new HelpTip(db, Integer.parseInt(tipId));
            thisTip.delete(db);
            HelpItem thisItem = new HelpItem(db, thisTip.getLinkHelpId());
            context.getRequest().setAttribute("Help", (Object)thisItem);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return QA.getReturn(context, "TipDelete");
    }

    public String executeCommandPrepareNote(ActionContext context) {
        if (!this.hasPermission(context, "qa-add")) {
            return "PermissionError";
        }
        return QA.getReturn(context, "NotePrepare");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyNote(ActionContext context) {
        if (!this.hasPermission(context, "qa-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        String noteId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            HelpNote thisNote = new HelpNote(db, Integer.parseInt(noteId));
            context.getRequest().setAttribute("Note", (Object)thisNote);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return QA.getReturn(context, "NoteModify");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveNote(ActionContext context) {
        Connection db = null;
        boolean recordInserted = false;
        int resultCount = -1;
        HelpNote thisNote = (HelpNote)((Object)context.getFormBean());
        try {
            db = this.getConnection(context);
            thisNote.setModifiedBy(this.getUserId(context));
            if (thisNote.getComplete()) {
                thisNote.setCompletedBy(this.getUserId(context));
            }
            if (thisNote.getId() > 0) {
                if (!this.hasPermission(context, "qa-edit")) {
                    String string = "PermissionError";
                    return string;
                }
                thisNote.setCompletedBy(this.getUserId(context));
                resultCount = thisNote.update(db);
            } else {
                if (!this.hasPermission(context, "qa-add")) {
                    String string = "PermissionError";
                    return string;
                }
                thisNote.setEnteredBy(this.getUserId(context));
                recordInserted = thisNote.insert(db);
            }
            HelpItem thisItem = new HelpItem(db, thisNote.getLinkHelpId());
            context.getRequest().setAttribute("refreshUrl", (Object)("QA.do?module=" + thisItem.getModule() + (thisItem.getSection() != null ? "&section=" + thisItem.getSection() : "") + (thisItem.getSubsection() != null ? "&subsection=" + thisItem.getSubsection() : "") + RequestUtils.addLinkParams(context.getRequest(), "popup")));
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        String target = context.getRequest().getParameter("target");
        if (resultCount == 1) {
            if ("loop".equals(target)) {
                context.getRequest().setAttribute("redirectUrl", (Object)("HelpNotes.do?command=PrepareNote&linkHelpId=" + thisNote.getLinkHelpId() + "&target=" + target));
                return QA.getReturn(context, "NoteReInsert");
            }
            return QA.getReturn(context, "NoteUpdate");
        }
        if (recordInserted) {
            if ("loop".equals(target)) {
                context.getRequest().setAttribute("redirectUrl", (Object)("HelpNotes.do?command=PrepareNote&linkHelpId=" + thisNote.getLinkHelpId() + "&target=" + target));
                return QA.getReturn(context, "NoteReInsert");
            }
            return QA.getReturn(context, "NoteInsert");
        }
        if (thisNote.getId() > 0) {
            context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        } else {
            this.processErrors(context, thisNote.getErrors());
        }
        return QA.getReturn(context, "NotePrepare");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteNote(ActionContext context) {
        if (!this.hasPermission(context, "qa-delete")) {
            return "PermissionError";
        }
        Connection db = null;
        String noteId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            HelpNote thisNote = new HelpNote(db, Integer.parseInt(noteId));
            thisNote.delete(db);
            HelpItem thisItem = new HelpItem(db, thisNote.getLinkHelpId());
            context.getRequest().setAttribute("Help", (Object)thisItem);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return QA.getReturn(context, "NoteDelete");
    }

    public String executeCommandProcessNote(ActionContext context) {
        if (!this.hasPermission(context, "qa-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        int count = 0;
        String id = context.getRequest().getParameter("id");
        try {
            StringTokenizer st = new StringTokenizer(id, "|");
            String fileName = st.nextToken();
            String imageType = st.nextToken();
            int noteId = Integer.parseInt(st.nextToken());
            int status = Integer.parseInt(st.nextToken());
            db = this.getConnection(context);
            HelpNote thisNote = new HelpNote(db, noteId);
            if (status == HelpNote.DONE) {
                thisNote.setComplete(true);
                thisNote.setCompletedBy(this.getUserId(context));
            } else {
                thisNote.setComplete(false);
            }
            count = thisNote.update(db);
            this.freeConnection(context, db);
            if (count != -1) {
                String filePath = context.getServletContext().getRealPath("/") + "images" + fs + fileName;
                FileDownload fileDownload = new FileDownload();
                fileDownload.setFullPath(filePath);
                fileDownload.setDisplayName(fileName);
                if (fileDownload.fileExists()) {
                    fileDownload.sendFile(context, "image/" + imageType);
                } else {
                    System.err.println("Image-> Trying to send a file that does not exist");
                }
            } else {
                this.processErrors(context, thisNote.getErrors());
            }
        }
        catch (SocketException se) {
            System.out.println("HelpNote -> ProcessImage : Download canceled or connection lost");
        }
        catch (Exception e) {
            this.freeConnection(context, db);
            System.out.println(e.toString());
            context.getRequest().setAttribute("Error", (Object)e);
            return "SystemError";
        }
        return "-none-";
    }
}

