/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.help.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import org.aspcfs.utils.DatabaseUtils;

public class HelpBusinessRule
extends GenericBean {
    public static int DONE = 1;
    private int id = -1;
    private int linkHelpId = -1;
    private String description = null;
    private int enteredBy = -1;
    private Timestamp entered = null;
    private int modifiedBy = -1;
    private Timestamp modified = null;
    private boolean complete = false;
    private Timestamp completeDate = null;
    private int completedBy = -1;
    private boolean enabled = true;

    public HelpBusinessRule() {
    }

    public HelpBusinessRule(Connection db, int thisId) throws SQLException {
        if (thisId == -1) {
            throw new SQLException("Feature ID not specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT f.* FROM help_business_rules f WHERE rule_id = ? ");
        int i = 0;
        pst.setInt(++i, thisId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (thisId == -1) {
            throw new SQLException("Feature ID not found");
        }
    }

    public HelpBusinessRule(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setLinkHelpId(int tmp) {
        this.linkHelpId = tmp;
    }

    public void setLinkHelpId(String tmp) {
        this.linkHelpId = Integer.parseInt(tmp);
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setComplete(boolean tmp) {
        this.complete = tmp;
    }

    public void setComplete(String tmp) {
        this.complete = DatabaseUtils.parseBoolean(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setCompleteDate(Timestamp completeDate) {
        this.completeDate = completeDate;
    }

    public Timestamp getCompleteDate() {
        return this.completeDate;
    }

    public void setCompletedBy(int completedBy) {
        this.completedBy = completedBy;
    }

    public int getCompletedBy() {
        return this.completedBy;
    }

    public String getCompleteDateString() {
        String tmp = "";
        try {
            return DateFormat.getDateInstance(3).format(this.completeDate);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public int getId() {
        return this.id;
    }

    public int getLinkHelpId() {
        return this.linkHelpId;
    }

    public String getDescription() {
        return this.description;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public boolean getComplete() {
        return this.complete;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean insert(Connection db) throws SQLException {
        try {
            db.setAutoCommit(false);
            this.id = DatabaseUtils.getNextSeq(db, "help_business_rules_rule_id_seq");
            int i = 0;
            PreparedStatement pst = db.prepareStatement("INSERT INTO help_business_rules (" + (this.id > -1 ? "rule_id, " : "") + "link_help_id, description, enteredby, modifiedby, enabled, completedate, completedby) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ? ) ");
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.getLinkHelpId());
            pst.setString(++i, this.getDescription());
            pst.setInt(++i, this.getEnteredBy());
            pst.setInt(++i, this.getModifiedBy());
            pst.setBoolean(++i, this.getEnabled());
            if (this.getComplete()) {
                pst.setTimestamp(++i, new Timestamp(System.currentTimeMillis()));
                pst.setInt(++i, this.completedBy);
            } else {
                pst.setTimestamp(++i, null);
                pst.setTimestamp(++i, null);
            }
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "help_business_rules_rule_id_seq", this.id);
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        Object sql = null;
        Object rs = null;
        PreparedStatement pst = null;
        int count = 0;
        if (this.id == -1) {
            throw new SQLException("Feature ID not specified");
        }
        try {
            db.setAutoCommit(false);
            HelpBusinessRule previousFeature = new HelpBusinessRule(db, this.id);
            int i = 0;
            pst = db.prepareStatement("UPDATE help_business_rules SET modifiedby = ?, description = ?, enabled = ?, completedate = ?, completedby = ? WHERE rule_id = ? AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
            pst.setInt(++i, this.getModifiedBy());
            pst.setString(++i, this.getDescription());
            pst.setBoolean(++i, this.getEnabled());
            if (previousFeature.getComplete() && this.getComplete()) {
                pst.setTimestamp(++i, previousFeature.getCompleteDate());
                pst.setInt(++i, previousFeature.getCompletedBy());
            } else if (this.getComplete() && !previousFeature.getComplete()) {
                pst.setTimestamp(++i, new Timestamp(System.currentTimeMillis()));
                pst.setInt(++i, this.getCompletedBy());
            } else {
                pst.setTimestamp(++i, null);
                pst.setNull(++i, 5);
            }
            pst.setInt(++i, this.id);
            if (this.getModified() != null) {
                pst.setTimestamp(++i, this.getModified());
            }
            count = pst.executeUpdate();
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return count;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Feature ID not specified");
        }
        try {
            db.setAutoCommit(false);
            PreparedStatement pst = db.prepareStatement("DELETE from help_business_rules WHERE rule_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("rule_id");
        this.linkHelpId = rs.getInt("link_help_id");
        this.description = rs.getString("description");
        this.enteredBy = rs.getInt("enteredby");
        this.entered = rs.getTimestamp("entered");
        this.modifiedBy = rs.getInt("modifiedby");
        this.modified = rs.getTimestamp("modified");
        this.completeDate = rs.getTimestamp("completedate");
        if (!rs.wasNull()) {
            this.complete = true;
        }
        this.completedBy = rs.getInt("completedby");
        this.enabled = rs.getBoolean("enabled");
    }
}

