/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.help.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.modules.help.base.HelpItem;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class HelpContents
extends ArrayList {
    private boolean buildFeatures = false;
    private String module = null;
    private String section = null;
    private String subSection = null;
    private PagedListInfo pagedListInfo = null;

    public void setModule(String module) {
        this.module = module;
    }

    public void setSection(String section) {
        this.section = section;
    }

    public void setPagedListInfo(PagedListInfo pagedListInfo) {
        this.pagedListInfo = pagedListInfo;
    }

    public void setSubSection(String subSection) {
        this.subSection = subSection;
    }

    public String getSubSection() {
        return this.subSection;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public String getModule() {
        return this.module;
    }

    public String getSection() {
        return this.section;
    }

    public void setBuildFeatures(boolean buildFeatures) {
        this.buildFeatures = buildFeatures;
    }

    public boolean getBuildFeatures() {
        return this.buildFeatures;
    }

    public void build(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM help_contents hc WHERE hc.help_id > -1 ");
        this.createFilter(db, sqlFilter);
        if (this.pagedListInfo == null) {
            this.pagedListInfo = new PagedListInfo();
            this.pagedListInfo.setItemsPerPage(0);
        }
        pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        if (rs.next()) {
            int maxRecords = rs.getInt("recordcount");
            this.pagedListInfo.setMaxRecords(maxRecords);
        }
        rs.close();
        pst.close();
        if (!this.pagedListInfo.getCurrentLetter().equals("")) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND hc.description < ? ");
            items = this.prepareFilter(pst);
            pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
            rs = pst.executeQuery();
            if (rs.next()) {
                int offsetCount = rs.getInt("recordcount");
                this.pagedListInfo.setCurrentOffset(offsetCount);
            }
            rs.close();
            pst.close();
        }
        this.pagedListInfo.setDefaultSort("hc." + DatabaseUtils.addQuotes(db, "module") + "", "");
        this.pagedListInfo.appendSqlTail(db, sqlOrder);
        this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        sqlSelect.append("hc.* FROM help_contents hc WHERE hc.help_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            HelpItem thisItem = new HelpItem(rs);
            this.add(thisItem);
        }
        rs.close();
        pst.close();
        for (HelpItem thisItem : this) {
            if (!this.buildFeatures) continue;
            thisItem.buildFeatures(db);
        }
    }

    protected void createFilter(Connection db, StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.module != null) {
            sqlFilter.append("AND hc." + DatabaseUtils.addQuotes(db, "module") + " = ? ");
        }
        if (this.section != null) {
            sqlFilter.append("AND hc." + DatabaseUtils.addQuotes(db, "section") + " = ? ");
        }
        if (this.subSection != null) {
            sqlFilter.append("AND hc.subSection = ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.module != null) {
            pst.setString(++i, this.module);
        }
        if (this.section != null) {
            pst.setString(++i, this.section);
        }
        if (this.subSection != null) {
            pst.setString(++i, this.subSection);
        }
        return i;
    }
}

