/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.help.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import org.aspcfs.utils.DatabaseUtils;

public class HelpFeature
extends GenericBean {
    public static int DONE = 1;
    private int id = -1;
    private int linkHelpId = -1;
    private int linkFeatureId = -1;
    private String description = null;
    private int level = -1;
    private int enteredBy = -1;
    private Timestamp entered = null;
    private int modifiedBy = -1;
    private Timestamp modified = null;
    private boolean complete = false;
    private Timestamp completeDate = null;
    private int completedBy = -1;
    private boolean enabled = true;

    public HelpFeature() {
    }

    public HelpFeature(Connection db, int thisId) throws SQLException {
        if (thisId == -1) {
            throw new SQLException("Feature ID not specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT f.* FROM help_features f WHERE feature_id = ? ");
        int i = 0;
        pst.setInt(++i, thisId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (thisId == -1) {
            throw new SQLException("Feature ID not found");
        }
    }

    public HelpFeature(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setLinkHelpId(int tmp) {
        this.linkHelpId = tmp;
    }

    public void setLinkHelpId(String tmp) {
        this.linkHelpId = Integer.parseInt(tmp);
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setLevel(int tmp) {
        this.level = tmp;
    }

    public void setLevel(String tmp) {
        this.level = Integer.parseInt(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setComplete(boolean tmp) {
        this.complete = tmp;
    }

    public void setComplete(String tmp) {
        this.complete = DatabaseUtils.parseBoolean(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setCompleteDate(Timestamp completeDate) {
        this.completeDate = completeDate;
    }

    public Timestamp getCompleteDate() {
        return this.completeDate;
    }

    public void setCompletedBy(int completedBy) {
        this.completedBy = completedBy;
    }

    public void setLinkFeatureId(int linkFeatureId) {
        this.linkFeatureId = linkFeatureId;
    }

    public void setLinkFeatureId(String linkFeatureId) {
        this.linkFeatureId = Integer.parseInt(linkFeatureId);
    }

    public int getLinkFeatureId() {
        return this.linkFeatureId;
    }

    public int getCompletedBy() {
        return this.completedBy;
    }

    public String getCompleteDateString() {
        String tmp = "";
        try {
            return DateFormat.getDateInstance(3).format(this.completeDate);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public int getId() {
        return this.id;
    }

    public int getLinkHelpId() {
        return this.linkHelpId;
    }

    public String getDescription() {
        return this.description;
    }

    public int getLevel() {
        return this.level;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public boolean getComplete() {
        return this.complete;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    private int getMaxLevel(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT max(" + DatabaseUtils.addQuotes(db, "level") + ") AS maxrecord " + "FROM help_features " + "WHERE link_help_id = ? ");
        int i = 0;
        int max = 0;
        pst.setInt(++i, this.getLinkHelpId());
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            max = DatabaseUtils.getInt(rs, "maxrecord");
        }
        rs.close();
        pst.close();
        return max;
    }

    public boolean insert(Connection db) throws SQLException {
        try {
            db.setAutoCommit(false);
            int i = 0;
            if (this.getLevel() < 1) {
                this.setLevel(this.getMaxLevel(db) + 1);
            }
            this.id = DatabaseUtils.getNextSeq(db, "help_features_feature_id_seq");
            PreparedStatement pst = db.prepareStatement("INSERT INTO help_features (" + (this.id > -1 ? "feature_id, " : "") + "link_help_id, description, " + DatabaseUtils.addQuotes(db, "level") + ", enteredby, modifiedby, enabled, " + (this.linkFeatureId > 0 ? " link_feature_id, " : "") + "completedate, completedby) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, " + (this.linkFeatureId > 0 ? "?, " : "") + "?, ? ) ");
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.getLinkHelpId());
            pst.setString(++i, this.getDescription());
            pst.setInt(++i, this.getLevel());
            pst.setInt(++i, this.getEnteredBy());
            pst.setInt(++i, this.getModifiedBy());
            pst.setBoolean(++i, this.getEnabled());
            if (this.linkFeatureId > 0) {
                pst.setInt(++i, this.linkFeatureId);
            }
            if (this.getComplete()) {
                pst.setTimestamp(++i, new Timestamp(System.currentTimeMillis()));
                pst.setInt(++i, this.completedBy);
            } else {
                pst.setTimestamp(++i, null);
                pst.setNull(++i, 5);
            }
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "help_features_feature_id_seq", this.id);
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        Object sql = null;
        Object rs = null;
        PreparedStatement pst = null;
        int count = 0;
        if (this.id == -1) {
            throw new SQLException("Feature ID not specified");
        }
        try {
            if (this.getLevel() < 1) {
                this.setLevel(this.getMaxLevel(db) + 1);
            }
            db.setAutoCommit(false);
            HelpFeature previousFeature = new HelpFeature(db, this.id);
            int i = 0;
            pst = db.prepareStatement("UPDATE help_features SET modifiedby = ?, description = ?, " + DatabaseUtils.addQuotes(db, "level") + " = ?, enabled = ?, " + (this.linkFeatureId > 0 ? " link_feature_id = ?, " : "") + "completedate = ?, completedby = ? " + "WHERE feature_id = ? AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
            pst.setInt(++i, this.getModifiedBy());
            pst.setString(++i, this.getDescription());
            pst.setInt(++i, this.getLevel());
            pst.setBoolean(++i, this.getEnabled());
            if (this.linkFeatureId > 0) {
                pst.setInt(++i, this.linkFeatureId);
            }
            if (previousFeature.getComplete() && this.getComplete()) {
                pst.setTimestamp(++i, previousFeature.getCompleteDate());
                pst.setInt(++i, previousFeature.getCompletedBy());
            } else if (this.getComplete() && !previousFeature.getComplete()) {
                pst.setTimestamp(++i, new Timestamp(System.currentTimeMillis()));
                pst.setInt(++i, this.getCompletedBy());
            } else {
                pst.setTimestamp(++i, null);
                pst.setNull(++i, 5);
            }
            pst.setInt(++i, this.id);
            if (this.getModified() != null) {
                pst.setTimestamp(++i, this.getModified());
            }
            count = pst.executeUpdate();
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return count;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Feature ID not specified");
        }
        try {
            db.setAutoCommit(false);
            PreparedStatement pst = db.prepareStatement("DELETE from help_features WHERE feature_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("feature_id");
        this.linkHelpId = rs.getInt("link_help_id");
        this.linkFeatureId = rs.getInt("link_feature_id");
        if (rs.wasNull()) {
            this.linkFeatureId = -1;
        }
        this.description = rs.getString("description");
        this.enteredBy = rs.getInt("enteredby");
        this.entered = rs.getTimestamp("entered");
        this.modifiedBy = rs.getInt("modifiedby");
        this.modified = rs.getTimestamp("modified");
        this.completeDate = rs.getTimestamp("completedate");
        if (!rs.wasNull()) {
            this.complete = true;
        }
        this.completedBy = rs.getInt("completedby");
        this.enabled = rs.getBoolean("enabled");
        this.level = rs.getInt("level");
    }
}

