/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.help.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.help.base.HelpFeature;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class HelpFeatureList
extends ArrayList {
    public static final String tableName = "help_features";
    public static final String uniqueField = "feature_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int linkHelpId = -1;
    private boolean completeOnly = false;
    private int enteredBy = -1;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void setPagedListInfo(PagedListInfo pagedListInfo) {
        this.pagedListInfo = pagedListInfo;
    }

    public void setLinkHelpId(int linkHelpId) {
        this.linkHelpId = linkHelpId;
    }

    public void setCompleteOnly(boolean completeOnly) {
        this.completeOnly = completeOnly;
    }

    public void setEnteredBy(int enteredBy) {
        this.enteredBy = enteredBy;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getLinkHelpId() {
        return this.linkHelpId;
    }

    public boolean getCompleteOnly() {
        return this.completeOnly;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM help_features hf WHERE hf.feature_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo == null) {
            this.pagedListInfo = new PagedListInfo();
            this.pagedListInfo.setItemsPerPage(0);
        }
        pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        if (rs.next()) {
            int maxRecords = rs.getInt("recordcount");
            this.pagedListInfo.setMaxRecords(maxRecords);
        }
        pst.close();
        rs.close();
        if (!this.pagedListInfo.getCurrentLetter().equals("")) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND hf.description < ? ");
            items = this.prepareFilter(pst);
            pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
            rs = pst.executeQuery();
            if (rs.next()) {
                int offsetCount = rs.getInt("recordcount");
                this.pagedListInfo.setCurrentOffset(offsetCount);
            }
            rs.close();
            pst.close();
        }
        this.pagedListInfo.setDefaultSort("hf." + DatabaseUtils.addQuotes(db, "level") + "", "ASC");
        this.pagedListInfo.appendSqlTail(db, sqlOrder);
        this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        sqlSelect.append("hf.* FROM help_features hf WHERE hf.feature_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            HelpFeature thisFeature = new HelpFeature(rs);
            this.add(thisFeature);
        }
        rs.close();
        pst.close();
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.enteredBy != -1) {
            sqlFilter.append("AND hf.enteredby = ? ");
        }
        if (this.linkHelpId != -1) {
            sqlFilter.append("AND hf.link_help_id = ? ");
        }
        if (this.completeOnly) {
            sqlFilter.append("AND t.complete = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.enteredBy != -1) {
            pst.setInt(++i, this.enteredBy);
        }
        if (this.linkHelpId != -1) {
            pst.setInt(++i, this.linkHelpId);
        }
        if (this.completeOnly) {
            pst.setBoolean(++i, true);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }
}

