/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.help.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.modules.help.base.HelpBusinessRuleList;
import org.aspcfs.modules.help.base.HelpFeatureList;
import org.aspcfs.modules.help.base.HelpModule;
import org.aspcfs.modules.help.base.HelpModuleList;
import org.aspcfs.modules.help.base.HelpNoteList;
import org.aspcfs.modules.help.base.HelpTipList;
import org.aspcfs.utils.DatabaseUtils;

public class HelpItem
extends GenericBean {
    public static final String fs = System.getProperty("file.separator");
    private int id = -1;
    private int categoryId = -1;
    private int moduleId = -1;
    private String module = null;
    private String section = null;
    private String subsection = null;
    private String description = null;
    private String title = null;
    private String permission = null;
    private int nextContent = -1;
    private int prevContent = -1;
    private int upContent = -1;
    private int enteredBy = -1;
    private Timestamp entered = null;
    private int modifiedBy = -1;
    private Timestamp modified = null;
    private boolean buildFeatures = false;
    private boolean buildRules = false;
    private boolean buildNotes = false;
    private boolean buildTips = false;
    private HelpFeatureList features = new HelpFeatureList();
    private HelpNoteList notes = new HelpNoteList();
    private HelpTipList tips = new HelpTipList();
    private HelpBusinessRuleList businessRules = new HelpBusinessRuleList();

    public HelpItem() {
    }

    public HelpItem(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public HelpItem(Connection db, String module, String section, String subsection, int userId) throws SQLException {
        if ("null".equals(module)) {
            module = null;
        }
        if ("null".equals(section)) {
            section = null;
        }
        if ("null".equals(subsection)) {
            subsection = null;
        }
        this.processRecord(db, userId);
    }

    public HelpItem(Connection db, int id) throws SQLException {
        this.id = id;
        this.queryRecord(db);
    }

    public void queryRecord(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        String sql = "SELECT * FROM help_contents h WHERE help_id = ? ";
        pst = db.prepareStatement(sql);
        if (System.getProperty("DEBUG") != null) {
            System.out.println("HelpItem-> Prepared");
        }
        int i = 0;
        pst.setInt(++i, this.id);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        this.buildFeatures(db);
        this.buildRules(db);
        this.buildNotes(db);
        this.buildTips(db);
    }

    public synchronized void processRecord(Connection db, int userId) throws SQLException {
        ResultSet rs;
        boolean newItem = true;
        PreparedStatement pst = db.prepareStatement("SELECT * FROM help_contents h WHERE " + DatabaseUtils.addQuotes(db, "module") + " = ? " + (this.section != null ? "AND " + DatabaseUtils.addQuotes(db, "section") + " = ? " : "AND " + DatabaseUtils.addQuotes(db, "section") + " IS NULL ") + (this.subsection != null ? "AND subsection = ? " : "AND subsection IS NULL "));
        if (System.getProperty("DEBUG") != null) {
            System.out.println("HelpItem-> Prepared");
        }
        int i = 0;
        pst.setString(++i, this.module);
        if (this.section != null) {
            pst.setString(++i, this.section);
        }
        if (this.subsection != null) {
            pst.setString(++i, this.subsection);
        }
        if ((rs = pst.executeQuery()).next()) {
            this.buildRecord(rs);
            newItem = false;
        }
        rs.close();
        pst.close();
        if (newItem) {
            this.setEnteredBy(userId);
            this.setModifiedBy(userId);
            this.insert(db);
            if (System.getProperty("DEBUG") != null) {
                System.out.println("HelpItem-> Record not present.. Inserting new record ");
            }
        } else {
            if (this.buildFeatures) {
                this.buildFeatures(db);
            }
            if (this.buildRules) {
                this.buildRules(db);
            }
            if (this.buildNotes) {
                this.buildNotes(db);
            }
            if (this.buildTips) {
                this.buildTips(db);
            }
        }
    }

    public void fetchRecord(Connection db) throws SQLException {
        ResultSet rs;
        PreparedStatement pst = db.prepareStatement("SELECT * FROM help_contents h WHERE " + DatabaseUtils.addQuotes(db, "module") + " = ? " + (this.section != null ? "AND " + DatabaseUtils.addQuotes(db, "section") + " = ? " : "AND " + DatabaseUtils.addQuotes(db, "section") + " IS NULL ") + (this.subsection != null ? "AND subsection = ? " : "AND subsection IS NULL "));
        int i = 0;
        pst.setString(++i, this.module);
        if (this.section != null) {
            pst.setString(++i, this.section);
        }
        if (this.subsection != null) {
            pst.setString(++i, this.subsection);
        }
        if ((rs = pst.executeQuery()).next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public void setModuleId(int tmp) {
        this.moduleId = tmp;
    }

    public void setModuleId(String tmp) {
        this.moduleId = Integer.parseInt(tmp);
    }

    public void setModule(String tmp) {
        this.module = tmp;
    }

    public void setTitle(String tmp) {
        this.title = tmp;
    }

    public void setSection(String tmp) {
        this.section = tmp;
    }

    public void setSubsection(String tmp) {
        this.subsection = tmp;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setPermission(String tmp) {
        this.permission = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setFeatures(HelpFeatureList features) {
        this.features = features;
    }

    public void setBuildFeatures(boolean buildFeatures) {
        this.buildFeatures = buildFeatures;
    }

    public void setBusinessRules(HelpBusinessRuleList businessRules) {
        this.businessRules = businessRules;
    }

    public void setBuildRules(boolean buildRules) {
        this.buildRules = buildRules;
    }

    public void setBuildNotes(boolean buildNotes) {
        this.buildNotes = buildNotes;
    }

    public void setBuildTips(boolean buildTips) {
        this.buildTips = buildTips;
    }

    public void setNotes(HelpNoteList notes) {
        this.notes = notes;
    }

    public void setTips(HelpTipList tips) {
        this.tips = tips;
    }

    public HelpNoteList getNotes() {
        return this.notes;
    }

    public HelpTipList getTips() {
        return this.tips;
    }

    public boolean getBuildRules() {
        return this.buildRules;
    }

    public boolean getBuildNotes() {
        return this.buildNotes;
    }

    public boolean getBuildTips() {
        return this.buildTips;
    }

    public HelpBusinessRuleList getBusinessRules() {
        return this.businessRules;
    }

    public boolean getBuildFeatures() {
        return this.buildFeatures;
    }

    public HelpFeatureList getFeatures() {
        return this.features;
    }

    public int getId() {
        return this.id;
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public String getModule() {
        return this.module;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSection() {
        return this.section;
    }

    public String getSubsection() {
        return this.subsection;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPermission() {
        return this.permission;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("help_id");
        this.categoryId = rs.getInt("category_id");
        this.moduleId = rs.getInt("link_module_id");
        this.module = rs.getString("module");
        this.section = rs.getString("section");
        this.subsection = rs.getString("subsection");
        this.title = rs.getString("title");
        this.description = rs.getString("description");
        this.nextContent = rs.getInt("nextcontent");
        this.prevContent = rs.getInt("prevcontent");
        this.upContent = rs.getInt("upcontent");
        this.enteredBy = rs.getInt("enteredby");
        this.entered = rs.getTimestamp("entered");
        this.modifiedBy = rs.getInt("modifiedby");
        this.modified = rs.getTimestamp("modified");
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "help_contents_help_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO help_contents (" + (this.id > -1 ? "help_id, " : "") + "" + DatabaseUtils.addQuotes(db, "module") + ", " + DatabaseUtils.addQuotes(db, "section") + ", subsection, title, description, enteredby, modifiedby) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?) ");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setString(++i, this.module);
        pst.setString(++i, this.section);
        pst.setString(++i, this.subsection);
        pst.setString(++i, this.title);
        pst.setString(++i, this.description);
        pst.setInt(++i, this.enteredBy);
        pst.setInt(++i, this.modifiedBy);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "help_contents_help_id_seq", this.id);
        return true;
    }

    public int update(Connection db) throws SQLException {
        if (this.id == -1) {
            if ("null".equals(this.module)) {
                this.module = null;
            }
            if ("null".equals(this.section)) {
                this.section = null;
            }
            if ("null".equals(this.subsection)) {
                this.subsection = null;
            }
            this.insert(db);
            return 1;
        }
        HelpModuleList hml = new HelpModuleList();
        hml.setCategoryId(this.categoryId);
        hml.buildList(db);
        if (hml.size() == 0) {
            HelpModule hm = new HelpModule();
            hm.setLinkCategoryId(this.categoryId);
            hm.insert(db);
            this.moduleId = hm.getId();
        } else {
            this.moduleId = ((HelpModule)((Object)hml.get(0))).getId();
        }
        PreparedStatement pst = db.prepareStatement("UPDATE help_contents SET category_id = ? , link_module_id = ?, title = ?, description = ?, modifiedby = ?, modified = CURRENT_TIMESTAMP WHERE help_id = ? ");
        int i = 0;
        pst.setInt(++i, this.categoryId);
        pst.setInt(++i, this.moduleId);
        pst.setString(++i, this.title);
        pst.setString(++i, this.description);
        pst.setInt(++i, this.modifiedBy);
        pst.setInt(++i, this.id);
        int count = pst.executeUpdate();
        pst.close();
        return count;
    }

    public void buildFeatures(Connection db) throws SQLException {
        this.features.setLinkHelpId(this.getId());
        this.features.buildList(db);
    }

    public void buildNotes(Connection db) throws SQLException {
        this.notes.setLinkHelpId(this.getId());
        this.notes.setEnabledOnly(true);
        this.notes.buildList(db);
    }

    public void buildTips(Connection db) throws SQLException {
        this.tips.setLinkHelpId(this.getId());
        this.tips.buildList(db);
    }

    public void buildRules(Connection db) throws SQLException {
        this.businessRules.setLinkHelpId(this.getId());
        this.businessRules.buildList(db);
    }

    public String getBaseFilename() {
        StringBuffer filename = new StringBuffer();
        if (this.module.indexOf(".do") > -1) {
            filename.append(this.module.substring(0, this.module.indexOf(".do")));
        } else {
            filename.append(this.module);
        }
        filename.append("-");
        filename.append(this.section);
        if (this.subsection != null && this.subsection.length() > 0) {
            filename.append("-" + this.subsection);
        }
        return filename.toString().toLowerCase();
    }

    public boolean hasImageFile(String path) {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("HelpItem-> Looking for the following image: " + path + fs + this.getBaseFilename() + ".png");
        }
        File helpImage = new File(path + fs + this.getBaseFilename() + ".png");
        return helpImage.exists();
    }
}

