/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.help.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.help.base.HelpItem;
import org.aspcfs.utils.web.PagedListInfo;

public class HelpItemList
extends ArrayList {
    public static final String tableName = "help_contents";
    public static final String uniqueField = "help_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void setPagedListInfo(PagedListInfo pagedListInfo) {
        this.pagedListInfo = pagedListInfo;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM help_contents c WHERE c.help_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo == null) {
            this.pagedListInfo = new PagedListInfo();
            this.pagedListInfo.setItemsPerPage(0);
        }
        pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        if (rs.next()) {
            int maxRecords = rs.getInt("recordcount");
            this.pagedListInfo.setMaxRecords(maxRecords);
        }
        rs.close();
        pst.close();
        if (!this.pagedListInfo.getCurrentLetter().equals("")) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND c.description < ? ");
            items = this.prepareFilter(pst);
            pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
            rs = pst.executeQuery();
            if (rs.next()) {
                int offsetCount = rs.getInt("recordcount");
                this.pagedListInfo.setCurrentOffset(offsetCount);
            }
            rs.close();
            pst.close();
        }
        this.pagedListInfo.setDefaultSort("c.help_id", "");
        this.pagedListInfo.appendSqlTail(db, sqlOrder);
        this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        sqlSelect.append("c.* FROM help_contents c WHERE c.help_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            HelpItem thisItem = new HelpItem(rs);
            this.add(thisItem);
        }
        rs.close();
        pst.close();
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }
}

