/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.help.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;

public class HelpModule
extends GenericBean {
    public static int DONE = 1;
    private int id = -1;
    private int linkCategoryId = -1;
    private String briefDescription = null;
    private String detailDescription = null;
    private String moduleName = null;
    private String relatedAction = null;

    public HelpModule() {
    }

    public HelpModule(Connection db, int thisId) throws SQLException {
        if (thisId == -1) {
            throw new SQLException("Module Id not specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT module_id, hm.category_id as category_id, category, module_brief_description, module_detail_description FROM help_module hm, permission_category pc WHERE module_id = ? AND hm.category_id = pc.category_id");
        int i = 0;
        pst.setInt(++i, thisId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Module ID not found");
        }
    }

    public HelpModule(Connection db, String action) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT * FROM help_module hm, permission_category pc WHERE hm.module_id in (SELECT link_module_id from help_contents hc WHERE hc." + DatabaseUtils.addQuotes(db, "module") + " = ?) " + "AND hm.category_id = pc.category_id ");
        int i = 0;
        pst.setString(++i, action);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
            this.relatedAction = action;
        }
        rs.close();
        pst.close();
    }

    public HelpModule(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setLinkCategoryId(int tmp) {
        this.linkCategoryId = tmp;
    }

    public void setLinkCategoryId(String tmp) {
        this.linkCategoryId = Integer.parseInt(tmp);
    }

    public void setModuleName(String tmp) {
        this.moduleName = tmp;
    }

    public void setDetailDescription(String tmp) {
        this.detailDescription = tmp;
    }

    public void setBriefDescription(String tmp) {
        this.briefDescription = tmp;
    }

    public void setRelatedAction(String tmp) {
        this.relatedAction = tmp;
    }

    public int getId() {
        return this.id;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public int getLinkCategoryId() {
        return this.linkCategoryId;
    }

    public String getBriefDescription() {
        return this.briefDescription;
    }

    public String getRelatedAction() {
        return this.relatedAction;
    }

    public String getDetailDescription() {
        return this.detailDescription;
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "help_module_module_id_seq");
        int i = 0;
        PreparedStatement pst = db.prepareStatement("INSERT INTO help_module (" + (this.id > -1 ? "module_id, " : "") + "category_id , module_brief_description , module_detail_description) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?,?, ?) ");
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.getLinkCategoryId());
        pst.setString(++i, this.getBriefDescription());
        pst.setString(++i, this.getDetailDescription());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "help_module_module_id_seq", this.id);
        return true;
    }

    public int update(Connection db) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("Module ID not specified");
        }
        int count = 0;
        int i = 0;
        PreparedStatement pst = db.prepareStatement("UPDATE help_module SET module_brief_description = ?, module_detail_description = ? WHERE module_id = ?");
        pst.setString(++i, this.getBriefDescription());
        pst.setString(++i, this.getDetailDescription());
        pst.setInt(++i, this.getId());
        count = pst.executeUpdate();
        pst.close();
        return count;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Tip ID not specified");
        }
        try {
            db.setAutoCommit(false);
            PreparedStatement pst = db.prepareStatement("DELETE from help_module WHERE module_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("module_id");
        this.linkCategoryId = rs.getInt("category_id");
        this.moduleName = rs.getString("category");
        this.briefDescription = rs.getString("module_brief_description");
        this.detailDescription = rs.getString("module_detail_description");
    }
}

