/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.help.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.utils.DatabaseUtils;

public class HelpTableOfContentItemLink
extends GenericBean {
    private int id = -1;
    private int linkToTableOfContentItem = -1;
    private int linkToHelpItem = -1;
    private int enteredBy = -1;
    private Timestamp entered = null;
    private int modifiedBy = -1;
    private Timestamp modified = null;
    private boolean enabled = true;
    private String linkType = null;
    private int linkModule = -1;

    public HelpTableOfContentItemLink() {
    }

    public HelpTableOfContentItemLink(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public HelpTableOfContentItemLink(Connection db, int thisId) throws SQLException {
        if (thisId == -1) {
            throw new SQLException("Link ID not specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT t.* FROM help_tableofcontentitem_links t WHERE link_id = ? ");
        int i = 0;
        pst.setInt(++i, thisId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (thisId == -1) {
            throw new SQLException("Link ID not found");
        }
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setLinkToTableOfContentItem(int tmp) {
        this.linkToTableOfContentItem = tmp;
    }

    public void setLinkToTableOfContentItem(String tmp) {
        this.linkToTableOfContentItem = Integer.parseInt(tmp);
    }

    public void setLinkToHelpItem(int tmp) {
        this.linkToHelpItem = tmp;
    }

    public void setLinkToHelpItem(String tmp) {
        this.linkToHelpItem = Integer.parseInt(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setLinkType(String tmp) {
        this.linkType = tmp;
    }

    public void setLinkModule(int tmp) {
        this.linkModule = tmp;
    }

    public void setLinkModule(String tmp) {
        this.linkModule = Integer.parseInt(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getLinkToTableOfContentItem() {
        return this.linkToTableOfContentItem;
    }

    public int getLinkToHelpItem() {
        return this.linkToHelpItem;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public String getLinkType() {
        return this.linkType;
    }

    public int getLinkModule() {
        return this.linkModule;
    }

    public void fetchLinkDetails(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT link_module_id, " + DatabaseUtils.addQuotes(db, "module") + " " + "FROM help_contents h " + "WHERE help_id = ? ");
        int i = 0;
        pst.setInt(++i, this.linkToHelpItem);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            String module = rs.getString("module");
            this.linkModule = rs.getInt("link_module_id");
            this.linkType = module == null ? "MODULE" : "CONTEXT";
        }
        rs.close();
        pst.close();
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("link_id");
        this.linkToTableOfContentItem = rs.getInt("global_link_id");
        this.linkToHelpItem = rs.getInt("linkto_content_id");
        this.enteredBy = rs.getInt("enteredby");
        this.entered = rs.getTimestamp("entered");
        this.modifiedBy = rs.getInt("modifiedby");
        this.modified = rs.getTimestamp("modified");
        this.enabled = rs.getBoolean("enabled");
    }
}

