/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.help.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.utils.DatabaseUtils;

public class HelpTip
extends GenericBean {
    public static int DONE = 1;
    private int id = -1;
    private int linkHelpId = -1;
    private String description = null;
    private int enteredBy = -1;
    private Timestamp entered = null;
    private int modifiedBy = -1;
    private Timestamp modified = null;
    private boolean enabled = true;

    public HelpTip() {
    }

    public HelpTip(Connection db, int thisId) throws SQLException {
        if (thisId == -1) {
            throw new SQLException("Tip ID not specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT f.* FROM help_tips f WHERE tip_id = ? ");
        int i = 0;
        pst.setInt(++i, thisId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (thisId == -1) {
            throw new SQLException("Tip ID not found");
        }
    }

    public HelpTip(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setLinkHelpId(int tmp) {
        this.linkHelpId = tmp;
    }

    public void setLinkHelpId(String tmp) {
        this.linkHelpId = Integer.parseInt(tmp);
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getLinkHelpId() {
        return this.linkHelpId;
    }

    public String getDescription() {
        return this.description;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean insert(Connection db) throws SQLException {
        try {
            db.setAutoCommit(false);
            int i = 0;
            this.id = DatabaseUtils.getNextSeq(db, "help_tips_tip_id_seq");
            PreparedStatement pst = db.prepareStatement("INSERT INTO help_tips (" + (this.id > -1 ? "tip_id, " : "") + "link_help_id, description, enteredby, modifiedby, enabled ) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?) ");
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            this.id = DatabaseUtils.getCurrVal(db, "help_tips_tip_id_seq", this.id);
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        PreparedStatement pst = null;
        int count = 0;
        if (this.id == -1) {
            throw new SQLException("Tip ID not specified");
        }
        try {
            db.setAutoCommit(false);
            HelpTip previousTip = new HelpTip(db, this.id);
            int i = 0;
            pst = db.prepareStatement("UPDATE help_tips SET modifiedby = ?, description = ?, enabled = ? WHERE tip_id = ? AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
            pst.setInt(++i, this.getModifiedBy());
            pst.setString(++i, this.getDescription());
            pst.setBoolean(++i, this.getEnabled());
            pst.setInt(++i, this.id);
            if (this.getModified() != null) {
                pst.setTimestamp(++i, this.getModified());
            }
            count = pst.executeUpdate();
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return count;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Tip ID not specified");
        }
        try {
            db.setAutoCommit(false);
            PreparedStatement pst = db.prepareStatement("DELETE from help_tips WHERE tip_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("tip_id");
        this.linkHelpId = rs.getInt("link_help_id");
        this.description = rs.getString("description");
        this.enteredBy = rs.getInt("enteredby");
        this.entered = rs.getTimestamp("entered");
        this.modifiedBy = rs.getInt("modifiedby");
        this.modified = rs.getTimestamp("modified");
        this.enabled = rs.getBoolean("enabled");
    }
}

