/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.industry.spirit.actions;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.framework.actions.ActionContext;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.login.base.AuthenticationItem;
import org.aspcfs.modules.pipeline.base.OpportunityComponent;
import org.aspcfs.modules.pipeline.base.OpportunityHeader;
import org.aspcfs.modules.quotes.base.Quote;
import org.aspcfs.modules.quotes.base.QuoteList;
import org.aspcfs.modules.quotes.base.QuoteProduct;
import org.aspcfs.modules.quotes.base.QuoteProductList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.StringUtils;

public final class ProcessMaresa
extends CFSModule {
    public static String DATA_SEPERATOR = "|";
    public static String ACTIVE = "C03";
    HashMap errors = new HashMap();

    public String executeCommandUpdateOpportunity(ActionContext context) throws SQLException {
        block68: {
            boolean recordInserted = false;
            int resultCount = -1;
            int userId = -1;
            int contactId = -1;
            ArrayList<String> input = new ArrayList<String>();
            StringBuffer log = new StringBuffer();
            String filePath = null;
            this.errors.clear();
            OpportunityComponent thisComponent = null;
            OpportunityHeader oppHeader = null;
            Connection db = null;
            ConnectionElement ce = null;
            Statement pst = null;
            ResultSet rs = null;
            try {
                AuthenticationItem auth = new AuthenticationItem();
                ce = auth.getConnectionElement(context);
                db = this.getConnection(context, ce);
                filePath = this.getPath(context) + System.getProperty("file.separator") + ce.getDbName();
                db.setAutoCommit(false);
                String opportunityData = null;
                QuoteProductList products = new QuoteProductList();
                BufferedReader br = context.getRequest().getReader();
                String line = null;
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Maresa-> Reading from request");
                }
                log.append("\tMaresa-> Reading from request\n");
                while ((line = br.readLine()) != null) {
                    input.add(line.trim());
                }
                if (input.size() < 3) {
                    this.errors.put("InsufficientDataERROR", "FATAL: Less than 3 lines found in input");
                    throw new Exception("InsufficientDataERROR");
                }
                if (input.get(0) == null) {
                    this.errors.put("TransactionIdERROR", "FATAL: Transaction Id does not exist");
                    throw new Exception("TransactionIdERROR");
                }
                if (input.get(1) == null) {
                    this.errors.put("OpportunityDataERROR", "Opportunity data does not exist");
                    throw new Exception("OpportunityDataERROR");
                }
                opportunityData = (String)input.get(1);
                for (int prodIndex = 2; prodIndex < input.size(); ++prodIndex) {
                    String productData = (String)input.get(prodIndex);
                    if ("".equals(StringUtils.toString(productData))) continue;
                    StringTokenizer tmp = new StringTokenizer(productData, DATA_SEPERATOR);
                    QuoteProduct thisProduct = new QuoteProduct();
                    String codeDescription = tmp.nextToken();
                    int productId = -1;
                    pst = db.prepareStatement("SELECT product_id FROM product_catalog WHERE sku = ? ");
                    pst.setString(1, codeDescription);
                    rs = pst.executeQuery();
                    if (!rs.next()) {
                        this.errors.put("ProductCodeERROR", "No mapping found for product description " + codeDescription);
                        throw new Exception("ProductCodeERROR");
                    }
                    productId = rs.getInt("product_id");
                    pst.close();
                    rs.close();
                    thisProduct.setProductId(productId);
                    thisProduct.setQuantity(tmp.nextToken());
                    if ("00031".equals(codeDescription)) {
                        thisProduct.setPriceAmount(-1.0 * Double.parseDouble(tmp.nextToken()));
                    } else {
                        thisProduct.setPriceAmount(Double.parseDouble(tmp.nextToken()));
                    }
                    thisProduct.setComment(tmp.nextToken());
                    products.add(thisProduct);
                }
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Maresa-> Product Size " + products.size());
                }
                log.append("\tMaresa-> Product Size " + products.size() + "\n");
                if (products.size() <= 0 || "".equals(StringUtils.toString(opportunityData))) break block68;
                StringTokenizer tmp = new StringTokenizer(opportunityData, DATA_SEPERATOR);
                String description = tmp.nextToken();
                String cruiseDate = tmp.nextToken();
                String source = tmp.nextToken();
                String productValue = tmp.nextToken();
                String countOfPassengers = tmp.nextToken();
                String resNumber = tmp.nextToken();
                String resAction = tmp.nextToken();
                String status = tmp.nextToken();
                String payment = tmp.nextToken();
                String site = tmp.nextToken();
                String maresaContactId = tmp.nextToken();
                String eventType = tmp.nextToken();
                int siteCode = -1;
                pst = db.prepareStatement("SELECT code FROM lookup_site_id WHERE lower(maresa_id) = lower(?) ");
                pst.setString(1, site);
                rs = pst.executeQuery();
                if (rs.next()) {
                    siteCode = rs.getInt("code");
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("Maresa-> Site Code: " + siteCode);
                    }
                } else {
                    this.errors.put("SiteCodeERROR", "No mapping found for site " + site);
                    throw new Exception("SiteCodeERROR");
                }
                log.append("\tMaresa-> Site Code: " + siteCode + "\n");
                pst.close();
                rs.close();
                pst = db.prepareStatement("SELECT contact_id FROM maresa_client WHERE client_id = ? AND site_id = ? ");
                pst.setInt(1, Integer.parseInt(maresaContactId));
                pst.setInt(2, siteCode);
                rs = pst.executeQuery();
                if (!rs.next()) {
                    this.errors.put("ContactIdERROR", "No Mapping for " + maresaContactId + " found in CFS");
                    throw new Exception("ContactIdERROR");
                }
                contactId = rs.getInt("contact_id");
                pst.close();
                rs.close();
                Contact thisContact = new Contact();
                thisContact.setBuildDetails(false);
                thisContact.setBuildTypes(false);
                thisContact.queryRecord(db, contactId);
                userId = thisContact.getOwner();
                int oppId = -1;
                int componentId = -1;
                if ("1".equals(resAction)) {
                    pst = db.prepareStatement("SELECT om.header_id, om.component_id FROM opportunity_header_maresa om WHERE om.res_number = ? AND om.res_site = ? ");
                    pst.setInt(1, Integer.parseInt(resNumber));
                    pst.setInt(2, siteCode);
                    rs = pst.executeQuery();
                    if (rs.next()) {
                        if (System.getProperty("DEBUG") != null) {
                            System.out.println("Maresa-> Opp HeaderId " + rs.getInt("header_id"));
                        }
                        oppId = rs.getInt("header_id");
                        componentId = rs.getInt("component_id");
                        if (System.getProperty("DEBUG") != null) {
                            System.out.println("Maresa-> Opp HeaderId " + oppId);
                        }
                    } else {
                        this.errors.put("OpportunityUpdateERROR", "No mapping for reservation: " + resNumber + " and site: " + siteCode + " found in CFS");
                        throw new Exception("OpportunityUpdateERROR");
                    }
                    log.append("\tMaresa-> Opp HeaderId " + oppId + "\n");
                    rs.close();
                    pst.close();
                    int i = 0;
                    pst = db.prepareStatement("UPDATE opportunity_header_maresa SET res_status = ?, res_payments = ?, event_type = ?, modified = CURRENT_TIMESTAMP WHERE res_number = ? ");
                    pst.setString(++i, status);
                    pst.setDouble(++i, Double.parseDouble(payment));
                    pst.setString(++i, eventType);
                    pst.setInt(++i, Integer.parseInt(resNumber));
                    pst.execute();
                    pst.close();
                } else if ("0".equals(resAction)) {
                    pst = db.prepareStatement("SELECT oh.opp_id, oc.id FROM opportunity_header oh, opportunity_component oc WHERE oh.contactlink = ? AND " + DatabaseUtils.castDateTimeToDate(db, "oc.closedate") + " = ? " + "AND oh.opp_id = oc.opp_id ");
                    pst.setInt(1, contactId);
                    pst.setDate(2, DateUtils.parseDateString(cruiseDate));
                    rs = pst.executeQuery();
                    if (rs.next()) {
                        oppId = rs.getInt("opp_id");
                        componentId = rs.getInt("id");
                        if (System.getProperty("DEBUG") != null) {
                            System.out.println("Maresa-> Opp HeaderId " + oppId);
                        }
                        log.append("\tMaresa-> Opp HeaderId " + oppId + "\n");
                    } else if (System.getProperty("DEBUG") != null) {
                        System.out.println("Maresa-> Opportunity Not Found.. Creating new one");
                    }
                    rs.close();
                    pst.close();
                } else {
                    this.errors.put("InvalidActionERROR", "Invalid Action : " + resAction);
                    throw new Exception("InvalidActionERROR");
                }
                if (oppId > 0) {
                    thisComponent = new OpportunityComponent(db, componentId);
                    oppHeader = new OpportunityHeader(db, oppId);
                } else {
                    oppHeader = new OpportunityHeader();
                    oppHeader.setContactLink(contactId);
                    oppHeader.setEnteredBy(userId);
                    thisComponent = new OpportunityComponent();
                }
                oppHeader.setDescription(description);
                oppHeader.setModifiedBy(userId);
                oppHeader.setCustom1Integer(countOfPassengers);
                thisComponent.setDescription(description);
                thisComponent.setType(source);
                thisComponent.setGuess(productValue);
                thisComponent.setModifiedBy(userId);
                Date tmpDate1 = DateUtils.parseDateString(cruiseDate);
                Timestamp timestampValue1 = new Timestamp(tmpDate1.getTime());
                thisComponent.setCloseDate(timestampValue1);
                String stage = null;
                if (ACTIVE.equals(status)) {
                    if (!"".equals(StringUtils.toString(payment)) && Double.parseDouble(StringUtils.toString(payment)) > 0.0) {
                        thisComponent.addIgnoredValidationField("closeProb");
                        thisComponent.setCloseProb("100");
                        thisComponent.setCloseIt(false);
                        thisComponent.setOpenIt(true);
                        stage = "Active";
                    } else {
                        thisComponent.setCloseProb("79");
                        thisComponent.setCloseIt(false);
                        thisComponent.setOpenIt(true);
                        stage = "Tentative";
                    }
                } else {
                    thisComponent.setCloseIt(true);
                    stage = "Cancelled";
                }
                int stageCode = -1;
                pst = db.prepareStatement("SELECT code FROM lookup_stage WHERE lower(description) = lower(?) ");
                pst.setString(1, stage);
                rs = pst.executeQuery();
                if (rs.next()) {
                    stageCode = rs.getInt("code");
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("Maresa-> Stage: " + stage + ";Code: " + stageCode);
                    }
                } else {
                    this.errors.put("StageCodeERROR", "No mapping found for stage " + stage);
                    throw new Exception("StageCodeERROR");
                }
                log.append("\tMaresa-> Stage: " + stage + "; Mapped CFS Code: " + stageCode + "\n");
                pst.close();
                rs.close();
                thisComponent.setStage(stageCode);
                if (oppId > 0) {
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("Maresa-> Updating Header");
                    }
                    log.append("\tMaresa-> Updating Header\n");
                    resultCount = oppHeader.update(db);
                    if (resultCount == -1) {
                        this.errors.put("OpportunityHeaderUpdateERROR", "Header " + oppHeader.getDescription() + " could not be updated");
                        throw new Exception("OpportunityHeaderUpdateERROR");
                    }
                    resultCount = -1;
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("Maresa-> Updating Component");
                    }
                    log.append("\tMaresa-> Updating Component\n");
                    resultCount = thisComponent.update(db);
                    if (resultCount == -1) {
                        this.errors.put("OpportunityComponentUpdateERROR", "Component " + thisComponent.getDescription() + " could not be updated");
                        throw new Exception("OpportunityComponentUpdateERROR");
                    }
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("Maresa-> Deleting all products");
                    }
                    log.append("\tMaresa-> Deleting all products\n");
                    QuoteList quoteList = new QuoteList();
                    quoteList.setHeaderId(thisComponent.getHeaderId());
                    quoteList.setBuildResources(true);
                    quoteList.buildList(db);
                    Iterator quoteIterator = quoteList.iterator();
                    if (quoteIterator.hasNext()) {
                        log.append("\tMaresa-> Fetching old quote products that need to be deleted\n");
                        while (quoteIterator.hasNext()) {
                            Quote quote = (Quote)((Object)quoteIterator.next());
                            quote.getProductList().delete(db);
                        }
                    }
                } else {
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("Maresa-> Inserting Header");
                    }
                    log.append("\tMaresa-> Inserting Header\n");
                    recordInserted = oppHeader.insert(db);
                    if (!recordInserted) {
                        this.errors.put("OpportunityHeaderInsertERROR", "Header " + oppHeader.getDescription() + " could not be inserted");
                        throw new Exception("OpportunityHeaderInsertERROR");
                    }
                    thisComponent.setHeaderId(oppHeader.getId());
                    thisComponent.setEnteredBy(userId);
                    Date tmpDate = DateUtils.parseDateString(cruiseDate);
                    Timestamp timestampValue = new Timestamp(tmpDate.getTime());
                    thisComponent.setCloseDate(timestampValue);
                    thisComponent.setOwner(userId);
                    recordInserted = false;
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("Maresa-> Inserting Component");
                    }
                    log.append("\tMaresa-> Inserting Component\n");
                    recordInserted = thisComponent.insert(db);
                    if (!recordInserted) {
                        this.errors.put("OpportunityComponentInsertERROR", "Component " + thisComponent.getDescription() + " could not be inserted");
                        throw new Exception("OpportunityComponentInsertERROR");
                    }
                    this.invalidateUserData(context, userId);
                }
                if ("0".equals(resAction)) {
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("Maresa-> Inserting new reservation");
                    }
                    log.append("\tMaresa-> Inserting new reservation\n");
                    int i = 0;
                    pst = db.prepareStatement("INSERT INTO opportunity_header_maresa (res_number, res_status, res_payments, res_site, res_contact_id, event_type, header_id, component_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?) ");
                    pst.setInt(++i, Integer.parseInt(resNumber));
                    pst.setString(++i, status);
                    pst.setDouble(++i, Double.parseDouble(payment));
                    pst.setInt(++i, siteCode);
                    pst.setInt(++i, contactId);
                    pst.setString(++i, eventType);
                    pst.setInt(++i, oppHeader.getId());
                    pst.setInt(++i, thisComponent.getId());
                    pst.execute();
                    pst.close();
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("Maresa-> Locking in the opportunity");
                    }
                    log.append("\tMaresa-> Locking in the opportunity\n");
                    pst = db.prepareStatement("UPDATE opportunity_header SET " + DatabaseUtils.addQuotes(db, "lock") + " = ? WHERE opp_id = ? ");
                    pst.setBoolean(1, true);
                    pst.setInt(2, oppHeader.getId());
                    pst.execute();
                    pst.close();
                }
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Maresa-> Adding products");
                }
                log.append("\tMaresa-> Adding products\n");
                QuoteList quoteList = new QuoteList();
                quoteList.setHeaderId(oppHeader.getId());
                quoteList.buildList(db);
                if (quoteList.size() == 0) {
                    Quote quote = new Quote();
                    quote.createNewGroup(db);
                    quote.setHeaderId(oppHeader.getId());
                    quote.setContactId(oppHeader.getContactLink());
                    Contact tmpContact = new Contact(db, oppHeader.getContactLink());
                    quote.setOrgId(tmpContact.getOrgId());
                    quote.setShortDescription("Reservation from Maresa");
                    quote.setEnteredBy(0);
                    quote.setModifiedBy(0);
                    boolean quoteInserted = quote.insert(db);
                    if (quoteInserted) {
                        Iterator i = products.iterator();
                        int quoteId = quote.getId();
                        while (i.hasNext()) {
                            QuoteProduct thisProduct = (QuoteProduct)((Object)i.next());
                            thisProduct.setQuoteId(quoteId);
                            recordInserted = false;
                            recordInserted = thisProduct.insert(db);
                            if (recordInserted) continue;
                            this.errors.put("ProductAddERROR", "Product " + thisProduct.getComment() + " could not be added");
                            throw new Exception("ProductAddERROR");
                        }
                    } else {
                        this.errors.put("QuoteAddError", " New quote could not be created");
                    }
                } else {
                    Quote tmpQuote = (Quote)((Object)quoteList.get(0));
                    for (QuoteProduct thisProduct : products) {
                        thisProduct.setQuoteId(tmpQuote.getId());
                        recordInserted = false;
                        recordInserted = thisProduct.insert(db);
                        if (recordInserted) continue;
                        this.errors.put("ProductAddERROR", "Product " + thisProduct.getComment() + " could not be added");
                        throw new Exception("ProductAddERROR");
                    }
                }
                if (thisComponent.getStatus() == OpportunityComponent.INCOMPLETE) {
                    thisComponent.changeStatus(db, OpportunityComponent.COMPLETE);
                }
                db.commit();
                String logData = this.createLog(input);
                this.writeLog(filePath, logData);
            }
            catch (Exception e) {
                String tmp = this.createExceptionLog(e, input, log);
                this.writeLog(filePath, tmp);
                if (db != null) {
                    db.rollback();
                }
                throw new SQLException(e.getMessage());
            }
            finally {
                if (db != null) {
                    db.setAutoCommit(true);
                }
                if (rs != null) {
                    rs.close();
                }
                if (pst != null) {
                    pst.close();
                }
                this.freeConnection(context, db);
            }
        }
        return "-none-";
    }

    private String createExceptionLog(Exception e, ArrayList input, StringBuffer log) {
        StringBuffer error = new StringBuffer();
        error.append(this.addLogHeader(input));
        error.append("Status: Failure\n");
        error.append("Errors:\n");
        for (String errorKey : this.errors.keySet()) {
            String errorMsg = (String)this.errors.get(errorKey);
            error.append("\t" + errorKey + ": " + errorMsg);
            error.append("\n");
        }
        error.append("Actual Error:\n\t" + e.toString() + "\n");
        error.append("LOG:\n " + log.toString());
        if (System.getProperty("DEBUG") != null) {
            System.out.println("TRANSACTION FAILED: \n" + error.toString());
        }
        return error.toString();
    }

    private String addLogHeader(ArrayList input) {
        StringBuffer header = new StringBuffer();
        header.append("====================================================================\n");
        if (input != null && input.size() > 0) {
            header.append("TransactionID: " + (String)input.get(0) + "\n");
            header.append("Time: " + Calendar.getInstance().getTime() + "\n");
            header.append("Input:\n");
            Iterator i = input.iterator();
            while (i.hasNext()) {
                header.append("\t" + (String)i.next() + "\n");
            }
        }
        return header.toString();
    }

    private String createLog(ArrayList input) {
        StringBuffer log = new StringBuffer();
        log.append(this.addLogHeader(input));
        log.append("Status: Success\n");
        if (System.getProperty("DEBUG") != null) {
            System.out.println("TRANSACTION SUCCESSFUL: \n" + log.toString());
        }
        return log.toString();
    }

    private void writeLog(String filePath, String log) {
        try {
            Calendar cal = Calendar.getInstance();
            String today = cal.get(1) + "" + (cal.get(2) + 1) + "" + cal.get(5);
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Maresa-> " + filePath);
            }
            String fileName = today + "maresalog.txt";
            BufferedWriter out = new BufferedWriter(new FileWriter(filePath + System.getProperty("file.separator") + fileName, true));
            out.write(log);
            out.close();
        }
        catch (Exception e) {
            System.out.println("FATAL: Error writing to log");
        }
    }
}

