/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.industry.spirit.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactAddress;
import org.aspcfs.modules.contacts.base.ContactAddressList;
import org.aspcfs.modules.contacts.base.ContactEmailAddress;
import org.aspcfs.modules.contacts.base.ContactEmailAddressList;
import org.aspcfs.modules.contacts.base.ContactPhoneNumber;
import org.aspcfs.modules.contacts.base.ContactPhoneNumberList;
import org.aspcfs.utils.StringUtils;

public class Maresa
extends GenericBean {
    private int maresaCifNo = -1;
    private int addressNo = 1;
    private ContactAddressList addressList = new ContactAddressList();
    private ContactPhoneNumberList phoneNumberList = new ContactPhoneNumberList();
    private ContactEmailAddressList emailAddressList = new ContactEmailAddressList();
    private String address1 = "";
    private String address2 = "";
    private String address3 = "";
    private String address4 = "";
    private String zipCode = "";
    private String city = "";
    private String state = "";
    private String phone = "";
    private String fax = "";
    private String email = "";
    private String url = "";
    private String idcsp = "001";
    private String country = "";
    private int segmentId = -1;
    private String segment = "";
    private int fcc = 0;
    private int dirBill = 0;
    private String tableName = null;
    private String orgName = "";
    private String title = "";
    private String nameFull = "";
    private int siteId = -1;

    public Maresa() {
    }

    public Maresa(ResultSet rs) throws SQLException {
    }

    public Maresa(Connection db, int org_id) throws SQLException {
        if (org_id == -1) {
            throw new SQLException("Invalid Account");
        }
    }

    public void setMaresaCifNo(int maresaCifNo) {
        this.maresaCifNo = maresaCifNo;
    }

    public int getMaresaCifNo() {
        return this.maresaCifNo;
    }

    public void setSiteId(int siteId) {
        this.siteId = siteId;
    }

    public void setSiteId(String tmp) {
        if (tmp != null) {
            this.siteId = Integer.parseInt(tmp);
        }
    }

    public int getSiteId() {
        return this.siteId;
    }

    public boolean insert(Connection SPIdb, Connection CFSdb, int maresaClient, int contactId, int orgId) throws SQLException {
        if (!this.isValid(SPIdb)) {
            return false;
        }
        if (!this.isValid(CFSdb)) {
            return false;
        }
        Contact newContact = null;
        Organization newOrganization = null;
        newContact = new Contact(CFSdb, contactId);
        newOrganization = new Organization(CFSdb, orgId);
        int salutation = newContact.getListSalutation();
        this.tableName = "lookup_title";
        this.title = this.getLookupValue(CFSdb, salutation, this.tableName);
        this.title = StringUtils.trimToSizeNoDots(this.title, 3);
        int segmentId = newOrganization.getSegmentId();
        this.tableName = "lookup_segments";
        this.segment = this.getLookupValue(CFSdb, segmentId, this.tableName);
        this.segment = this.segment.substring(0, 3);
        this.orgName = newOrganization.getName();
        this.orgName = StringUtils.trimToSizeNoDots(this.orgName, 32);
        this.url = newOrganization.getUrl();
        this.url = StringUtils.trimToSizeNoDots(this.url, 255);
        this.nameFull = newContact.getNameFirst() + " " + newContact.getNameLast();
        this.nameFull = StringUtils.trimToSizeNoDots(this.nameFull, 32);
        if (newOrganization.getDirectBill()) {
            this.dirBill = 1;
        }
        StringBuffer sql = new StringBuffer();
        this.addressList.setContactId(contactId);
        this.addressList.buildList(CFSdb);
        for (ContactAddress thisAddress : this.addressList) {
            if (!thisAddress.getPrimaryAddress()) continue;
            this.address1 = StringUtils.toString(thisAddress.getStreetAddressLine1()).toUpperCase();
            this.address1 = StringUtils.trimToSizeNoDots(this.address1, 32);
            this.address2 = StringUtils.toString(thisAddress.getStreetAddressLine2()).toUpperCase();
            this.address2 = StringUtils.trimToSizeNoDots(this.address2, 32);
            this.address3 = StringUtils.toString(thisAddress.getStreetAddressLine3()).toUpperCase();
            this.address3 = StringUtils.trimToSizeNoDots(this.address3, 32);
            this.address4 = StringUtils.toString(thisAddress.getStreetAddressLine4()).toUpperCase();
            this.address4 = StringUtils.trimToSizeNoDots(this.address4, 32);
            this.zipCode = thisAddress.getZip();
            this.zipCode = StringUtils.trimToSizeNoDots(this.zipCode, 10);
            this.state = StringUtils.toString(thisAddress.getState()).toUpperCase();
            this.state = StringUtils.trimToSizeNoDots(this.state, 3);
            this.city = StringUtils.toString(thisAddress.getCity()).toUpperCase();
            this.city = StringUtils.trimToSizeNoDots(this.city, 26);
            this.country = StringUtils.toString(thisAddress.getCountry()).toUpperCase();
            this.country = StringUtils.trimToSizeNoDots(this.country, 3);
            break;
        }
        this.phoneNumberList.setContactId(contactId);
        this.phoneNumberList.buildList(CFSdb);
        for (ContactPhoneNumber thisPhone : this.phoneNumberList) {
            if (!thisPhone.getPrimaryNumber()) continue;
            this.phone = thisPhone.getNumber();
            this.phone = StringUtils.trimToSizeNoDots(this.phone, 15);
            break;
        }
        for (ContactPhoneNumber thisPhone : this.phoneNumberList) {
            if (!thisPhone.getTypeName().trim().equals("Fax")) continue;
            this.fax = thisPhone.getNumber();
            this.fax = StringUtils.trimToSizeNoDots(this.fax, 15);
            break;
        }
        this.emailAddressList.setContactId(contactId);
        this.emailAddressList.buildList(CFSdb);
        for (ContactEmailAddress thisEmail : this.emailAddressList) {
            if (!thisEmail.getPrimaryEmail()) continue;
            this.email = thisEmail.getEmail();
            this.email = StringUtils.trimToSizeNoDots(this.email, 255);
            break;
        }
        this.country = "USA";
        try {
            SPIdb.setAutoCommit(false);
            sql.append("INSERT INTO FDIDET (idpor, idtit, idint1, idint2, idad1, idad2, idad3, idad4, ");
            sql.append("idpos, idvil, idpay, idco3, tel, fax, state_code, fcc, dir_bill, idcsp, mail, web_page)  ");
            sql.append("VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ,?, ?, ? ) ");
            int i = 0;
            PreparedStatement pst = SPIdb.prepareStatement(sql.toString());
            pst.setInt(++i, maresaClient);
            pst.setString(++i, this.title);
            pst.setString(++i, this.orgName.toUpperCase());
            pst.setString(++i, this.nameFull.toUpperCase());
            pst.setString(++i, this.address1.toUpperCase());
            pst.setString(++i, this.address2.toUpperCase());
            pst.setString(++i, this.address3.toUpperCase());
            pst.setString(++i, this.address4.toUpperCase());
            pst.setString(++i, this.zipCode);
            pst.setString(++i, this.city.toUpperCase());
            pst.setString(++i, this.country.toUpperCase());
            pst.setString(++i, this.segment);
            pst.setString(++i, this.phone);
            pst.setString(++i, this.fax);
            pst.setString(++i, this.state);
            pst.setInt(++i, this.fcc);
            pst.setInt(++i, this.dirBill);
            pst.setString(++i, this.idcsp);
            pst.setString(++i, this.email);
            pst.setString(++i, this.url);
            pst.execute();
            pst.close();
            SPIdb.commit();
        }
        catch (SQLException e) {
            SPIdb.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            SPIdb.setAutoCommit(true);
        }
        return true;
    }

    public int update(Connection SPIdb, Connection CFSdb, int maresaClient, int contactId, int orgId) throws SQLException {
        int resultCount = 0;
        if (!this.isValid(SPIdb)) {
            return -1;
        }
        if (!this.isValid(CFSdb)) {
            return -1;
        }
        Contact newContact = null;
        Organization newOrganization = null;
        newContact = new Contact(CFSdb, contactId);
        newOrganization = new Organization(CFSdb, orgId);
        int salutation = newContact.getListSalutation();
        this.tableName = "lookup_title";
        this.title = this.getLookupValue(CFSdb, salutation, this.tableName);
        this.title = StringUtils.trimToSizeNoDots(this.title, 3);
        int segmentId = newOrganization.getSegmentId();
        this.tableName = "lookup_segments";
        this.segment = this.getLookupValue(CFSdb, segmentId, this.tableName);
        this.segment = this.segment.substring(0, 3);
        this.orgName = newOrganization.getName();
        this.orgName = StringUtils.trimToSizeNoDots(this.orgName, 32);
        this.url = newOrganization.getUrl();
        this.url = StringUtils.trimToSizeNoDots(this.url, 255);
        this.nameFull = newContact.getNameFirst() + " " + newContact.getNameLast();
        this.nameFull = StringUtils.trimToSizeNoDots(this.nameFull, 32);
        if (newOrganization.getDirectBill()) {
            this.dirBill = 1;
        }
        this.addressList.setContactId(contactId);
        this.addressList.buildList(CFSdb);
        for (ContactAddress thisAddress : this.addressList) {
            if (!thisAddress.getPrimaryAddress()) continue;
            this.address1 = StringUtils.toString(thisAddress.getStreetAddressLine1()).toUpperCase();
            this.address1 = StringUtils.trimToSizeNoDots(this.address1, 32);
            this.address2 = StringUtils.toString(thisAddress.getStreetAddressLine2()).toUpperCase();
            this.address2 = StringUtils.trimToSizeNoDots(this.address2, 32);
            this.address3 = StringUtils.toString(thisAddress.getStreetAddressLine3()).toUpperCase();
            this.address3 = StringUtils.trimToSizeNoDots(this.address3, 32);
            this.address4 = StringUtils.toString(thisAddress.getStreetAddressLine4()).toUpperCase();
            this.address4 = StringUtils.trimToSizeNoDots(this.address4, 32);
            this.zipCode = thisAddress.getZip();
            this.zipCode = StringUtils.trimToSizeNoDots(this.zipCode, 10);
            this.state = StringUtils.toString(thisAddress.getState()).toUpperCase();
            this.state = StringUtils.trimToSizeNoDots(this.state, 3);
            this.city = StringUtils.toString(thisAddress.getCity()).toUpperCase();
            this.city = StringUtils.trimToSizeNoDots(this.city, 26);
            this.country = StringUtils.toString(thisAddress.getCountry()).toUpperCase();
            this.country = StringUtils.trimToSizeNoDots(this.country, 3);
            break;
        }
        this.phoneNumberList.setContactId(contactId);
        this.phoneNumberList.buildList(CFSdb);
        for (ContactPhoneNumber thisPhone : this.phoneNumberList) {
            if (!thisPhone.getTypeName().trim().equals("Fax")) continue;
            this.fax = thisPhone.getNumber();
            this.fax = StringUtils.trimToSizeNoDots(this.fax, 15);
            break;
        }
        for (ContactPhoneNumber thisPhone : this.phoneNumberList) {
            if (!thisPhone.getPrimaryNumber()) continue;
            this.phone = thisPhone.getNumber();
            this.phone = StringUtils.trimToSizeNoDots(this.phone, 15);
            break;
        }
        this.emailAddressList.setContactId(contactId);
        this.emailAddressList.buildList(CFSdb);
        for (ContactEmailAddress thisEmail : this.emailAddressList) {
            if (!thisEmail.getPrimaryEmail()) continue;
            this.email = thisEmail.getEmail();
            this.email = StringUtils.trimToSizeNoDots(this.email, 255);
            break;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE FDIDET SET idtit = ?, idint1 = ?, idint2 = ?,idad1 = ?, idad2 = ?, idad3 = ?, idad4 = ?, idpos = ?, idvil = ?, idpay = ?, idco3 = ?, tel = ?, fax = ?, state_code = ?, fcc = ?, dir_bill = ?, mail = ?,web_page = ? ");
        sql.append("WHERE idpor = ? ");
        int i = 0;
        pst = SPIdb.prepareStatement(sql.toString());
        pst.setString(++i, this.title);
        pst.setString(++i, this.orgName.toUpperCase());
        pst.setString(++i, this.nameFull.toUpperCase());
        pst.setString(++i, this.address1.toUpperCase());
        pst.setString(++i, this.address2.toUpperCase());
        pst.setString(++i, this.address3.toUpperCase());
        pst.setString(++i, this.address4.toUpperCase());
        pst.setString(++i, this.zipCode);
        pst.setString(++i, this.city.toUpperCase());
        pst.setString(++i, this.country.toUpperCase());
        pst.setString(++i, this.segment);
        pst.setString(++i, this.phone);
        pst.setString(++i, this.fax);
        pst.setString(++i, this.state);
        pst.setInt(++i, this.fcc);
        pst.setInt(++i, this.dirBill);
        pst.setString(++i, this.email);
        pst.setString(++i, this.url);
        pst.setInt(++i, maresaClient);
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    protected boolean isValid(Connection db) throws SQLException {
        this.errors.clear();
        return !this.hasErrors();
    }

    public String getLookupValue(Connection db, int thisSiteId, String tableName) throws SQLException {
        String maresaSite = null;
        ResultSet rs = null;
        int items = -1;
        PreparedStatement pst = db.prepareStatement("SELECT description FROM " + tableName + " " + "WHERE code = ? ");
        pst.setInt(1, thisSiteId);
        rs = pst.executeQuery();
        while (rs.next()) {
            maresaSite = rs.getString("description");
        }
        rs.close();
        pst.close();
        return maresaSite;
    }

    public boolean insertMaresaClient(Connection CFSdb, int maresaClient, int contactId, int orgId, int thisSiteId) throws SQLException {
        if (!this.isValid(CFSdb)) {
            return false;
        }
        StringBuffer sql = new StringBuffer();
        try {
            CFSdb.setAutoCommit(false);
            sql.append("INSERT INTO MARESA_CLIENT (org_id, contact_id, site_id, client_id ) ");
            sql.append("VALUES (?, ?, ?, ? ) ");
            int i = 0;
            PreparedStatement pst = CFSdb.prepareStatement(sql.toString());
            pst.setInt(++i, orgId);
            pst.setInt(++i, contactId);
            pst.setInt(++i, thisSiteId);
            pst.setInt(++i, maresaClient);
            pst.execute();
            pst.close();
            CFSdb.commit();
        }
        catch (SQLException e) {
            CFSdb.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            CFSdb.setAutoCommit(true);
        }
        return true;
    }
}

