/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.industry.spirit.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.industry.spirit.base.MaresaClient;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public class MaresaClientList
extends ArrayList {
    public static final String tableName = "call_log";
    public static final String uniqueField = "call_id";
    protected PagedListInfo pagedListInfo = null;
    protected int siteId = -1;
    protected int orgId = -1;
    protected int contactId = -1;
    protected int defaultKey = -1;
    protected String siteClient = null;

    public MaresaClientList() {
    }

    public MaresaClientList(Connection db, String thisContact) throws SQLException {
        this.contactId = Integer.parseInt(thisContact);
        this.buildList(db);
    }

    public MaresaClientList(Connection db, int contactId) throws SQLException {
        this.contactId = contactId;
        this.buildList(db);
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setSiteId(int siteId) {
        this.siteId = siteId;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setSiteClient(String siteClient) {
        this.siteClient = siteClient;
    }

    public String getSiteClient() {
        return this.siteClient;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setDefaultKey(int tmp) {
        this.defaultKey = tmp;
    }

    public void setDefaultKey(String tmp) {
        this.defaultKey = Integer.parseInt(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) as recordcount FROM lookup_site_id lsi, maresa_client mc  WHERE code > -1 and lsi.code = mc.site_id ");
        this.createFilter(db, sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(db, pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("level", "code");
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY code DESC ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("maresa_id, client_id, site_id FROM lookup_site_id, maresa_client WHERE code > -1 and lookup_site_id.code = maresa_client.site_id ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(db, pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        for (int count = 0; rs.next() && (this.pagedListInfo == null || this.pagedListInfo.getItemsPerPage() <= 0 || DatabaseUtils.getType(db) != 2 || count < this.pagedListInfo.getItemsPerPage()); ++count) {
            MaresaClient thisMaresaClient = new MaresaClient(rs);
            this.add(thisMaresaClient);
        }
        rs.close();
        pst.close();
    }

    protected void createFilter(Connection db, StringBuffer sqlFilter) throws SQLException {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        Contact newContact = null;
        newContact = new Contact(db, this.contactId);
        this.orgId = newContact.getOrgId();
        if (this.orgId > -1) {
            sqlFilter.append("AND org_id = ? ");
        }
        if (this.contactId > -1) {
            sqlFilter.append("AND contact_id = ? ");
        }
    }

    protected int prepareFilter(Connection db, PreparedStatement pst) throws SQLException {
        int i = 0;
        boolean j = true;
        if (this.orgId > -1) {
            pst.setInt(++i, this.orgId);
        }
        if (this.contactId > -1) {
            pst.setInt(++i, this.contactId);
        }
        return i;
    }

    public String getHtmlSelect(String selectName) {
        return this.getHtmlSelect(selectName, this.defaultKey);
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        LookupList maresaClientSelect = new LookupList();
        maresaClientSelect = this.getLookupList(selectName, defaultKey);
        return maresaClientSelect.getHtmlSelect(selectName, defaultKey);
    }

    public LookupList getLookupList(String selectName, int defaultKey) {
        LookupList maresaClientSelect = new LookupList();
        for (MaresaClient thisMaresaClient : this) {
            maresaClientSelect.appendItem(thisMaresaClient.getSiteId(), thisMaresaClient.getSiteClient());
        }
        return maresaClientSelect;
    }
}

