/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.industry.spirit.validators;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.pipeline.base.OpportunityComponent;
import org.aspcfs.modules.pipeline.base.OpportunityHeader;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.modules.quotes.base.Quote;
import org.aspcfs.modules.quotes.base.QuoteList;
import org.aspcfs.modules.quotes.base.QuoteProduct;
import org.aspcfs.modules.quotes.base.QuoteProductList;
import org.aspcfs.utils.ObjectUtils;

public class CustomValidator {
    public static boolean validate(SystemStatus systemStatus, Connection db, Object object) throws SQLException {
        Quote quote;
        OpportunityHeader header;
        HashMap errors;
        if (object.getClass().getName().equals("org.aspcfs.modules.pipeline.base.OpportunityComponent")) {
            OpportunityComponent oppComponent = (OpportunityComponent)((Object)object);
            if (oppComponent.getCloseProb() >= 0.8) {
                HashMap errors2 = (HashMap)ObjectUtils.getObject(object, "errors");
                errors2.put("closeProbError", " Close probability should be less than 80%");
            }
            oppComponent.setTerms(1.0);
            oppComponent.setUnits("M");
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.quotes.base.QuoteProductList")) {
            QuoteProductList quoteProductList = (QuoteProductList)object;
            Iterator productItr = quoteProductList.iterator();
            boolean foundTicket = false;
            while (productItr.hasNext()) {
                QuoteProduct quoteProduct = (QuoteProduct)((Object)productItr.next());
                ProductCatalog productCatalog = new ProductCatalog(db, quoteProduct.getProductId());
                if (!productCatalog.getSku().equals("00010") || quoteProduct.getQuantity() <= 0) continue;
                foundTicket = true;
                break;
            }
            if (!foundTicket) {
                errors = (HashMap)ObjectUtils.getObject(object, "errors");
                errors.put("actionError", "This quote should have a ticket.");
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.quotes.base.Quote") && (header = new OpportunityHeader(db, (quote = (Quote)((Object)object)).getHeaderId())).getLock()) {
            QuoteList quoteList = new QuoteList();
            quoteList.setHeaderId(quote.getHeaderId());
            quoteList.buildList(db);
            if (quoteList.size() > 0) {
                Quote tmpQuote = (Quote)((Object)quoteList.get(0));
                if (tmpQuote.getId() != quote.getId()) {
                    HashMap errors3 = (HashMap)ObjectUtils.getObject(object, "errors");
                    errors3.put("headerIdError", " A quote cannot be added to a locked opportunity");
                }
            } else {
                errors = (HashMap)ObjectUtils.getObject(object, "errors");
                errors.put("headerIdError", " A quote cannot be added to a locked opportunity");
            }
        }
        return true;
    }
}

