/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.login.actions;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.database.ConnectionPool;
import com.darkhorseventures.framework.actions.ActionContext;
import com.darkhorseventures.framework.hooks.CustomHook;
import java.sql.Connection;
import java.util.Date;
import java.util.Hashtable;
import javax.servlet.http.HttpSession;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.controller.SecurityHook;
import org.aspcfs.controller.SessionManager;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.login.beans.LoginBean;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.modules.system.base.Site;
import org.aspcfs.modules.system.base.SiteList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.LDAPUtils;

public final class Login
extends CFSModule {
    public static final String fs = System.getProperty("file.separator");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDefault(ActionContext context) {
        ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
        Connection db = null;
        try {
            Site thisSite = SecurityHook.retrieveSite(context.getServletContext(), context.getRequest());
            ConnectionElement ce = thisSite.getConnectionElement();
            context.getSession().setAttribute("ConnectionElement", (Object)ce);
            db = this.getConnection(context, ce);
            SecurityHook.retrieveSystemStatus(context.getServletContext(), db, ce, thisSite.getLanguage());
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            System.out.println("Login-> Default error: " + e.getMessage());
        }
        finally {
            this.freeConnection(context, db);
        }
        String scheme = context.getRequest().getScheme();
        if ("true".equals((String)context.getServletContext().getAttribute("ForceSSL")) && scheme.equals("http")) {
            context.getRequest().setAttribute("LAYOUT.JSP", (Object)prefs.get("LAYOUT.JSP.WELCOME"));
        } else {
            context.getRequest().setAttribute("LAYOUT.JSP", (Object)prefs.get("LAYOUT.JSP.LOGIN"));
        }
        return "IndexPageOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String executeCommandLogin(ActionContext context) {
        applicationPrefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
        loginBean = (LoginBean)context.getFormBean();
        loginBean.checkURL(context);
        username = loginBean.getUsername();
        password = loginBean.getPassword();
        serverName = context.getRequest().getServerName();
        gkDriver = Login.getPref(context, "GATEKEEPER.DRIVER");
        gkHost = Login.getPref(context, "GATEKEEPER.URL");
        gkUser = Login.getPref(context, "GATEKEEPER.USER");
        gkUserPw = Login.getPref(context, "GATEKEEPER.PASSWORD");
        siteCode = Login.getPref(context, "GATEKEEPER.APPCODE");
        gk = new ConnectionElement(gkHost, gkUser, gkUserPw);
        gk.setDriver(gkDriver);
        sqlDriver = (ConnectionPool)context.getServletContext().getAttribute("ConnectionPool");
        if (sqlDriver == null) {
            loginBean.setMessage("Connection pool missing!");
            return "LoginRetry";
        }
        db = null;
        ce = null;
        try {
            if ("true".equals((String)context.getServletContext().getAttribute("WEBSERVER.ASPMODE"))) {
                db = sqlDriver.getConnection(gk);
                siteList = new SiteList();
                siteList.setSiteCode(siteCode);
                siteList.setVirtualHost(serverName);
                siteList.buildList(db);
                if (siteList.size() > 0) {
                    thisSite = (Site)siteList.get(0);
                    ce = new ConnectionElement(thisSite.getDatabaseUrl(), thisSite.getDatabaseUsername(), thisSite.getDatabasePassword());
                    ce.setDbName(thisSite.getDatabaseName());
                    ce.setDriver(thisSite.getDatabaseDriver());
                } else {
                    loginBean.setMessage("* Access denied: Host does not exist (" + serverName + ")");
                }
            } else {
                ce = new ConnectionElement(gkHost, gkUser, gkUserPw);
                ce.setDbName(Login.getPref(context, "GATEKEEPER.DATABASE"));
                ce.setDriver(gkDriver);
            }
            ** if (db == null) goto lbl-1000
        }
        catch (Exception e) {
            try {
                loginBean.setMessage("* Gatekeeper: " + e.getMessage());
                ** if (db == null) goto lbl-1000
            }
            catch (Throwable var18_20) {
                if (db != null) {
                    sqlDriver.free(db);
                }
                throw var18_20;
            }
lbl-1000:
            // 1 sources

            {
                sqlDriver.free(db);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            sqlDriver.free(db);
        }
lbl-1000:
        // 2 sources

        {
        }
        if (ce == null) {
            return "LoginRetry";
        }
        thisUser = null;
        userId = -1;
        aliasId = -1;
        roleId = -1;
        role = null;
        userId2 = null;
        now = new Date();
        continueId = false;
        try {
            thisSystem = null;
            db = sqlDriver.getConnection(ce);
            if (applicationPrefs.isUpgradeable()) {
                continueId = true;
            } else {
                thisSite = SecurityHook.retrieveSite(context.getServletContext(), context.getRequest());
                thisSystem = SecurityHook.retrieveSystemStatus(context.getServletContext(), db, ce, thisSite.getLanguage());
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Login-> Retrieved SystemStatus from memory : " + (thisSystem == null ? "false" : "true"));
                }
                continueId = CustomHook.populateLoginContext((ActionContext)context, (Connection)db, (SystemStatus)thisSystem, (LoginBean)loginBean);
            }
            pw = null;
            expDate = null;
            tmpUserId = -1;
            roleType = -1;
            if (continueId) {
                pst = db.prepareStatement("SELECT a." + DatabaseUtils.addQuotes(db, "password") + ", a.role_id, r." + DatabaseUtils.addQuotes(db, "role") + ", a.expires, a.alias, a.user_id, r.role_type " + "FROM " + DatabaseUtils.addQuotes(db, "access") + " a, " + DatabaseUtils.addQuotes(db, "role") + " r " + "WHERE a.role_id = r.role_id " + "AND " + DatabaseUtils.toLowerCase(db) + "(a.username) = ? " + "AND a.enabled = ? ");
                pst.setString(1, username.toLowerCase());
                pst.setBoolean(2, true);
                rs = pst.executeQuery();
                if (rs.next()) {
                    pw = rs.getString("password");
                    roleId = rs.getInt("role_id");
                    role = rs.getString("role");
                    expDate = rs.getDate("expires");
                    aliasId = rs.getInt("alias");
                    tmpUserId = rs.getInt("user_id");
                    roleType = rs.getInt("role_type");
                }
                rs.close();
                pst.close();
                if (tmpUserId == -1) {
                    loginBean.setMessage("* " + thisSystem.getLabel("login.msg.invalidLoginInfo"));
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("Login-> User record not found in database for: " + username.toLowerCase());
                    }
                } else if (expDate != null && now.after(expDate)) {
                    loginBean.setMessage("* " + thisSystem.getLabel("login.msg.accountExpired"));
                } else {
                    ldapEnabled = "true".equals(applicationPrefs.get("LDAP.ENABLED"));
                    if (ldapEnabled && roleType == 0) {
                        ldapResult = LDAPUtils.authenticateUser(applicationPrefs, db, loginBean);
                        if (ldapResult == LDAPUtils.RESULT_VALID) {
                            userId = tmpUserId;
                        }
                    } else if (pw == null || pw.trim().equals("") || !pw.equals(password) && !context.getServletContext().getAttribute("GlobalPWInfo").equals(password)) {
                        loginBean.setMessage("* " + thisSystem.getLabel("login.msg.invalidLoginInfo"));
                    } else {
                        userId = tmpUserId;
                    }
                }
            }
            if (userId > -1) {
                thisUser = new UserBean();
                thisUser.setSessionId(context.getSession().getId());
                thisUser.setUserId(aliasId > 0 ? aliasId : userId);
                thisUser.setActualUserId(userId);
                thisUser.setConnectionElement(ce);
                thisUser.setClientType(context.getRequest());
                if (thisSystem != null) {
                    userRecord = thisSystem.getUser(thisUser.getUserId());
                    if (userRecord != null) {
                        if (System.getProperty("DEBUG") != null) {
                            System.out.println("Login-> Retrieved user from memory: " + userRecord.getUsername());
                        }
                        thisUser.setIdRange(userRecord.getIdRange());
                        thisUser.setUserRecord(userRecord);
                        userRecord.setIp(context.getIpAddress());
                        userRecord.updateLogin(db);
                        userRecord.checkWebdavAccess(db, context.getRequest().getParameter("password"));
                    }
                    if (!thisSystem.hasPermissions()) {
                        System.out.println("Login-> This system does not have any permissions loaded!");
                    }
                } else if (System.getProperty("DEBUG") != null) {
                    System.out.println("Login-> Fatal: User not found in this System!");
                }
            } else if (System.getProperty("DEBUG") != null) {
                System.out.println("Login-> Fatal: User does not have an Id!");
            }
        }
        catch (Exception e) {
            loginBean.setMessage("* Access: " + e.getMessage());
            if (System.getProperty("DEBUG") != null) {
                e.printStackTrace(System.out);
            }
            thisUser = null;
        }
        finally {
            if (db != null) {
                sqlDriver.free(db);
            }
        }
        if (thisUser == null) {
            return "LoginRetry";
        }
        context.getSession().setAttribute("User", thisUser);
        context.getSession().setAttribute("ConnectionElement", (Object)ce);
        if (applicationPrefs.isUpgradeable()) {
            if (roleId == 1 || "Administrator".equals(role)) {
                context.getSession().setAttribute("UPGRADEOK", (Object)"UPGRADEOK");
                return "PerformUpgradeOK";
            }
            return "UpgradeCheck";
        }
        thisSystem = (SystemStatus)((Hashtable)context.getServletContext().getAttribute("SystemStatus")).get(ce.getUrl());
        sessionManager = thisSystem.getSessionManager();
        if (sessionManager.isUserLoggedIn(userId)) {
            thisSession = sessionManager.getUserSession(userId);
            context.getSession().setMaxInactiveInterval(300);
            context.getRequest().setAttribute("Session", (Object)thisSession);
            return "LoginVerifyOK";
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println("Login-> Session Size: " + sessionManager.size());
        }
        context.getSession().setMaxInactiveInterval(thisSystem.getSessionTimeout());
        sessionManager.addUser(context, userId);
        redirectTo = context.getRequest().getParameter("redirectTo");
        if (thisUser.getRoleType() == 0) {
            if (redirectTo != null) {
                return "RedirectURL";
            }
            return "LoginOK";
        }
        if (thisUser.getRoleType() == 1) {
            return "CustomerPortalLoginOK";
        }
        if (thisUser.getRoleType() == 420041011) {
            return "ProductsPortalLoginOK";
        }
        if (redirectTo != null) {
            return "RedirectURL";
        }
        return "LoginOK";
    }

    public String executeCommandLoginConfirm(ActionContext context) {
        UserBean thisUser = (UserBean)((Object)context.getSession().getAttribute("User"));
        if (thisUser == null) {
            return this.executeCommandLogout(context);
        }
        String action = context.getRequest().getParameter("override");
        if ("yes".equals(action)) {
            SystemStatus systemStatus = (SystemStatus)((Hashtable)context.getServletContext().getAttribute("SystemStatus")).get(thisUser.getConnectionElement().getUrl());
            context.getSession().setMaxInactiveInterval(systemStatus.getSessionTimeout());
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Login-> Invalidating old Session");
            }
            SessionManager sessionManager = systemStatus.getSessionManager();
            sessionManager.replaceUserSession(context, thisUser.getActualUserId());
            if (thisUser.getRoleType() == 0) {
                ApplicationPrefs applicationPrefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
                if (applicationPrefs.isUpgradeable()) {
                    if (thisUser.getRoleId() == 1 || "Administrator".equals(thisUser.getRole())) {
                        return "PerformUpgradeOK";
                    }
                    return "UpgradeCheck";
                }
                String redirectTo = context.getRequest().getParameter("redirectTo");
                if (redirectTo != null) {
                    context.getRequest().removeAttribute("PageLayout");
                    return "RedirectURL";
                }
                return "LoginOK";
            }
            if (thisUser.getRoleType() == 1) {
                return "CustomerPortalLoginOK";
            }
            if (thisUser.getRoleType() == 420041011) {
                return "ProductsPortalLoginOK";
            }
        } else {
            return this.executeCommandLogout(context);
        }
        String redirectTo = context.getRequest().getParameter("redirectTo");
        if (redirectTo != null) {
            context.getRequest().removeAttribute("PageLayout");
            return "RedirectURL";
        }
        return "LoginOK";
    }

    public String executeCommandLogout(ActionContext context) {
        HttpSession oldSession = context.getRequest().getSession(false);
        if (oldSession != null) {
            oldSession.removeAttribute("User");
            oldSession.invalidate();
        }
        return "LoginRetry";
    }
}

