/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.login.base;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.database.ConnectionPool;
import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.controller.ApplicationPrefs;

public class AuthenticationItem {
    public static final int ASPMODE = 1;
    public static final int SYNC_CLIENT = 2;
    public static final int CENTRIC_USER = 3;
    private String id = null;
    private String code = null;
    private int systemId = -1;
    private int clientId = -1;
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private String authCode = "unset";
    private String encoding = "UTF-8";
    private String username = null;
    private String url = null;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String tmp) {
        this.url = tmp;
    }

    public void setId(String tmp) {
        this.id = tmp;
    }

    public void setCode(String tmp) {
        this.code = tmp;
    }

    public void setClientId(int tmp) {
        this.clientId = tmp;
    }

    public void setClientId(String tmp) {
        this.clientId = Integer.parseInt(tmp);
    }

    public void setSystemId(int tmp) {
        this.systemId = tmp;
    }

    public void setSystemId(String tmp) {
        this.systemId = Integer.parseInt(tmp);
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setAuthCode(String tmp) {
        this.authCode = tmp;
    }

    public void setEncoding(String tmp) {
        this.encoding = tmp;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String tmp) {
        this.username = tmp;
    }

    public String getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public int getClientId() {
        return this.clientId;
    }

    public int getSystemId() {
        return this.systemId;
    }

    public Timestamp getLastAnchor() {
        return this.lastAnchor;
    }

    public Timestamp getNextAnchor() {
        return this.nextAnchor;
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getType() {
        if (this.username != null && this.clientId > -1) {
            return -1;
        }
        if (this.username != null) {
            return 3;
        }
        if (this.clientId > -1) {
            return 2;
        }
        return -1;
    }

    public Connection getConnection(ActionContext context) throws SQLException {
        return this.getConnection(context, true);
    }

    public ConnectionElement getConnectionElement(ActionContext context) throws SQLException {
        ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
        String gkHost = prefs.get("GATEKEEPER.URL");
        String gkUser = prefs.get("GATEKEEPER.USER");
        String gkUserPw = prefs.get("GATEKEEPER.PASSWORD");
        String siteCode = prefs.get("GATEKEEPER.APPCODE");
        String gkDriver = prefs.get("GATEKEEPER.DRIVER");
        String serverName = context.getRequest().getServerName();
        if (System.getProperty("DEBUG") != null) {
            System.out.println("AuthenticationItem-> GateKeeper: " + gkHost);
            System.out.println("AuthenticationItem-> ServerName: " + serverName);
            System.out.println("AuthenticationItem-> SiteCode: " + siteCode);
            System.out.println("AuthenticationItem-> Driver: " + gkDriver);
        }
        ConnectionPool sqlDriver = (ConnectionPool)context.getServletContext().getAttribute("ConnectionPool");
        ConnectionElement gk = new ConnectionElement(gkHost, gkUser, gkUserPw);
        gk.setDriver(gkDriver);
        if (!"true".equals((String)context.getServletContext().getAttribute("WEBSERVER.ASPMODE"))) {
            gk.setDbName(prefs.get("GATEKEEPER.DATABASE"));
            if (System.getProperty("DEBUG") != null) {
                System.out.println("AuthenticationItem-> Database: " + gk.getDbName());
            }
            return gk;
        }
        Connection db = null;
        try {
            ConnectionElement ce = null;
            db = sqlDriver.getConnection(gk);
            PreparedStatement pst = db.prepareStatement("SELECT * FROM sites WHERE sitecode = ? AND vhost = ? ");
            pst.setString(1, siteCode);
            pst.setString(2, serverName);
            ResultSet rs = pst.executeQuery();
            if (rs.next()) {
                String siteDbHost = rs.getString("dbhost");
                String siteDbName = rs.getString("dbname");
                String siteDbUser = rs.getString("dbuser");
                String siteDbPw = rs.getString("dbpw");
                String siteDriver = rs.getString("driver");
                this.authCode = rs.getString("code");
                ce = new ConnectionElement(siteDbHost, siteDbUser, siteDbPw);
                ce.setDbName(siteDbName);
                ce.setDriver(siteDriver);
            }
            rs.close();
            pst.close();
            ConnectionElement connectionElement = ce;
            return connectionElement;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        finally {
            if (db != null) {
                sqlDriver.free(db);
            }
        }
    }

    public Connection getConnection(ActionContext context, boolean checkCode) throws SQLException {
        ConnectionElement ce = this.getConnectionElement(context);
        if (this.isAuthenticated(context, checkCode) && ce != null) {
            ConnectionPool sqlDriver = (ConnectionPool)context.getServletContext().getAttribute("ConnectionPool");
            return sqlDriver.getConnection(ce);
        }
        return null;
    }

    public boolean isAuthenticated(ActionContext context) {
        return this.isAuthenticated(context, true);
    }

    public boolean isAuthenticated(ActionContext context, boolean checkCode) {
        String serverName = context.getRequest().getServerName();
        if (!checkCode) {
            return true;
        }
        return this.id != null && this.id.equals(serverName) && this.code != null && this.authCode != null && this.code.equals(this.authCode);
    }
}

