/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.media.autoguide.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.isavvix.tools.FileInfo;
import com.isavvix.tools.HttpMultiPartParser;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemList;
import com.zeroio.iteam.base.FileItemVersion;
import com.zeroio.webutils.FileDownload;
import java.io.File;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.media.autoguide.base.AdRun;
import org.aspcfs.modules.media.autoguide.base.Inventory;
import org.aspcfs.modules.media.autoguide.base.InventoryList;
import org.aspcfs.modules.media.autoguide.base.Make;
import org.aspcfs.modules.media.autoguide.base.MakeList;
import org.aspcfs.modules.media.autoguide.base.Model;
import org.aspcfs.modules.media.autoguide.base.ModelList;
import org.aspcfs.modules.media.autoguide.base.OptionList;
import org.aspcfs.modules.media.autoguide.base.Vehicle;
import org.aspcfs.modules.media.autoguide.base.VehicleList;
import org.aspcfs.utils.ImageUtils;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public final class AutoGuide
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return this.executeCommandList(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandList(ActionContext context) {
        if (!this.hasPermission(context, "autoguide-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        PagedListInfo autoGuideDirectoryInfo = this.getPagedListInfo(context, "AutoGuideDirectoryInfo");
        autoGuideDirectoryInfo.setLink("AutoGuide.do?command=List");
        Connection db = null;
        InventoryList inventoryList = new InventoryList();
        try {
            db = this.getConnection(context);
            this.populateListFilters(context, autoGuideDirectoryInfo);
            this.populateMakeSelect(context, db, null, "All Makes");
            inventoryList.setPagedListInfo(autoGuideDirectoryInfo);
            inventoryList.setBuildOrganizationInfo(true);
            inventoryList.setShowSold(autoGuideDirectoryInfo.getFilterKey("listFilter1"));
            inventoryList.setShowIncompleteAdRunsOnly(true);
            inventoryList.setShowIncompleteInventoryAds(autoGuideDirectoryInfo.getFilterKey("listFilter2"));
            inventoryList.setMakeId(autoGuideDirectoryInfo.getFilterKey("listFilter3"));
            inventoryList.buildList(db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Auto Guide", "List");
        if (errorMessage == null) {
            context.getRequest().setAttribute("InventoryList", (Object)inventoryList);
            if ("slides".equals(autoGuideDirectoryInfo.getListView())) {
                return "List2OK";
            }
            return "ListOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "autoguide-view") && !this.hasPermission(context, "accounts-autoguide-inventory-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        try {
            int id = Integer.parseInt(context.getRequest().getParameter("id"));
            if (System.getProperty("DEBUG") != null) {
                System.out.println("AutoGuide-> Details for ID: " + id);
            }
            db = this.getConnection(context);
            Inventory inventoryItem = new Inventory(db, id);
            context.getRequest().setAttribute("InventoryItem", (Object)inventoryItem);
            String orgId = context.getRequest().getParameter("orgId");
            if (orgId == null) {
                this.addModuleBean(context, "Auto Guide", "Details");
            } else {
                this.addModuleBean(context, "View Accounts", "Vehicle Details");
                this.populateOrganization(context, db, Integer.parseInt(orgId));
            }
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "DetailsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMarkComplete(ActionContext context) {
        if (!this.hasPermission(context, "autoguide-adruns-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        try {
            int id = Integer.parseInt(context.getRequest().getParameter("id"));
            int adId = Integer.parseInt(context.getRequest().getParameter("adId"));
            db = this.getConnection(context);
            Inventory inventoryItem = new Inventory(db, id);
            AdRun thisAdRun = inventoryItem.getAdRuns().getAdRun(adId);
            thisAdRun.setCompletedBy(this.getUserId(context));
            thisAdRun.markComplete(db);
            this.addModuleBean(context, "Auto Guide", "Details");
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "MarkCompleteOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMarkIncomplete(ActionContext context) {
        if (!this.hasPermission(context, "autoguide-adruns-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        try {
            int id = Integer.parseInt(context.getRequest().getParameter("id"));
            int adId = Integer.parseInt(context.getRequest().getParameter("adId"));
            db = this.getConnection(context);
            Inventory inventoryItem = new Inventory(db, id);
            AdRun thisAdRun = inventoryItem.getAdRuns().getAdRun(adId);
            thisAdRun.markIncomplete(db, this.getUserRange(context));
            this.addModuleBean(context, "Auto Guide", "Details");
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "MarkIncompleteOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "accounts-autoguide-inventory-delete")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        try {
            int id = Integer.parseInt(context.getRequest().getParameter("id"));
            if (System.getProperty("DEBUG") != null) {
                System.out.println("AutoGuide-> Delete ID: " + id);
            }
            db = this.getConnection(context);
            Inventory inventoryItem = new Inventory(db, id);
            inventoryItem.delete(db);
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Auto Guide", "Delete");
        if (errorMessage == null) {
            return "DeleteOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAccountList(ActionContext context) {
        if (!this.hasPermission(context, "accounts-autoguide-inventory-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        int orgId = Integer.parseInt(context.getRequest().getParameter("orgId"));
        PagedListInfo autoGuideAccountInfo = this.getPagedListInfo(context, "AutoGuideAccountInfo");
        autoGuideAccountInfo.setLink("AccountsAutoGuide.do?command=AccountList&orgId=" + orgId);
        Connection db = null;
        InventoryList inventoryList = new InventoryList();
        try {
            db = this.getConnection(context);
            this.populateOrganization(context, db, orgId);
            this.populateListFilters(context, autoGuideAccountInfo);
            inventoryList.setPagedListInfo(autoGuideAccountInfo);
            inventoryList.setOrgId(orgId);
            inventoryList.setBuildOrganizationInfo(false);
            inventoryList.setShowSold(autoGuideAccountInfo.getFilterKey("listFilter1"));
            inventoryList.buildList(db);
            context.getRequest().setAttribute("InventoryList", (Object)inventoryList);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Accounts", "Vehicle Inventory");
        if (errorMessage == null) {
            if ("slides".equals(autoGuideAccountInfo.getListView())) {
                return "List2OK";
            }
            return "ListOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAccountAdd(ActionContext context) {
        if (!this.hasPermission(context, "accounts-autoguide-inventory-add")) {
            return "PermissionError";
        }
        int orgId = Integer.parseInt(context.getRequest().getParameter("orgId"));
        Connection db = null;
        try {
            db = this.getConnection(context);
            this.populateOrganization(context, db, orgId);
            this.populateYearSelect(context, db);
            this.populateMakeSelect(context, db, null, null);
            this.populateModelSelect(context, db, null);
            this.populateOptionList(context, db);
            this.populateAdRunTypeSelect(context, db);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Accounts", "Add Vehicle");
        return "AddOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAccountInsert(ActionContext context) {
        if (!this.hasPermission(context, "accounts-autoguide-inventory-add")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        boolean recordInserted = false;
        Inventory thisItem = (Inventory)context.getFormBean();
        thisItem.setRequestItems(context.getRequest());
        thisItem.setEnteredBy(this.getUserId(context));
        thisItem.setModifiedBy(this.getUserId(context));
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisItem.generateVehicleId(db);
            recordInserted = thisItem.insert(db);
            if (recordInserted) {
                thisItem = new Inventory(db, thisItem.getId());
                context.getRequest().setAttribute("InventoryDetails", (Object)thisItem);
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Accounts", "Add Vehicle");
        if (errorMessage == null) {
            if (recordInserted) {
                return "InsertOK";
            }
            return this.executeCommandAccountAdd(context);
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String executeCommandUpdateMakeList(ActionContext context) {
        Connection db = null;
        try {
            String year = context.getRequest().getParameter("year");
            db = this.getConnection(context);
            MakeList makeList = new MakeList();
            if (year != null) {
                makeList.setYear(year);
            }
            makeList.buildList(db);
            context.getRequest().setAttribute("MakeList", (Object)makeList);
        }
        catch (Exception exception) {
            this.freeConnection(context, db);
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
        }
        this.freeConnection(context, db);
        return "MakeListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String executeCommandUpdateModelList(ActionContext context) {
        Connection db = null;
        try {
            int makeId = Integer.parseInt(context.getRequest().getParameter("makeId"));
            String year = context.getRequest().getParameter("year");
            db = this.getConnection(context);
            ModelList modelList = new ModelList();
            if (makeId > -1) {
                modelList.setMakeId(makeId);
                if (year != null) {
                    modelList.setYear(year);
                }
                modelList.buildList(db);
            }
            context.getRequest().setAttribute("ModelList", (Object)modelList);
        }
        catch (Exception exception) {
            this.freeConnection(context, db);
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
        }
        this.freeConnection(context, db);
        return "ModelListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAccountModify(ActionContext context) {
        if (!this.hasPermission(context, "accounts-autoguide-inventory-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        String orgId = context.getRequest().getParameter("orgId");
        String id = context.getRequest().getParameter("id");
        Connection db = null;
        try {
            db = this.getConnection(context);
            Inventory thisItem = new Inventory(db, Integer.parseInt(id));
            context.getRequest().setAttribute("InventoryDetails", (Object)thisItem);
            this.populateOrganization(context, db, Integer.parseInt(orgId));
            this.populateYearSelect(context, db);
            this.populateMakeSelect(context, db, thisItem.getVehicle(), null);
            this.populateModelSelect(context, db, thisItem.getVehicle());
            this.populateOptionList(context, db);
            this.populateAdRunTypeSelect(context, db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Accounts", "Modify Vehicle");
        if (errorMessage == null) {
            return "ModifyOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAccountUpdate(ActionContext context) {
        if (!this.hasPermission(context, "accounts-autoguide-inventory-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        String orgid = context.getRequest().getParameter("orgId");
        int resultCount = 0;
        try {
            Inventory thisItem = (Inventory)context.getFormBean();
            thisItem.setRequestItems(context.getRequest());
            thisItem.setModifiedBy(this.getUserId(context));
            db = this.getConnection(context);
            thisItem.generateVehicleId(db);
            resultCount = thisItem.update(db);
            if (resultCount == -1) {
                this.populateOrganization(context, db, Integer.parseInt(orgid));
            }
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (resultCount == -1) {
                return "ModifyOK";
            }
            if (resultCount == 1) {
                return "UpdateOK";
            }
            context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
            return "UserError";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUploadForm(ActionContext context) {
        if (!this.hasPermission(context, "accounts-autoguide-inventory-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        try {
            int id = Integer.parseInt(context.getRequest().getParameter("id"));
            db = this.getConnection(context);
            Inventory inventoryItem = new Inventory(db, id);
            context.getRequest().setAttribute("InventoryItem", (Object)inventoryItem);
            this.addModuleBean(context, "Auto Guide", "Photo Upload");
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "UploadFormOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpload(ActionContext context) {
        if (!this.hasPermission(context, "accounts-autoguide-inventory-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean isValid = false;
        boolean recordInserted = false;
        try {
            String filePath = this.getPath(context, "autoguide");
            HttpMultiPartParser multiPart = new HttpMultiPartParser();
            multiPart.setUsePathParam(false);
            multiPart.setUseUniqueName(true);
            multiPart.setUseDateForFolder(true);
            multiPart.setExtensionId(this.getUserId(context));
            HashMap parts = multiPart.parseData(context.getRequest(), filePath);
            String id = (String)parts.get("id");
            db = this.getConnection(context);
            FileItemList previousFiles = new FileItemList();
            previousFiles.setLinkModuleId(14);
            previousFiles.setLinkItemId(Integer.parseInt(id));
            previousFiles.buildList(db);
            previousFiles.delete(db, filePath);
            FileInfo newFileInfo = (FileInfo)parts.get("id" + id);
            FileItem thisItem = new FileItem();
            thisItem.setLinkModuleId(14);
            thisItem.setLinkItemId(Integer.parseInt(id));
            thisItem.setEnteredBy(this.getUserId(context));
            thisItem.setModifiedBy(this.getUserId(context));
            thisItem.setSubject("vehicle photo");
            thisItem.setClientFilename(newFileInfo.getClientFileName());
            thisItem.setFilename(newFileInfo.getRealFilename());
            thisItem.setVersion(1.0);
            thisItem.setSize(newFileInfo.getSize());
            isValid = this.validateObject(context, db, thisItem);
            if (isValid) {
                recordInserted = thisItem.insert(db);
            }
            if (recordInserted) {
                File thumbnail = new File(newFileInfo.getLocalFile().getPath() + "TH");
                ImageUtils.saveThumbnail(newFileInfo.getLocalFile(), thumbnail, 133.0, 133.0);
                thisItem.setSubject("thumbnail");
                thisItem.setFilename(newFileInfo.getRealFilename() + "TH");
                thisItem.setVersion(1.1);
                thisItem.setSize((int)thumbnail.length());
                recordInserted = thisItem.insertVersion(db);
            }
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            return "PopupCloseOK";
        }
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandShowImage(ActionContext context) {
        Exception errorMessage = null;
        String linkId = context.getRequest().getParameter("id");
        String itemId = context.getRequest().getParameter("fid");
        String version = context.getRequest().getParameter("ver");
        FileItem thisItem = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisItem = new FileItem(db, Integer.parseInt(itemId), Integer.parseInt(linkId), 14);
            if (version != null) {
                thisItem.buildVersionList(db);
            }
        }
        catch (Exception e) {
            errorMessage = e;
            System.out.println(e.toString());
        }
        finally {
            this.freeConnection(context, db);
        }
        try {
            if (version == null) {
                FileItem itemToDownload = thisItem;
                itemToDownload.setEnteredBy(this.getUserId(context));
                String filePath = this.getPath(context, "autoguide") + AutoGuide.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                FileDownload fileDownload = new FileDownload();
                fileDownload.setFullPath(filePath);
                fileDownload.setDisplayName(itemToDownload.getClientFilename());
                if (fileDownload.fileExists()) {
                    String imageType = "jpg";
                    fileDownload.sendFile(context, "image/" + imageType);
                } else {
                    System.err.println("AutoGuide-> Trying to send a file that does not exist");
                }
            } else {
                FileItemVersion itemToDownload = thisItem.getVersion(Double.parseDouble(version));
                itemToDownload.setEnteredBy(this.getUserId(context));
                String filePath = this.getPath(context, "autoguide") + AutoGuide.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                FileDownload fileDownload = new FileDownload();
                fileDownload.setFullPath(filePath);
                fileDownload.setDisplayName(itemToDownload.getClientFilename());
                if (fileDownload.fileExists()) {
                    String imageType = "jpg";
                    fileDownload.sendFile(context, "image/" + imageType);
                } else {
                    System.err.println("AutoGuide-> Trying to send a file that does not exist");
                }
            }
        }
        catch (SocketException se) {
            if (System.getProperty("DEBUG") != null) {
                System.out.println(se.toString());
            }
        }
        catch (Exception e) {
            errorMessage = e;
            System.out.println(e.toString());
        }
        return "-none-";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownloadImage(ActionContext context) {
        Exception errorMessage = null;
        String linkId = context.getRequest().getParameter("id");
        String itemId = context.getRequest().getParameter("fid");
        String version = context.getRequest().getParameter("ver");
        FileItem thisItem = null;
        Inventory inventoryItem = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            inventoryItem = new Inventory(db, Integer.parseInt(linkId));
            thisItem = inventoryItem.getPicture();
        }
        catch (Exception e) {
            errorMessage = e;
            System.out.println(e.toString());
        }
        finally {
            this.freeConnection(context, db);
        }
        try {
            FileItemVersion itemToDownload = null;
            itemToDownload = version == null ? thisItem.getVersion(1.0) : thisItem.getVersion(Double.parseDouble(version));
            itemToDownload.setEnteredBy(this.getUserId(context));
            String filePath = this.getPath(context, "autoguide") + AutoGuide.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
            FileDownload fileDownload = new FileDownload();
            fileDownload.setFullPath(filePath);
            fileDownload.setDisplayName(StringUtils.toString(inventoryItem.getOrganization().getAccountNumber()) + "_" + StringUtils.toString(inventoryItem.getStockNo()) + "_" + StringUtils.toString(inventoryItem.getVehicle().getMake().getName()) + ".jpg");
            if (fileDownload.fileExists()) {
                fileDownload.sendFile(context);
                db = this.getConnection(context);
                itemToDownload.updateCounter(db);
            } else {
                System.err.println("AutoGuide-> Trying to send a file that does not exist");
            }
        }
        catch (SocketException se) {
            if (System.getProperty("DEBUG") != null) {
                se.printStackTrace(System.out);
            }
        }
        catch (Exception e) {
            errorMessage = e;
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "-none-";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownloadText(ActionContext context) {
        Exception errorMessage = null;
        String linkId = context.getRequest().getParameter("id");
        Inventory inventoryItem = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            inventoryItem = new Inventory(db, Integer.parseInt(linkId));
        }
        catch (Exception e) {
            errorMessage = e;
            System.out.println(e.toString());
        }
        finally {
            this.freeConnection(context, db);
        }
        try {
            FileDownload fileDownload = new FileDownload();
            fileDownload.setDisplayName(StringUtils.toString(inventoryItem.getOrganization().getAccountNumber()) + "_" + StringUtils.toString(inventoryItem.getStockNo()) + "_" + StringUtils.toString(inventoryItem.getVehicle().getMake().getName()) + ".txt");
            fileDownload.sendTextAsFile(context, inventoryItem.toString());
        }
        catch (SocketException se) {
            if (System.getProperty("DEBUG") != null) {
                se.printStackTrace(System.out);
            }
        }
        catch (Exception e) {
            errorMessage = e;
            e.printStackTrace(System.out);
        }
        if (errorMessage == null) {
            return "-none-";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    public void populateListFilters(ActionContext context, PagedListInfo info) {
        if (!info.hasListFilters()) {
            info.addFilter(1, "0");
            info.addFilter(2, "1");
        }
        HtmlSelect listFilterSelect = new HtmlSelect();
        listFilterSelect.addItem(0, "Current Inventory");
        listFilterSelect.addItem(1, "Sold Inventory");
        listFilterSelect.addItem(-1, "All Inventory");
        context.getRequest().setAttribute("listFilterSelect", (Object)listFilterSelect);
        HtmlSelect statusFilterSelect = new HtmlSelect();
        statusFilterSelect.addItem(1, "Incomplete Ads");
        statusFilterSelect.addItem(0, "Completed Ads");
        statusFilterSelect.addItem(-1, "All Ads");
        context.getRequest().setAttribute("statusFilterSelect", (Object)statusFilterSelect);
    }

    private void populateOrganization(ActionContext context, Connection db, int orgId) throws SQLException {
        Organization thisOrganization = new Organization(db, orgId);
        context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
    }

    private void populateYearSelect(ActionContext context, Connection db) throws SQLException {
        ArrayList yearList = VehicleList.buildYearList(db);
        HtmlSelect yearSelect = new HtmlSelect(yearList);
        yearSelect.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"), 0);
        context.getRequest().setAttribute("YearSelect", (Object)yearSelect);
    }

    private void populateMakeSelect(ActionContext context, Connection db, Vehicle thisVehicle, String defaultText) throws SQLException {
        HtmlSelect makeSelect = new HtmlSelect();
        if (defaultText == null) {
            makeSelect.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
        } else {
            makeSelect.addItem(-1, defaultText);
        }
        MakeList makeList = new MakeList();
        if (thisVehicle != null) {
            makeList.setYear(thisVehicle.getYear());
        }
        Statement pst = null;
        ResultSet rs = makeList.queryList(db, (PreparedStatement)pst);
        while (rs.next()) {
            Make thisMake = makeList.getObject(rs);
            makeSelect.addItem(thisMake.getId(), thisMake.getName());
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
        context.getRequest().setAttribute("MakeSelect", (Object)makeSelect);
    }

    private void populateModelSelect(ActionContext context, Connection db, Vehicle thisVehicle) throws SQLException {
        HtmlSelect modelSelect = new HtmlSelect();
        modelSelect.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
        ModelList modelList = new ModelList();
        if (thisVehicle != null) {
            Statement pst = null;
            modelList.setYear(thisVehicle.getYear());
            modelList.setMakeId(thisVehicle.getMakeId());
            ResultSet rs = modelList.queryList(db, (PreparedStatement)pst);
            while (rs.next()) {
                Model thisModel = modelList.getObject(rs);
                modelSelect.addItem(thisModel.getId(), thisModel.getName());
            }
            rs.close();
            if (pst != null) {
                pst.close();
            }
        }
        context.getRequest().setAttribute("ModelSelect", (Object)modelSelect);
    }

    private void populateOptionList(ActionContext context, Connection db) throws SQLException {
        OptionList options = new OptionList(db);
        context.getRequest().setAttribute("OptionList", (Object)options);
    }

    private void populateAdRunTypeSelect(ActionContext context, Connection db) throws SQLException {
        LookupList adRunType = new LookupList(db, "autoguide_ad_run_types");
        context.getRequest().setAttribute("adRunTypeList", (Object)adRunType);
    }
}

