/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.media.autoguide.actions;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.aspcfs.modules.service.base.CustomActionHandler;
import org.aspcfs.modules.service.base.PacketContext;
import org.aspcfs.modules.service.base.SyncTable;
import org.aspcfs.utils.StringUtils;

public class DeleteInventoryCache
implements CustomActionHandler {
    public boolean process(PacketContext packetContext, Connection db, HashMap values) throws SQLException {
        System.out.println("DeleteInventoryCache-> BEGIN");
        int systemId = packetContext.getAuthenticationItem().getSystemId();
        int clientId = packetContext.getAuthenticationItem().getClientId();
        int clientAccountId = StringUtils.parseInt((String)values.get("accountGuid"), -1);
        if (systemId == -1 || clientId == -1 || clientAccountId == -1) {
            System.out.println("DeleteInventoryCache-> Something is not configured");
            return false;
        }
        SyncTable accountTable = (SyncTable)((Object)packetContext.getObjectMap().get("accountList"));
        SyncTable accountInventoryTable = (SyncTable)((Object)packetContext.getObjectMap().get("accountInventoryList"));
        SyncTable optionTable = (SyncTable)((Object)packetContext.getObjectMap().get("optionList"));
        SyncTable adRunTable = (SyncTable)((Object)packetContext.getObjectMap().get("adRunList"));
        PreparedStatement pst = null;
        ResultSet rs = null;
        int accountId = -1;
        pst = db.prepareStatement("SELECT record_id FROM sync_map WHERE client_id = ? AND table_id = ? AND cuid = ? ");
        pst.setInt(1, clientId);
        pst.setInt(2, accountTable.getId());
        pst.setInt(3, clientAccountId);
        rs = pst.executeQuery();
        if (rs.next()) {
            accountId = rs.getInt("record_id");
        }
        rs.close();
        pst.close();
        if (accountId == -1) {
            return false;
        }
        System.out.println("DeleteInventoryCache-> Found server accountId: " + accountId);
        pst = db.prepareStatement("DELETE from sync_map WHERE client_id = ? AND table_id = ? AND record_id IN ( SELECT ad_run_id FROM autoguide_ad_run WHERE inventory_id IN (SELECT inventory_id FROM autoguide_inventory WHERE account_id = ? ) ) ");
        pst.setInt(1, clientId);
        pst.setInt(2, adRunTable.getId());
        pst.setInt(3, accountId);
        pst.execute();
        pst.close();
        System.out.println("DeleteInventoryCache-> Ad run cache deleted");
        pst = db.prepareStatement("DELETE from sync_map WHERE client_id = ? AND table_id = ? AND record_id IN (SELECT inventory_id FROM autoguide_inventory WHERE account_id = ? )");
        pst.setInt(1, clientId);
        pst.setInt(2, accountInventoryTable.getId());
        pst.setInt(3, accountId);
        pst.execute();
        pst.close();
        System.out.println("DeleteInventoryCache-> Inventory cache deleted");
        packetContext.getClientManager().removeClient(clientId);
        return true;
    }
}

