/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.media.autoguide.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemList;
import java.io.File;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.login.base.AuthenticationItem;
import org.aspcfs.modules.service.base.SyncClientMap;
import org.aspcfs.modules.service.base.SyncTable;
import org.aspcfs.utils.ImageUtils;

public final class ProcessFTP
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDefault(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        try {
            AuthenticationItem auth = new AuthenticationItem();
            String filePath = this.getPath(context, auth.getConnectionElement(context), "autoguide");
            String ftpPath = filePath + "ftp" + fs;
            File stub = new File(ftpPath);
            File[] files = stub.listFiles();
            File datedPath = null;
            if (files.length > 0) {
                SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy");
                String datePathToUse1 = formatter1.format(new Date());
                SimpleDateFormat formatter2 = new SimpleDateFormat("MMdd");
                String datePathToUse2 = formatter2.format(new Date());
                datedPath = new File(filePath + datePathToUse1 + fs + datePathToUse2 + fs);
                datedPath.mkdirs();
                db = auth.getConnection(context, false);
            }
            for (int i = 0; i < files.length; ++i) {
                int recordId;
                File fileToMove = files[i];
                String filename = fileToMove.getName();
                if (!filename.endsWith(".jpg") && !filename.endsWith(".JPG")) continue;
                System.out.println(filename);
                String clientId = filename.substring(0, filename.indexOf("-"));
                String inventoryId = filename.substring(filename.indexOf("-") + 1, filename.indexOf("."));
                SyncClientMap thisClientMap = new SyncClientMap();
                thisClientMap.setClientId(Integer.parseInt(clientId));
                int tableId = SyncTable.lookupTableId(db, 2, "org.aspcfs.modules.media.autoguide.base.InventoryList");
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("ProcessFTP-> TableID = " + tableId);
                }
                if ((recordId = thisClientMap.lookupServerId(db, tableId, inventoryId)) > -1) {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
                    String datedFilename = formatter.format(new Date()) + i;
                    System.out.println(datedPath.getPath());
                    File thisFile = new File(datedPath.getPath() + fs + datedFilename);
                    fileToMove.renameTo(thisFile);
                    FileItemList previousFiles = new FileItemList();
                    previousFiles.setLinkModuleId(14);
                    previousFiles.setLinkItemId(recordId);
                    previousFiles.buildList(db);
                    previousFiles.delete(db, filePath);
                    FileItem thisItem = new FileItem();
                    thisItem.setLinkModuleId(14);
                    thisItem.setLinkItemId(recordId);
                    thisItem.setEnteredBy(-1);
                    thisItem.setModifiedBy(-1);
                    thisItem.setSubject("vehicle photo");
                    thisItem.setClientFilename(filename);
                    thisItem.setFilename(datedFilename);
                    thisItem.setVersion(1.0);
                    thisItem.setSize((int)thisFile.length());
                    boolean recordInserted = thisItem.insert(db);
                    if (!recordInserted) {
                        this.processErrors(context, thisItem.getErrors());
                        continue;
                    }
                    File thumbnail = new File(thisFile.getPath() + "TH");
                    ImageUtils.saveThumbnail(thisFile, thumbnail, 133.0, 133.0);
                    thisItem.setSubject("thumbnail");
                    thisItem.setFilename(datedFilename + "TH");
                    thisItem.setVersion(1.1);
                    thisItem.setSize((int)thumbnail.length());
                    recordInserted = thisItem.insertVersion(db);
                    continue;
                }
                if (System.getProperty("DEBUG") == null) continue;
                System.out.println("ProcessFTP-> Matching client record not found");
            }
        }
        catch (Exception e) {
            errorMessage = e;
            e.printStackTrace(System.out);
        }
        finally {
            if (db != null) {
                this.freeConnection(context, db);
            }
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println("ProcessFTP-> Finished");
        }
        return "-none-";
    }
}

