/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.media.autoguide.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import org.aspcfs.utils.DatabaseUtils;

public class AdRun {
    private int id = -1;
    private int inventoryId = -1;
    private java.sql.Date runDate = null;
    private int adTypeId = -1;
    private String adTypeName = null;
    private boolean includePhoto = false;
    private java.sql.Date completeDate = null;
    private int completedBy = -1;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private boolean remove = false;

    public AdRun() {
    }

    public AdRun(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public AdRun(Connection db, int adRunId) throws SQLException {
        String sql = "SELECT ad.ad_run_id, ad.inventory_id, ad.run_date, ad.ad_type, ad.include_photo, complete_date, completedby, ad.entered, ad.enteredby, ad.modified, ad.modifiedby, adtype.description FROM autoguide_ad_run ad, autoguide_ad_run_types adtype WHERE ad.ad_run_id = ? AND ad.ad_type = adtype.code ";
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, adRunId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        } else {
            System.out.println("AdRun-> * RECORD NOT FOUND: " + adRunId);
        }
        rs.close();
        pst.close();
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setInventoryId(int tmp) {
        this.inventoryId = tmp;
    }

    public void setAccountInventoryId(int tmp) {
        this.setInventoryId(tmp);
    }

    public void setInventoryId(String tmp) {
        this.inventoryId = Integer.parseInt(tmp);
    }

    public void setAccountInventoryId(String tmp) {
        this.setInventoryId(tmp);
    }

    public void setRunDate(java.sql.Date tmp) {
        this.runDate = tmp;
    }

    public void setRunDate(String tmp) {
        boolean success = false;
        try {
            this.runDate = java.sql.Date.valueOf(tmp);
            success = true;
        }
        catch (Exception e) {
            this.runDate = null;
        }
        if (!success) {
            try {
                Date tmpDate = DateFormat.getDateInstance(3).parse(tmp);
                this.runDate = new java.sql.Date(new Date().getTime());
                this.runDate.setTime(tmpDate.getTime());
            }
            catch (Exception e) {
                this.runDate = null;
            }
        }
    }

    public void setAdTypeId(int tmp) {
        this.adTypeId = tmp;
    }

    public void setAdType(int tmp) {
        this.adTypeId = tmp;
    }

    public void setAdType(String tmp) {
        this.adTypeId = Integer.parseInt(tmp);
    }

    public void setAdTypeId(String tmp) {
        this.adTypeId = Integer.parseInt(tmp);
    }

    public void setAdTypeName(String tmp) {
        this.adTypeName = tmp;
    }

    public void setIncludePhoto(boolean tmp) {
        this.includePhoto = tmp;
    }

    public void setIncludePhoto(String tmp) {
        this.includePhoto = "1".equals(tmp) || "on".equalsIgnoreCase(tmp) || "true".equalsIgnoreCase(tmp);
    }

    public void setCompleteDate(java.sql.Date tmp) {
        this.completeDate = tmp;
    }

    public void setCompleteDate(String tmp) {
        try {
            Date tmpDate = DateFormat.getDateInstance(3).parse(tmp);
            this.completeDate = new java.sql.Date(new Date().getTime());
            this.completeDate.setTime(tmpDate.getTime());
        }
        catch (Exception e) {
            this.completeDate = null;
        }
    }

    public void setCompletedBy(int tmp) {
        this.completedBy = tmp;
    }

    public void setCompletedBy(String tmp) {
        this.completedBy = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setRemove(boolean tmp) {
        this.remove = tmp;
    }

    public void setRemove(String tmp) {
        this.remove = "1".equals(tmp) || "on".equalsIgnoreCase(tmp) || "true".equalsIgnoreCase(tmp);
    }

    public int getCompletedBy() {
        return this.completedBy;
    }

    public int getId() {
        return this.id;
    }

    public int getInventoryId() {
        return this.inventoryId;
    }

    public int getAccountInventoryId() {
        return this.inventoryId;
    }

    public java.sql.Date getRunDate() {
        return this.runDate;
    }

    public int getAdType() {
        return this.adTypeId;
    }

    public int getAdTypeId() {
        return this.adTypeId;
    }

    public String getAdTypeName() {
        return this.adTypeName;
    }

    public boolean getIncludePhoto() {
        return this.includePhoto;
    }

    public java.sql.Date getCompleteDate() {
        return this.completeDate;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public boolean isComplete() {
        return this.completeDate != null;
    }

    public void insert(Connection db) throws SQLException {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("AdRun-> Inserting new record: InventoryId(" + this.inventoryId + ")");
        }
        this.id = DatabaseUtils.getNextSeq(db, "autoguide_ad_run_ad_run_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO autoguide_ad_run (" + (this.id > -1 ? "ad_run_id, " : "") + "inventory_id, " + "run_date, ad_type, include_photo, complete_date, completedby, " + "enteredby, modifiedby) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?, ?)");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.inventoryId);
        pst.setDate(++i, this.runDate);
        pst.setInt(++i, this.adTypeId);
        pst.setBoolean(++i, this.includePhoto);
        if (this.completeDate == null) {
            pst.setNull(++i, 91);
            DatabaseUtils.setInt(pst, ++i, -1);
        } else {
            pst.setDate(++i, this.completeDate);
            pst.setInt(++i, this.completedBy);
        }
        pst.setInt(++i, this.enteredBy);
        pst.setInt(++i, this.enteredBy);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "autoguide_ad_run_ad_run_id_seq", this.id);
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.remove) {
            this.delete(db);
        } else if (this.id == -1) {
            this.insert(db);
        } else {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("AdRun-> Updating record: id(" + this.id + ")");
            }
            String sql = "UPDATE autoguide_ad_run SET run_date = ?, ad_type = ?, include_photo = ?, complete_date = ?, completedby = ?, modified = CURRENT_TIMESTAMP, modifiedby = ? WHERE ad_run_id = ? ";
            PreparedStatement pst = db.prepareStatement(sql);
            int i = 0;
            pst.setDate(++i, this.runDate);
            pst.setInt(++i, this.adTypeId);
            pst.setBoolean(++i, this.includePhoto);
            if (this.completeDate == null) {
                pst.setNull(++i, 91);
                DatabaseUtils.setInt(pst, ++i, -1);
            } else {
                pst.setDate(++i, this.completeDate);
                pst.setInt(++i, this.completedBy);
            }
            pst.setInt(++i, this.modifiedBy);
            pst.setInt(++i, this.id);
            resultCount = pst.executeUpdate();
            pst.close();
        }
        return resultCount;
    }

    public void markComplete(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE autoguide_ad_run SET complete_date = CURRENT_TIMESTAMP, completedby = ? WHERE ad_run_id = ? ");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        int i = 0;
        pst.setInt(++i, this.completedBy);
        pst.setInt(++i, this.id);
        pst.execute();
        pst.close();
    }

    public void markIncomplete(Connection db, String intHierarchyList) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE autoguide_ad_run SET complete_date = ?, completedby = ? WHERE ad_run_id = ? AND completedby IN (" + intHierarchyList + ") ");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        int i = 0;
        pst.setNull(++i, 91);
        DatabaseUtils.setInt(pst, ++i, -1);
        pst.setInt(++i, this.id);
        pst.execute();
        pst.close();
    }

    public void delete(Connection db) throws SQLException {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("AdRun-> Deleting record: id(" + this.id + ")");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM autoguide_ad_run WHERE ad_run_id = ? ");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(1, this.id);
        pst.execute();
        pst.close();
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("ad_run_id");
        this.inventoryId = rs.getInt("inventory_id");
        this.runDate = rs.getDate("run_date");
        this.adTypeId = rs.getInt("ad_type");
        this.includePhoto = rs.getBoolean("include_photo");
        this.completeDate = rs.getDate("complete_date");
        this.completedBy = rs.getInt("completedby");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.adTypeName = rs.getString("description");
    }
}

