/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.media.autoguide.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.base.SyncableList;
import org.aspcfs.modules.media.autoguide.base.AdRun;
import org.aspcfs.utils.web.PagedListInfo;

public class AdRunList
extends ArrayList
implements SyncableList {
    public static String tableName = "autoguide_ad_run";
    public static String uniqueField = "ad_run_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private int inventoryId = -1;
    private boolean incompleteOnly = false;
    private PagedListInfo pagedListInfo = null;

    public AdRunList() {
    }

    public AdRunList(Connection db) throws SQLException {
        this.buildList(db);
    }

    public AdRunList(HttpServletRequest request) {
        int linearId = 0;
        String thisId = null;
        while ((thisId = request.getParameter("adrun" + ++linearId + "id")) != null) {
            if (System.getProperty("DEBUG") != null) {
                System.out.print("AdRunList-> Adding run from request...");
            }
            String runDate = request.getParameter("adrun" + linearId + "runDate");
            String adType = request.getParameter("adrun" + linearId + "adType");
            String includePhoto = request.getParameter("adrun" + linearId + "includePhoto");
            String remove = request.getParameter("adrun" + linearId + "remove");
            if (runDate != null && !"".equalsIgnoreCase(runDate.trim())) {
                AdRun thisAdRun = new AdRun();
                thisAdRun.setRemove(remove);
                thisAdRun.setId(thisId);
                thisAdRun.setRunDate(runDate);
                thisAdRun.setAdType(adType);
                thisAdRun.setIncludePhoto(includePhoto);
                this.add(thisAdRun);
                if (System.getProperty("DEBUG") == null) continue;
                System.out.println("added");
                continue;
            }
            if (System.getProperty("DEBUG") == null) continue;
            System.out.println("not added");
        }
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setSyncType(String tmp) {
        this.syncType = Integer.parseInt(tmp);
    }

    public void setInventoryId(int tmp) {
        this.inventoryId = tmp;
    }

    public void setAccountInventoryId(int tmp) {
        this.inventoryId = tmp;
    }

    public void setAccountInventoryId(String tmp) {
        this.inventoryId = Integer.parseInt(tmp);
    }

    public void setInventoryId(String tmp) {
        this.inventoryId = Integer.parseInt(tmp);
    }

    public void setIncompleteOnly(boolean tmp) {
        this.incompleteOnly = tmp;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public int getInventoryId() {
        return this.inventoryId;
    }

    public int getAccountInventoryId() {
        return this.inventoryId;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public AdRun getObject(ResultSet rs) throws SQLException {
        AdRun thisAdRun = new AdRun(rs);
        return thisAdRun;
    }

    public AdRun getNextAdRun() {
        if (this.size() > 0) {
            return (AdRun)this.get(0);
        }
        return null;
    }

    public AdRun getAdRun(int adId) {
        for (AdRun thisAdRun : this) {
            if (thisAdRun.getId() != adId) continue;
            return thisAdRun;
        }
        return null;
    }

    public void select(Connection db) throws SQLException {
        this.buildList(db);
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            AdRun thisAdRun = this.getObject(rs);
            this.add(thisAdRun);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM autoguide_ad_run ad, autoguide_ad_run_types adtype WHERE ad.ad_run_id > -1 AND ad.ad_type = adtype.code ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            if (this.pagedListInfo != null) {
                this.pagedListInfo.doManualOffset(db, pst);
            }
            if ((rs = pst.executeQuery()).next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("run_date", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY run_date ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("ad.ad_run_id, ad.inventory_id, ad.run_date, ad.ad_type, ad.include_photo, complete_date, completedby, ad.entered, ad.enteredby, ad.modified, ad.modifiedby, adtype.description FROM autoguide_ad_run ad, autoguide_ad_run_types adtype WHERE ad.ad_run_id > -1 AND ad.ad_type = adtype.code ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        return rs;
    }

    public void update(Connection db) throws SQLException {
        for (AdRun thisAdRun : this) {
            thisAdRun.setInventoryId(this.inventoryId);
            thisAdRun.update(db);
        }
    }

    public void insert(Connection db) throws SQLException {
        for (AdRun thisAdRun : this) {
            thisAdRun.setInventoryId(this.inventoryId);
            thisAdRun.insert(db);
        }
    }

    public void delete(Connection db) throws SQLException {
        for (AdRun thisAdRun : this) {
            thisAdRun.delete(db);
        }
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND ad.entered > ? ");
            }
            sqlFilter.append("AND ad.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND ad.modified > ? ");
            sqlFilter.append("AND ad.entered < ? ");
            sqlFilter.append("AND ad.modified < ? ");
        }
        if (this.inventoryId > -1) {
            sqlFilter.append("AND ad.inventory_id = ? ");
        }
        if (this.incompleteOnly) {
            sqlFilter.append("AND ad.completedby = -1 ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.inventoryId > -1) {
            pst.setInt(++i, this.inventoryId);
        }
        return i;
    }
}

