/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.media.autoguide.base;

import com.zeroio.iteam.base.FileItem;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.media.autoguide.base.AdRun;
import org.aspcfs.modules.media.autoguide.base.AdRunList;
import org.aspcfs.modules.media.autoguide.base.Option;
import org.aspcfs.modules.media.autoguide.base.OptionList;
import org.aspcfs.modules.media.autoguide.base.Vehicle;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.StringUtils;

public class Inventory {
    private int id = -1;
    private int vehicleId = -1;
    private int accountId = -1;
    private String vin = null;
    private int mileage = -1;
    private boolean isNew = false;
    private String condition = null;
    private String comments = null;
    private String stockNo = null;
    private String exteriorColor = null;
    private String interiorColor = null;
    private double invoicePrice = -1.0;
    private double sellingPrice = -1.0;
    private String sellingPriceText = null;
    private boolean sold = false;
    private String style = null;
    private String status = null;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private Vehicle vehicle = new Vehicle();
    private Organization organization = null;
    private OptionList options = null;
    private AdRunList adRuns = null;
    private int pictureId = -1;
    private FileItem picture = null;
    private boolean showIncompleteAdRunsOnly = false;

    public Inventory() {
    }

    public Inventory(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public Inventory(Connection db, int inventoryId) throws SQLException {
        String sql = "SELECT i.inventory_id, i.vehicle_id AS inventory_vehicle_id, i.account_id, vin, mileage, is_new, condition, comments, stock_no, ext_color, int_color, invoice_price, selling_price, selling_price_text, sold, style, i.status, i.entered, i.enteredby, i.modified, i.modifiedby, v.vehicle_id, v.year, v.make_id AS vehicle_make_id, v.model_id AS vehicle_model_id, v.entered AS vehicle_entered, v.enteredby AS vehicle_enteredby, v.modified AS vehicle_modified, v.modifiedby AS vehicle_modifiedby, model.model_id, model.make_id AS model_make_id, model.model_name, model.entered, model.enteredby, model.modified, model.modifiedby, make.make_id, make.make_name, make.entered AS make_entered, make.enteredby AS make_enteredby, make.modified AS make_modified, make.modifiedby AS make_modifiedby, files.item_id AS picture_id FROM autoguide_inventory i  LEFT JOIN autoguide_vehicle v ON i.vehicle_id = v.vehicle_id  LEFT JOIN autoguide_make make ON v.make_id = make.make_id  LEFT JOIN autoguide_model model ON v.model_id = model.model_id  LEFT JOIN project_files files ON    (i.inventory_id = files.link_item_id AND files.link_module_id = 14) WHERE i.inventory_id = ? ";
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, inventoryId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        } else {
            System.out.println("Inventory-> * RECORD NOT FOUND: " + inventoryId);
        }
        rs.close();
        pst.close();
        try {
            this.buildOrganizationInfo(db);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.buildOptions(db);
        this.buildAdRuns(db);
        this.buildPicture(db);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setVehicleId(int tmp) {
        this.vehicleId = tmp;
    }

    public void setVehicleId(String tmp) {
        this.vehicleId = Integer.parseInt(tmp);
    }

    public void setAccountId(int tmp) {
        this.accountId = tmp;
    }

    public void setAccountId(String tmp) {
        this.accountId = Integer.parseInt(tmp);
    }

    public void setVin(String tmp) {
        this.vin = tmp;
    }

    public void setMileage(int tmp) {
        this.mileage = tmp;
    }

    public void setMileage(String tmp) {
        this.mileage = StringUtils.getIntegerNumber(tmp);
    }

    public void setIsNew(boolean tmp) {
        this.isNew = tmp;
    }

    public void setIsNew(String tmp) {
        this.isNew = DatabaseUtils.parseBoolean(tmp);
    }

    public void setCondition(String tmp) {
        this.condition = tmp;
    }

    public void setComments(String tmp) {
        this.comments = tmp;
    }

    public void setStockNo(String tmp) {
        this.stockNo = tmp;
    }

    public void setExteriorColor(String tmp) {
        this.exteriorColor = tmp;
    }

    public void setInteriorColor(String tmp) {
        this.interiorColor = tmp;
    }

    public void setInvoicePrice(double tmp) {
        this.invoicePrice = tmp;
    }

    public void setInvoicePrice(String tmp) {
        this.invoicePrice = StringUtils.getDoubleNumber(tmp);
    }

    public void setSellingPrice(double tmp) {
        this.sellingPrice = tmp;
    }

    public void setSellingPrice(String tmp) {
        this.sellingPrice = StringUtils.getDoubleNumber(tmp);
    }

    public void setSellingPriceText(String tmp) {
        this.sellingPriceText = tmp;
    }

    public void setSold(boolean tmp) {
        this.sold = tmp;
    }

    public void setSold(String tmp) {
        this.sold = DatabaseUtils.parseBoolean(tmp);
    }

    public void setStyle(String tmp) {
        this.style = tmp;
    }

    public void setStatus(String tmp) {
        this.status = tmp;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = Timestamp.valueOf(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = Timestamp.valueOf(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setVehicle(Vehicle tmp) {
        this.vehicle = tmp;
    }

    public void setOrganization(Organization tmp) {
        this.organization = tmp;
    }

    public void setOptions(OptionList tmp) {
        this.options = tmp;
    }

    public void setRequestItems(HttpServletRequest request) {
        this.options = new OptionList(request);
        this.adRuns = new AdRunList(request);
        String type = request.getParameter("sellingPriceType");
        if (type != null) {
            if ("2".equals(type)) {
                this.sellingPrice = -1.0;
            } else {
                this.sellingPriceText = null;
            }
        }
    }

    public void setAdRuns(AdRunList tmp) {
        this.adRuns = tmp;
    }

    public void setPictureId(int tmp) {
        this.pictureId = tmp;
    }

    public void setPicture(FileItem tmp) {
        this.picture = tmp;
    }

    public void setShowIncompleteAdRunsOnly(boolean tmp) {
        this.showIncompleteAdRunsOnly = tmp;
    }

    public int getId() {
        return this.id;
    }

    public int getVehicleId() {
        return this.vehicleId;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public String getVin() {
        return this.vin;
    }

    public int getMileage() {
        return this.mileage;
    }

    public String getMileageString() {
        if (this.mileage > -1) {
            return String.valueOf(this.mileage);
        }
        return "";
    }

    public boolean getIsNew() {
        return this.isNew;
    }

    public String getCondition() {
        return this.condition;
    }

    public String getComments() {
        return this.comments;
    }

    public String getStockNo() {
        return this.stockNo;
    }

    public String getExteriorColor() {
        return this.exteriorColor;
    }

    public String getInteriorColor() {
        return this.interiorColor;
    }

    public double getInvoicePrice() {
        return this.invoicePrice;
    }

    public String getInvoicePriceString() {
        NumberFormat numberFormatter = NumberFormat.getNumberInstance(Locale.US);
        return "$" + numberFormatter.format(this.invoicePrice);
    }

    public double getSellingPrice() {
        return this.sellingPrice;
    }

    public String getSellingPriceString() {
        if (this.sellingPrice > 0.0) {
            NumberFormat numberFormatter = NumberFormat.getNumberInstance(Locale.US);
            return "$" + numberFormatter.format(this.sellingPrice);
        }
        return "";
    }

    public String getSellingPriceText() {
        return this.sellingPriceText;
    }

    public boolean getSold() {
        return this.sold;
    }

    public String getStyle() {
        return this.style;
    }

    public String getStatus() {
        return this.status;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Vehicle getVehicle() {
        return this.vehicle;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public Organization getAccount() {
        return this.organization;
    }

    public OptionList getOptions() {
        return this.options;
    }

    public AdRunList getAdRuns() {
        return this.adRuns;
    }

    public int getPictureId() {
        return this.pictureId;
    }

    public FileItem getPicture() {
        return this.picture;
    }

    public boolean getHasPicture() {
        return this.hasPicture();
    }

    public boolean hasOptions() {
        return this.options != null && this.options.size() > 0;
    }

    public boolean hasOption(int optionId) {
        return this.options != null && this.options.hasOption(optionId);
    }

    public boolean hasAdRuns() {
        return this.adRuns != null && this.adRuns.size() > 0;
    }

    public boolean hasPictureId() {
        return this.pictureId > -1;
    }

    public boolean hasPicture() {
        return this.picture != null || this.hasPictureId();
    }

    public boolean insert(Connection db) throws SQLException {
        int i = 0;
        this.id = DatabaseUtils.getNextSeq(db, "autoguide_inve_inventory_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO autoguide_inventory (" + (this.id > -1 ? "inventory_id, " : "") + "vehicle_id, account_id, vin, mileage, is_new, condition, comments, " + "stock_no, ext_color, int_color, invoice_price, selling_price, selling_price_text, sold, " + "style, status, enteredby, modifiedby) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ");
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.vehicleId);
        pst.setInt(++i, this.accountId);
        pst.setString(++i, this.vin);
        pst.setInt(++i, this.mileage);
        pst.setBoolean(++i, this.isNew);
        pst.setString(++i, this.condition);
        pst.setString(++i, this.comments);
        pst.setString(++i, this.stockNo);
        pst.setString(++i, this.exteriorColor);
        pst.setString(++i, this.interiorColor);
        pst.setDouble(++i, this.invoicePrice);
        pst.setDouble(++i, this.sellingPrice);
        pst.setString(++i, this.sellingPriceText);
        pst.setBoolean(++i, this.sold);
        pst.setString(++i, this.style);
        pst.setString(++i, this.status);
        pst.setInt(++i, this.enteredBy);
        pst.setInt(++i, this.enteredBy);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "autoguide_inve_inventory_id_seq", this.id);
        if (this.options != null) {
            this.options.setInventoryId(this.id);
            this.options.insert(db);
        }
        if (this.adRuns != null) {
            this.adRuns.setInventoryId(this.id);
            this.adRuns.insert(db);
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            throw new SQLException("ID was not specified");
        }
        try {
            db.setAutoCommit(false);
            PreparedStatement pst = null;
            String sql = "UPDATE autoguide_inventory SET vehicle_id = ?, vin = ?, mileage = ?, is_new = ?, condition = ?, comments = ?, stock_no = ?, ext_color = ?, int_color = ?, invoice_price = ?, selling_price = ?, selling_price_text = ?, sold = ?, style = ?, status = ?, modifiedby = ?, modified = CURRENT_TIMESTAMP WHERE inventory_id = ? AND modified " + (this.getModified() == null ? "IS NULL " : "= ? ");
            int i = 0;
            pst = db.prepareStatement(sql);
            pst.setInt(++i, this.getVehicleId());
            pst.setString(++i, this.getVin());
            pst.setInt(++i, this.getMileage());
            pst.setBoolean(++i, this.getIsNew());
            pst.setString(++i, this.getCondition());
            pst.setString(++i, this.getComments());
            pst.setString(++i, this.getStockNo());
            pst.setString(++i, this.getExteriorColor());
            pst.setString(++i, this.getInteriorColor());
            pst.setDouble(++i, this.getInvoicePrice());
            pst.setDouble(++i, this.getSellingPrice());
            pst.setString(++i, this.getSellingPriceText());
            pst.setBoolean(++i, this.getSold());
            pst.setString(++i, this.getStyle());
            pst.setString(++i, this.getStatus());
            pst.setInt(++i, this.getModifiedBy());
            pst.setInt(++i, this.getId());
            if (this.getModified() != null) {
                pst.setTimestamp(++i, this.getModified());
            }
            resultCount = pst.executeUpdate();
            pst.close();
            if (resultCount == 1) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Inventory-> Vehicle updated, updating options...");
                }
                if (this.options == null) {
                    this.options = new OptionList();
                }
                this.options.setInventoryId(this.id);
                this.options.update(db);
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Inventory-> Options updated, updating ad runs...");
                }
                if (this.adRuns != null) {
                    this.adRuns.setInventoryId(this.id);
                    this.adRuns.update(db);
                }
            }
            db.commit();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return resultCount;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("ID was not specified");
        }
        PreparedStatement pst = null;
        if (this.options != null) {
            this.options.setInventoryId(this.id);
            this.options.delete(db);
        }
        if (this.adRuns != null) {
            this.adRuns.setInventoryId(this.id);
            this.adRuns.delete(db);
        }
        int recordCount = 0;
        pst = db.prepareStatement("DELETE FROM autoguide_inventory WHERE inventory_id = ? ");
        pst.setInt(1, this.id);
        recordCount = pst.executeUpdate();
        pst.close();
        return recordCount != 0;
    }

    public void buildOrganizationInfo(Connection db) throws SQLException {
        if (this.accountId == -1) {
            this.accountId = 0;
        }
        this.organization = new Organization(db, this.accountId);
    }

    public void buildOptions(Connection db) throws SQLException {
        this.options = new OptionList();
        this.options.setInventoryId(this.id);
        this.options.buildList(db);
    }

    public void buildAdRuns(Connection db) throws SQLException {
        this.adRuns = new AdRunList();
        this.adRuns.setIncompleteOnly(this.showIncompleteAdRunsOnly);
        this.adRuns.setInventoryId(this.id);
        this.adRuns.buildList(db);
    }

    public void generateVehicleId(Connection db) throws SQLException {
        this.vehicleId = this.getVehicle().generateId(db);
    }

    public void buildPictureId(Connection db) throws SQLException {
        try {
            FileItem fileItem = new FileItem(db, -1, this.id, 14);
            this.pictureId = fileItem.getId();
        }
        catch (SQLException e) {
            this.pictureId = -1;
        }
    }

    public void buildPicture(Connection db) throws SQLException {
        try {
            this.picture = new FileItem(db, -1, this.id, 14);
            this.picture.buildVersionList(db);
            this.pictureId = this.picture.getId();
        }
        catch (SQLException e) {
            this.pictureId = -1;
        }
        if (this.pictureId == -1) {
            this.picture = null;
        }
    }

    public String toString() {
        String lf = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("AUTO GUIDE VEHICLE OUTPUT: " + StringUtils.toDateTimeString(new Date()) + lf);
        sb.append(lf);
        sb.append(StringUtils.toString(this.organization.getName()));
        sb.append(" (" + StringUtils.toString(this.organization.getAccountNumber()) + ")" + lf);
        sb.append(this.organization.getPhoneNumber("Main") + lf);
        sb.append(lf);
        if (this.hasAdRuns()) {
            sb.append("Ad Runs:" + lf);
            int displayCount = 0;
            for (AdRun thisAdRun : this.adRuns) {
                sb.append(++displayCount + ". ");
                if (this.adRuns.size() > 9 && displayCount < 10) {
                    sb.append(" ");
                }
                sb.append(StringUtils.toDateString(thisAdRun.getRunDate()) + " ");
                sb.append(thisAdRun.getAdTypeName());
                sb.append(" - with");
                if (!thisAdRun.getIncludePhoto()) {
                    sb.append("out");
                }
                sb.append(" photo");
                sb.append(lf);
            }
        } else {
            sb.append("Ad Runs: none specified" + lf);
        }
        sb.append(lf);
        sb.append("Make: " + StringUtils.toString(this.vehicle.getMake().getName()) + lf);
        sb.append("Model: " + StringUtils.toString(this.vehicle.getModel().getName()) + lf);
        sb.append("Year: " + this.vehicle.getYear() + lf);
        sb.append("Style: " + StringUtils.toString(this.style) + lf);
        sb.append("Stock No: " + StringUtils.toString(this.stockNo) + lf);
        sb.append("Mileage: " + StringUtils.toString(this.getMileageString()) + lf);
        sb.append("VIN: " + StringUtils.toString(this.getVin()) + lf);
        sb.append("Selling Price: " + StringUtils.toString(this.getSellingPriceString()) + lf);
        sb.append("Selling Price Text: " + StringUtils.toString(this.getSellingPriceText()) + lf);
        sb.append("Color: " + StringUtils.toString(this.getExteriorColor()) + lf);
        sb.append("Condition: " + StringUtils.toString(this.condition) + lf);
        sb.append("Additional Text: " + StringUtils.toString(this.comments) + lf);
        sb.append("Options: ");
        if (this.hasOptions()) {
            Iterator options = this.getOptions().iterator();
            while (options.hasNext()) {
                Option thisOption = (Option)options.next();
                sb.append(thisOption.getName());
                if (!options.hasNext()) continue;
                sb.append(", ");
            }
        }
        sb.append(lf);
        return sb.toString();
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("inventory_id");
        this.vehicleId = rs.getInt("inventory_vehicle_id");
        this.accountId = rs.getInt("account_id");
        this.vin = rs.getString("vin");
        this.mileage = rs.getInt("mileage");
        this.isNew = rs.getBoolean("is_new");
        this.condition = rs.getString("condition");
        this.comments = rs.getString("comments");
        this.stockNo = rs.getString("stock_no");
        this.exteriorColor = rs.getString("ext_color");
        this.interiorColor = rs.getString("int_color");
        this.invoicePrice = rs.getDouble("invoice_price");
        this.sellingPrice = rs.getDouble("selling_price");
        this.sellingPriceText = rs.getString("selling_price_text");
        this.sold = rs.getBoolean("sold");
        this.style = rs.getString("style");
        this.status = rs.getString("status");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.vehicle = new Vehicle(rs);
        Integer tmpPictureId = new Integer(rs.getInt("picture_id"));
        if (tmpPictureId != null && tmpPictureId > 0) {
            this.pictureId = tmpPictureId;
        }
    }
}

