/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.media.autoguide.base;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.base.SyncableList;
import org.aspcfs.modules.media.autoguide.base.Inventory;
import org.aspcfs.utils.web.PagedListInfo;

public class InventoryList
extends ArrayList
implements SyncableList {
    public static String tableName = "autoguide_inventory";
    public static String uniqueField = "inventory_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private boolean buildOrganizationInfo = false;
    private boolean buildPictureId = false;
    private boolean buildOptions = false;
    private int orgId = -1;
    private int showSold = -1;
    private boolean showIncompleteAdRunsOnly = false;
    private int showIncompleteInventoryAds = -1;
    private int hasRunDate = -1;
    private int makeId = -1;
    private Date adRunDate = null;
    private Date adRunDateStart = null;
    private Date adRunDateEnd = null;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setSyncType(String tmp) {
        this.syncType = Integer.parseInt(tmp);
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setAccountId(int tmp) {
        this.setOrgId(tmp);
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public void setAccountId(String tmp) {
        this.setOrgId(tmp);
    }

    public void setBuildOrganizationInfo(boolean tmp) {
        this.buildOrganizationInfo = tmp;
    }

    public void setBuildOrganizationInfo(String tmp) {
        this.buildOrganizationInfo = "1".equals(tmp) || "on".equalsIgnoreCase(tmp) || "true".equalsIgnoreCase(tmp);
    }

    public void setBuildPictureId(boolean tmp) {
        this.buildPictureId = tmp;
    }

    public void setBuildPictureId(String tmp) {
        this.buildPictureId = "on".equals(tmp) || "true".equals(tmp) || "1".equals(tmp);
    }

    public void setBuildOptions(boolean tmp) {
        this.buildOptions = tmp;
    }

    public void setBuildOptions(String tmp) {
        this.buildOptions = "on".equals(tmp) || "true".equals(tmp) || "1".equals(tmp);
    }

    public void setShowSold(int tmp) {
        this.showSold = tmp;
    }

    public void setShowSold(String tmp) {
        this.showSold = tmp != null ? Integer.parseInt(tmp) : -1;
    }

    public void setShowIncompleteAdRunsOnly(boolean tmp) {
        this.showIncompleteAdRunsOnly = tmp;
    }

    public void setShowIncompleteInventoryAds(int tmp) {
        this.showIncompleteInventoryAds = tmp;
    }

    public void setShowIncompleteInventoryAds(String tmp) {
        this.showIncompleteInventoryAds = tmp != null ? Integer.parseInt(tmp) : -1;
    }

    public void setHasRunDate(int tmp) {
        this.hasRunDate = tmp;
    }

    public void setHasRunDate(String tmp) {
        this.hasRunDate = tmp != null ? Integer.parseInt(tmp) : -1;
    }

    public void setMakeId(int tmp) {
        this.makeId = tmp;
    }

    public void setMakeId(String tmp) {
        this.makeId = Integer.parseInt(tmp);
    }

    public void setAdRunDate(Date tmp) {
        this.adRunDate = tmp;
    }

    public void setAdRunDateStart(Date tmp) {
        this.adRunDateStart = tmp;
    }

    public void setAdRunDateEnd(Date tmp) {
        this.adRunDateEnd = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public Inventory getObject(ResultSet rs) throws SQLException {
        return new Inventory(rs);
    }

    public void select(Connection db) throws SQLException {
        this.buildList(db);
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            Inventory thisItem = this.getObject(rs);
            this.add(thisItem);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
        if (this.buildOrganizationInfo || this.buildPictureId || this.buildOptions) {
            for (Inventory thisItem : this) {
                if (this.buildOrganizationInfo) {
                    thisItem.buildOrganizationInfo(db);
                }
                if (this.buildPictureId) {
                    thisItem.buildPicture(db);
                }
                if (this.buildOptions) {
                    thisItem.buildOptions(db);
                }
                thisItem.setShowIncompleteAdRunsOnly(this.showIncompleteAdRunsOnly);
                thisItem.buildAdRuns(db);
            }
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM autoguide_inventory i  LEFT JOIN autoguide_vehicle v ON i.vehicle_id = v.vehicle_id  LEFT JOIN autoguide_make make ON v.make_id = make.make_id  LEFT JOIN autoguide_model model ON v.model_id = model.model_id  LEFT JOIN organization o ON i.account_id = o.org_id WHERE i.inventory_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            if (this.pagedListInfo != null) {
                this.pagedListInfo.doManualOffset(db, pst);
            }
            if ((rs = pst.executeQuery()).next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND o.name < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                if (this.pagedListInfo != null) {
                    this.pagedListInfo.doManualOffset(db, pst);
                }
                if ((rs = pst.executeQuery()).next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("o.name,i.stock_no", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY o.name,i.stock_no ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("i.inventory_id, i.vehicle_id AS inventory_vehicle_id, i.account_id, vin, mileage, is_new, condition, comments, stock_no, ext_color, int_color, invoice_price, selling_price, selling_price_text, sold, style, i.status, i.entered, i.enteredby, i.modified, i.modifiedby, v.vehicle_id, v.year, v.make_id AS vehicle_make_id, v.model_id AS vehicle_model_id, v.entered AS vehicle_entered, v.enteredby AS vehicle_enteredby, v.modified AS vehicle_modified, v.modifiedby AS vehicle_modifiedby, model.model_id, model.make_id AS model_make_id, model.model_name, model.entered, model.enteredby, model.modified, model.modifiedby, make.make_id, make.make_name, make.entered AS make_entered, make.enteredby AS make_enteredby, make.modified AS make_modified, make.modifiedby AS make_modifiedby, files.item_id AS picture_id FROM autoguide_inventory i  LEFT JOIN autoguide_vehicle v ON i.vehicle_id = v.vehicle_id  LEFT JOIN autoguide_make make ON v.make_id = make.make_id  LEFT JOIN autoguide_model model ON v.model_id = model.model_id  LEFT JOIN organization o ON i.account_id = o.org_id  LEFT JOIN project_files files ON    (i.inventory_id = files.link_item_id AND files.link_module_id = 14) WHERE i.inventory_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        return rs;
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND i.entered > ? ");
            }
            sqlFilter.append("AND i.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND i.modified > ? ");
            sqlFilter.append("AND i.entered < ? ");
            sqlFilter.append("AND i.modified < ? ");
        }
        if (this.orgId > -1) {
            sqlFilter.append("AND i.account_id = ? ");
        }
        if (this.showSold > -1) {
            sqlFilter.append("AND sold = ? ");
        }
        if (this.showIncompleteInventoryAds > -1) {
            if (this.showIncompleteInventoryAds == 1) {
                sqlFilter.append("AND i.inventory_id IN (SELECT inventory_id FROM autoguide_ad_run WHERE completedby = -1) ");
            } else {
                sqlFilter.append("AND i.inventory_id IN (SELECT inventory_id FROM autoguide_ad_run WHERE completedby > -1) ");
            }
        }
        if (this.makeId > -1) {
            sqlFilter.append("AND i.vehicle_id IN (SELECT vehicle_id FROM autoguide_vehicle WHERE make_id = ?) ");
        }
        if (this.adRunDate != null) {
            sqlFilter.append("AND i.inventory_id IN (SELECT inventory_id FROM autoguide_ad_run WHERE run_date = ?) ");
        }
        if (this.adRunDateStart != null) {
            sqlFilter.append("AND i.inventory_id IN (SELECT inventory_id FROM autoguide_ad_run WHERE run_date >= ?) ");
        }
        if (this.adRunDateEnd != null) {
            sqlFilter.append("AND i.inventory_id IN (SELECT inventory_id FROM autoguide_ad_run WHERE run_date <= ?) ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.orgId > -1) {
            pst.setInt(++i, this.orgId);
        }
        if (this.showSold > -1) {
            pst.setBoolean(++i, this.showSold == 1);
        }
        if (this.makeId > -1) {
            pst.setInt(++i, this.makeId);
        }
        if (this.adRunDate != null) {
            pst.setDate(++i, this.adRunDate);
        }
        if (this.adRunDateStart != null) {
            pst.setDate(++i, this.adRunDateStart);
        }
        if (this.adRunDateEnd != null) {
            pst.setDate(++i, this.adRunDateEnd);
        }
        return i;
    }
}

