/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.media.autoguide.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.media.autoguide.base.InventoryOption;
import org.aspcfs.utils.DatabaseUtils;

public class InventoryOptionList
extends ArrayList {
    private int inventoryId = -1;

    public InventoryOptionList() {
    }

    public InventoryOptionList(Connection db) throws SQLException {
        this.buildList(db);
    }

    public InventoryOptionList(HttpServletRequest request) {
        int i = 0;
        String thisId = null;
        while ((thisId = request.getParameter("option" + ++i + "id")) != null) {
            String checked = request.getParameter("option" + thisId);
            if (!"on".equalsIgnoreCase(checked)) continue;
            InventoryOption thisOption = new InventoryOption();
            thisOption.setOptionId(Integer.parseInt(thisId));
            thisOption.setInventoryId(this.inventoryId);
            this.add(thisOption);
        }
    }

    public void setInventoryId(int tmp) {
        this.inventoryId = tmp;
    }

    public void setInventoryId(String tmp) {
        this.inventoryId = Integer.parseInt(tmp);
    }

    public void setAccountInventoryId(int tmp) {
        this.setInventoryId(tmp);
    }

    public void setAccountInventoryId(String tmp) {
        this.setInventoryId(tmp);
    }

    public int getInventoryId() {
        return this.inventoryId;
    }

    public InventoryOption getObject(ResultSet rs) throws SQLException {
        InventoryOption thisOption = new InventoryOption(rs);
        return thisOption;
    }

    public boolean hasOption(int optionId) {
        for (InventoryOption thisOption : this) {
            if (thisOption.getOptionId() != optionId) continue;
            return true;
        }
        return false;
    }

    public void select(Connection db) throws SQLException {
        this.buildList(db);
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        while (rs.next()) {
            InventoryOption thisOption = this.getObject(rs);
            this.add(thisOption);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        int items = -1;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT io.inventory_id, io.option_id FROM autoguide_inventory_options io  LEFT JOIN autoguide_options o ON (io.option_id = o.option_id) WHERE io.option_id > -1 ");
        this.createFilter(sql);
        sql.append("ORDER BY o." + DatabaseUtils.addQuotes(db, "level") + ", o.option_name ");
        pst = db.prepareStatement(sql.toString());
        items = this.prepareFilter(pst);
        ResultSet rs = pst.executeQuery();
        return rs;
    }

    public void insert(Connection db) throws SQLException {
        for (InventoryOption thisOption : this) {
            thisOption.setInventoryId(this.inventoryId);
            thisOption.insert(db);
        }
    }

    public void update(Connection db) throws SQLException {
        this.delete(db);
        this.insert(db);
    }

    public void delete(Connection db) throws SQLException {
        String sql = "DELETE FROM autoguide_inventory_options WHERE inventory_id = ? ";
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, this.inventoryId);
        pst.execute();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.inventoryId > -1) {
            sqlFilter.append("AND io.inventory_id = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.inventoryId > -1) {
            pst.setInt(++i, this.inventoryId);
        }
        return i;
    }
}

