/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.media.autoguide.base;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.utils.DatabaseUtils;

public class Make {
    private int id = -1;
    private String name = null;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;

    public Make() {
    }

    public Make(String tmp) {
        this.name = tmp;
    }

    public Make(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public Make(Connection db, int thisMakeId) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT make.make_id, make.make_name, make.entered as make_entered, make.enteredby as make_enteredby, make.modified as make_modified, make.modifiedby as make_modifiedby FROM autoguide_make make ");
        sql.append("WHERE make_id = ? ");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(1, thisMakeId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = Timestamp.valueOf(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = Timestamp.valueOf(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public String getGuid() {
        return String.valueOf(this.id);
    }

    public boolean exists(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT make.make_id, make.make_name, make.entered as make_entered, make.enteredby as make_enteredby, make.modified as make_modified, make.modifiedby as make_modifiedby FROM autoguide_make make WHERE " + DatabaseUtils.toLowerCase(db) + "(make_name) = ? ");
        pst.setString(1, this.name.toLowerCase());
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        return this.id > -1;
    }

    public boolean insert(Connection db) throws SQLException {
        int i = 0;
        this.id = DatabaseUtils.getNextSeq(db, "autoguide_make_make_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO autoguide_make (" + (this.id > -1 ? "make_id, " : "") + "make_name, enteredby, modifiedby) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?) ");
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setString(++i, this.name);
        pst.setInt(++i, this.getEnteredBy());
        pst.setInt(++i, this.getEnteredBy());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "autoguide_make_make_id_seq", this.id);
        return true;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("ID was not specified");
        }
        PreparedStatement pst = null;
        int recordCount = 0;
        pst = db.prepareStatement("DELETE FROM autoguide_make WHERE make_id = ? ");
        pst.setInt(1, this.id);
        recordCount = pst.executeUpdate();
        pst.close();
        return recordCount != 0;
    }

    public int update(Connection db, ActionContext context) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Record ID was not specified");
        }
        int resultCount = 0;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE autoguide_make SET make_name = ?, modifiedby = ?, modified = CURRENT_TIMESTAMP WHERE make_id = ? AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.name);
        pst.setInt(++i, this.modifiedBy);
        pst.setInt(++i, this.id);
        if (this.getModified() != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("make_id");
        this.name = rs.getString("make_name");
        this.entered = rs.getTimestamp("make_entered");
        this.enteredBy = rs.getInt("make_enteredby");
        this.modified = rs.getTimestamp("make_modified");
        this.modifiedBy = rs.getInt("make_modifiedby");
    }
}

