/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.media.autoguide.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.base.SyncableList;
import org.aspcfs.modules.media.autoguide.base.Make;

public class MakeList
extends ArrayList
implements SyncableList {
    public static String tableName = "autoguide_make";
    public static String uniqueField = "make_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private int year = -1;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setSyncType(String tmp) {
        this.syncType = Integer.parseInt(tmp);
    }

    public void setYear(int tmp) {
        this.year = tmp;
    }

    public void setYear(String tmp) {
        try {
            this.year = Integer.parseInt(tmp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public Make getObject(ResultSet rs) throws SQLException {
        Make thisMake = new Make(rs);
        return thisMake;
    }

    public void select(Connection db) throws SQLException {
        this.buildList(db);
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        while (rs.next()) {
            Make thisMake = this.getObject(rs);
            this.add(thisMake);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        ResultSet rs = null;
        int items = -1;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT make.make_id, make.make_name, make.entered as make_entered, make.enteredby as make_enteredby, make.modified as make_modified, make.modifiedby as make_modifiedby FROM autoguide_make make ");
        sql.append("WHERE make_id > -1 ");
        this.createFilter(sql);
        sql.append("ORDER BY make_name ");
        pst = db.prepareStatement(sql.toString());
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        return rs;
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND make.entered > ? ");
            }
            sqlFilter.append("AND make.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND make.modified > ? ");
            sqlFilter.append("AND make.entered < ? ");
            sqlFilter.append("AND make.modified < ? ");
        }
        if (this.year > -1) {
            sqlFilter.append("AND make.make_id IN (SELECT DISTINCT make_id FROM autoguide_vehicle WHERE year = ?) ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.year > -1) {
            pst.setInt(++i, this.year);
        }
        return i;
    }
}

