/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.media.autoguide.base;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.modules.media.autoguide.base.Make;
import org.aspcfs.utils.DatabaseUtils;

public class Model {
    private int id = -1;
    private int makeId = -1;
    private String name = null;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private Make make = null;

    public Model() {
    }

    public Model(String tmp) {
        this.name = tmp;
    }

    public Model(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
        this.make = new Make(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setMakeId(int tmp) {
        this.makeId = tmp;
    }

    public void setMakeId(String tmp) {
        this.makeId = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = Timestamp.valueOf(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = Timestamp.valueOf(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setMake(Make tmp) {
        this.make = tmp;
    }

    public int getId() {
        return this.id;
    }

    public int getMakeId() {
        return this.makeId;
    }

    public String getName() {
        return this.name;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Make getMake() {
        return this.make;
    }

    public String getGuid() {
        return String.valueOf(this.id);
    }

    public boolean exists(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT model.model_id, model.make_id AS model_make_id, model.model_name, model.entered, model.enteredby, model.modified, model.modifiedby FROM autoguide_model model WHERE " + DatabaseUtils.toLowerCase(db) + "(model_name) = ? " + "AND model.make_id = ? ");
        pst.setString(1, this.name.toLowerCase());
        pst.setInt(2, this.makeId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        return this.id > -1;
    }

    public boolean insert(Connection db) throws SQLException {
        int i = 0;
        this.id = DatabaseUtils.getNextSeq(db, "autoguide_model_model_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO autoguide_model (" + (this.id > -1 ? "model_id, " : "") + "make_id, model_name, enteredby, modifiedby) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?) ");
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.makeId);
        pst.setString(++i, this.name);
        pst.setInt(++i, this.getEnteredBy());
        pst.setInt(++i, this.getEnteredBy());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "autoguide_model_model_id_seq", this.id);
        return true;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("ID was not specified");
        }
        PreparedStatement pst = null;
        int recordCount = 0;
        pst = db.prepareStatement("DELETE FROM autoguide_model WHERE model_id = ? ");
        pst.setInt(1, this.id);
        recordCount = pst.executeUpdate();
        pst.close();
        return recordCount != 0;
    }

    public int update(Connection db, ActionContext context) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Record ID was not specified");
        }
        int resultCount = 0;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE autoguide_model SET make_id = ?, model_name = ?, modifiedby = ?, modified = CURRENT_TIMESTAMP WHERE model_id = ? AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, this.makeId);
        pst.setString(++i, this.name);
        pst.setInt(++i, this.modifiedBy);
        pst.setInt(++i, this.id);
        if (this.getModified() != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public void buildResources(Connection db) throws SQLException {
        this.make = new Make(db, this.makeId);
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("model_id");
        this.makeId = rs.getInt("model_make_id");
        this.name = rs.getString("model_name");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
    }
}

