/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.media.autoguide.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.base.SyncableList;
import org.aspcfs.modules.media.autoguide.base.Model;

public class ModelList
extends ArrayList
implements SyncableList {
    public static String tableName = "autoguide_model";
    public static String uniqueField = "model_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private int makeId = -1;
    private int year = -1;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setSyncType(String tmp) {
        this.syncType = Integer.parseInt(tmp);
    }

    public void setMakeId(int tmp) {
        this.makeId = tmp;
    }

    public void setMakeId(String tmp) {
        this.makeId = Integer.parseInt(tmp);
    }

    public void setYear(int tmp) {
        this.year = tmp;
    }

    public void setYear(String tmp) {
        try {
            this.year = Integer.parseInt(tmp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getMakeId() {
        return this.makeId;
    }

    public int getYear() {
        return this.year;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public Model getObject(ResultSet rs) throws SQLException {
        Model thisModel = new Model(rs);
        return thisModel;
    }

    public void select(Connection db) throws SQLException {
        this.buildList(db);
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        while (rs.next()) {
            Model thisModel = new Model(rs);
            this.add(thisModel);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        ResultSet rs = null;
        int items = -1;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT model.model_id, model.make_id AS model_make_id, model.model_name, model.entered, model.enteredby, model.modified, model.modifiedby, make.make_id, make.make_name, make.entered AS make_entered, make.enteredby AS make_enteredby, make.modified AS make_modified, make.modifiedby AS make_modifiedby FROM autoguide_model model LEFT JOIN autoguide_make make ON model.make_id = make.make_id ");
        sql.append("WHERE model.model_id > -1 ");
        this.createFilter(sql);
        sql.append("ORDER BY model_name ");
        pst = db.prepareStatement(sql.toString());
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        return rs;
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND model.entered > ? ");
            }
            sqlFilter.append("AND model.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND model.modified > ? ");
            sqlFilter.append("AND model.entered < ? ");
            sqlFilter.append("AND model.modified < ? ");
        }
        if (this.makeId > -1) {
            sqlFilter.append("AND make.make_id = ? ");
            if (this.year > -1) {
                sqlFilter.append("AND model.model_id IN (SELECT DISTINCT model_id FROM autoguide_vehicle WHERE year = ?) ");
            }
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.makeId > -1) {
            pst.setInt(++i, this.makeId);
            if (this.year > -1) {
                pst.setInt(++i, this.year);
            }
        }
        return i;
    }
}

