/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.media.autoguide.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.base.SyncableList;
import org.aspcfs.modules.media.autoguide.base.Option;
import org.aspcfs.utils.DatabaseUtils;

public class OptionList
extends ArrayList
implements SyncableList {
    public static String tableName = "autoguide_options";
    public static String uniqueField = "option_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private int inventoryId = -1;

    public OptionList() {
    }

    public OptionList(Connection db) throws SQLException {
        this.buildList(db);
    }

    public OptionList(HttpServletRequest request) {
        int i = 0;
        String thisId = null;
        while ((thisId = request.getParameter("option" + ++i + "id")) != null) {
            String checked = request.getParameter("option" + thisId);
            if (!"on".equalsIgnoreCase(checked)) continue;
            Option thisOption = new Option();
            thisOption.setId(Integer.parseInt(thisId));
            this.add(thisOption);
        }
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setSyncType(String tmp) {
        this.syncType = Integer.parseInt(tmp);
    }

    public void setInventoryId(int tmp) {
        this.inventoryId = tmp;
    }

    public void setInventoryId(String tmp) {
        this.inventoryId = Integer.parseInt(tmp);
    }

    public void setAccountInventoryId(int tmp) {
        this.setInventoryId(tmp);
    }

    public void setAccountInventoryId(String tmp) {
        this.setInventoryId(tmp);
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public int getInventoryId() {
        return this.inventoryId;
    }

    public Option getObject(ResultSet rs) throws SQLException {
        Option thisOption = new Option(rs);
        return thisOption;
    }

    public boolean hasOption(int optionId) {
        for (Option thisOption : this) {
            if (thisOption.getId() != optionId) continue;
            return true;
        }
        return false;
    }

    public void select(Connection db) throws SQLException {
        this.buildList(db);
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        while (rs.next()) {
            Option thisOption = this.getObject(rs);
            this.add(thisOption);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        int items = -1;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT o.option_id, o.option_name, o.entered, o.modified FROM autoguide_options o ");
        if (this.inventoryId > -1) {
            sql.append(", autoguide_inventory_options io ");
        }
        sql.append("WHERE o.option_id > -1 ");
        this.createFilter(sql);
        sql.append("ORDER BY " + DatabaseUtils.addQuotes(db, "level") + ", o.option_name ");
        pst = db.prepareStatement(sql.toString());
        items = this.prepareFilter(pst);
        ResultSet rs = pst.executeQuery();
        return rs;
    }

    public void insert(Connection db) throws SQLException {
        for (Option thisOption : this) {
            thisOption.setInventoryId(this.inventoryId);
            thisOption.insert(db);
        }
    }

    public void update(Connection db) throws SQLException {
        this.delete(db);
        this.insert(db);
    }

    public void delete(Connection db) throws SQLException {
        String sql = "DELETE FROM autoguide_inventory_options WHERE inventory_id = ? ";
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, this.inventoryId);
        pst.execute();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
        if (this.inventoryId > -1) {
            sqlFilter.append("AND o.option_id = io.option_id AND io.inventory_id = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.inventoryId > -1) {
            pst.setInt(++i, this.inventoryId);
        }
        return i;
    }
}

