/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.media.autoguide.base;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.modules.media.autoguide.base.Make;
import org.aspcfs.modules.media.autoguide.base.Model;
import org.aspcfs.utils.DatabaseUtils;

public class Vehicle {
    private int id = -1;
    private int year = -1;
    private int makeId = -1;
    private int modelId = -1;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private Make make = null;
    private Model model = null;

    public Vehicle() {
    }

    public Vehicle(int year, int make, int model) {
        this.setYear(year);
        this.makeId = make;
        this.modelId = model;
    }

    public Vehicle(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
        this.make = new Make(rs);
        this.model = new Model(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setYear(int inYear) {
        if (inYear < 100) {
            inYear = inYear < 20 ? (inYear += 2000) : (inYear += 1900);
        }
        this.year = inYear;
    }

    public void setYear(String tmp) {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("Vehicle-> setYear(" + tmp + ")");
        }
        this.setYear(Integer.parseInt(tmp));
    }

    public void setMakeId(int tmp) {
        this.makeId = tmp;
    }

    public void setMakeId(String tmp) {
        this.makeId = Integer.parseInt(tmp);
    }

    public void setModelId(int tmp) {
        this.modelId = tmp;
    }

    public void setModelId(String tmp) {
        this.modelId = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = Timestamp.valueOf(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = Timestamp.valueOf(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setMake(Make tmp) {
        this.make = tmp;
    }

    public void setModel(Model tmp) {
        this.model = tmp;
    }

    public int getId() {
        return this.id;
    }

    public int getYear() {
        return this.year;
    }

    public int getMakeId() {
        return this.makeId;
    }

    public int getModelId() {
        return this.modelId;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public String getGuid() {
        return String.valueOf(this.id);
    }

    public Make getMake() {
        if (this.make == null) {
            this.make = new Make();
        }
        return this.make;
    }

    public Model getModel() {
        if (this.model == null) {
            this.model = new Model();
        }
        return this.model;
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "autoguide_vehicl_vehicle_id_seq");
        int i = 0;
        PreparedStatement pst = db.prepareStatement("INSERT INTO autoguide_vehicle (" + (this.id > -1 ? "vehicle_id, " : "") + "year, make_id, model_id, enteredby, modifiedby) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?) ");
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.year);
        pst.setInt(++i, this.makeId);
        pst.setInt(++i, this.modelId);
        pst.setInt(++i, this.enteredBy);
        pst.setInt(++i, this.enteredBy);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "autoguide_vehicl_vehicle_id_seq", this.id);
        return true;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("ID was not specified");
        }
        PreparedStatement pst = null;
        int recordCount = 0;
        pst = db.prepareStatement("DELETE FROM autoguide_vehicle WHERE vehicle_id = ? ");
        pst.setInt(1, this.id);
        recordCount = pst.executeUpdate();
        pst.close();
        return recordCount != 0;
    }

    public int update(Connection db, ActionContext context) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("Record ID was not specified");
        }
        int resultCount = 0;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE autoguide_vehicle SET year = ?, make_id = ?, model_id = ?, modifiedby = ?, modified = CURRENT_TIMESTAMP WHERE vehicle_id = ? AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, this.year);
        pst.setInt(++i, this.makeId);
        pst.setInt(++i, this.modelId);
        pst.setInt(++i, this.modifiedBy);
        pst.setInt(++i, this.id);
        if (this.getModified() != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public int generateId(Connection db) throws SQLException {
        String sql = "SELECT vehicle_id FROM autoguide_vehicle WHERE year = ? AND make_id = ? AND model_id = ? ";
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, this.year);
        pst.setInt(2, this.makeId);
        pst.setInt(3, this.modelId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.id = rs.getInt("vehicle_id");
        }
        rs.close();
        pst.close();
        if (System.getProperty("DEBUG") != null) {
            System.out.println("Vehicle-> Looking up id for: year(" + this.year + ") make(" + this.makeId + ") model(" + this.modelId + ") = " + this.id);
        }
        return this.id;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("vehicle_id");
        this.year = rs.getInt("year");
        this.makeId = rs.getInt("vehicle_make_id");
        this.modelId = rs.getInt("vehicle_model_id");
        this.entered = rs.getTimestamp("vehicle_entered");
        this.enteredBy = rs.getInt("vehicle_enteredby");
        this.modified = rs.getTimestamp("vehicle_modified");
        this.modifiedBy = rs.getInt("vehicle_modifiedby");
    }
}

