/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.media.autoguide.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.base.SyncableList;
import org.aspcfs.modules.media.autoguide.base.Vehicle;
import org.aspcfs.utils.web.PagedListInfo;

public class VehicleList
extends ArrayList
implements SyncableList {
    public static final String tableName = "autoguide_vehicle";
    public static final String uniqueField = "vehicle_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private int year = -1;
    private PagedListInfo pagedListInfo = null;

    public static ArrayList buildYearList(Connection db) throws SQLException {
        ArrayList<String> years = new ArrayList<String>();
        String sql = "SELECT DISTINCT year FROM autoguide_vehicle ORDER BY year DESC";
        PreparedStatement pst = db.prepareStatement(sql);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            String thisYear = String.valueOf(rs.getInt("year"));
            years.add(thisYear);
        }
        rs.close();
        pst.close();
        return years;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setSyncType(String tmp) {
        this.syncType = Integer.parseInt(tmp);
    }

    public void setYear(int tmp) {
        this.year = tmp;
    }

    public void setYear(String tmp) {
        this.year = Integer.parseInt(tmp);
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public Vehicle getObject(ResultSet rs) throws SQLException {
        Vehicle thisVehicle = new Vehicle(rs);
        return thisVehicle;
    }

    public void select(Connection db) throws SQLException {
        this.buildList(db);
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        while (rs.next()) {
            Vehicle thisVehicle = this.getObject(rs);
            this.add(thisVehicle);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM autoguide_vehicle v  LEFT JOIN autoguide_make make ON v.make_id = make.make_id  LEFT JOIN autoguide_model model ON v.model_id = model.model_id WHERE vehicle_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("v.vehicle_id", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY v.vehicle_id ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("v.vehicle_id, v.year, v.make_id AS vehicle_make_id, v.model_id AS vehicle_model_id, v.entered AS vehicle_entered, v.enteredby AS vehicle_enteredby, v.modified AS vehicle_modified, v.modifiedby AS vehicle_modifiedby, model.model_id, model.make_id AS model_make_id, model.model_name, model.entered, model.enteredby, model.modified, model.modifiedby, make.make_id, make.make_name, make.entered AS make_entered, make.enteredby AS make_enteredby, make.modified AS make_modified, make.modifiedby AS make_modifiedby FROM autoguide_vehicle v  LEFT JOIN autoguide_make make ON v.make_id = make.make_id  LEFT JOIN autoguide_model model ON v.model_id = model.model_id WHERE vehicle_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        return rs;
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND v.entered > ? ");
            }
            sqlFilter.append("AND v.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND v.modified > ? ");
            sqlFilter.append("AND v.entered < ? ");
            sqlFilter.append("AND v.modified < ? ");
        }
        if (this.year > -1) {
            sqlFilter.append("AND v.year = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.year > -1) {
            pst.setInt(++i, this.year);
        }
        return i;
    }
}

