/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.media.autoguide.readers;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.database.ConnectionPool;
import java.io.File;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import org.aspcfs.apps.transfer.DataReader;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.apps.transfer.writer.TextWriter;
import org.aspcfs.apps.transfer.writer.cfshttpxmlwriter.CFSHttpXMLWriter;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.accounts.base.OrganizationList;
import org.aspcfs.modules.media.autoguide.base.Inventory;
import org.aspcfs.modules.media.autoguide.base.InventoryList;
import org.aspcfs.modules.media.autoguide.base.Option;
import org.aspcfs.utils.ImageUtils;
import org.aspcfs.utils.NCFTPApp;
import org.aspcfs.utils.StringUtils;

public class PilotOnlineReader
implements DataReader {
    public static final String fs = System.getProperty("file.separator");
    private String driver = null;
    private String url = null;
    private String user = null;
    private String password = null;
    private String pictureSourcePath = null;
    private String pictureDestinationPath = null;
    private String ftpData = null;
    private String ftpPictures = null;
    private String logUrl = null;
    private String logId = null;
    private String logCode = null;
    private int logSystemId = -1;
    private int logClientId = -1;
    private ArrayList picturesToProcess = new ArrayList();
    private ArrayList processLog = new ArrayList();

    public void setDriver(String tmp) {
        this.driver = tmp;
    }

    public void setUrl(String tmp) {
        this.url = tmp;
    }

    public void setUser(String tmp) {
        this.user = tmp;
    }

    public void setPassword(String tmp) {
        this.password = tmp;
    }

    public void setPictureSourcePath(String tmp) {
        this.pictureSourcePath = tmp.endsWith(fs) ? tmp : tmp + fs;
    }

    public void setPictureDestinationPath(String tmp) {
        this.pictureDestinationPath = tmp.endsWith(fs) ? tmp : tmp + fs;
    }

    public void setFtpData(String tmp) {
        this.ftpData = tmp;
    }

    public void setFtpPictures(String tmp) {
        this.ftpPictures = tmp;
    }

    public void setLogUrl(String tmp) {
        this.logUrl = tmp;
    }

    public void setLogId(String tmp) {
        this.logId = tmp;
    }

    public void setLogCode(String tmp) {
        this.logCode = tmp;
    }

    public void setLogSystemId(int tmp) {
        this.logSystemId = tmp;
    }

    public void setLogSystemId(String tmp) {
        this.logSystemId = Integer.parseInt(tmp);
    }

    public void setLogClientId(int tmp) {
        this.logClientId = tmp;
    }

    public void setLogClientId(String tmp) {
        this.logClientId = Integer.parseInt(tmp);
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPictureSourcePath() {
        return this.pictureSourcePath;
    }

    public String getPictureDestinationPath() {
        return this.pictureDestinationPath;
    }

    public String getFtpData() {
        return this.ftpData;
    }

    public String getFtpPictures() {
        return this.ftpPictures;
    }

    public double getVersion() {
        return 1.0;
    }

    public String getName() {
        return "Pilot Online Reader/FTP";
    }

    public String getDescription() {
        return "Reads dealer and vehicle data for PilotOnline";
    }

    public boolean isConfigured() {
        boolean configOK = true;
        if (this.driver == null) {
            logger.info("PilotOnlineReader-> Config: driver (db) not set");
            configOK = false;
        }
        if (this.url == null) {
            logger.info("PilotOnlineReader-> Config: url (db) not set");
            configOK = false;
        }
        if (this.user == null) {
            logger.info("PilotOnlineReader-> Config: user (db) not set");
            configOK = false;
        }
        if (this.pictureSourcePath == null) {
            logger.info("PilotOnlineReader-> Config: pictureSourcePath not set");
            configOK = false;
        }
        if (this.pictureDestinationPath == null) {
            logger.info("PilotOnlineReader-> Config: pictureDestinationPath not set");
            configOK = false;
        }
        if (this.ftpData == null) {
            logger.info("PilotOnlineReader-> Config: ftpData not set");
            configOK = false;
        }
        if (this.ftpPictures == null) {
            logger.info("PilotOnlineReader-> Config: ftpPictures not set");
            configOK = false;
        }
        return configOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(DataWriter writer) {
        NCFTPApp ftp;
        boolean processOK = true;
        this.processLog.add("INFO: PilotOnlineReader-> Started " + new java.util.Date());
        ConnectionPool sqlDriver = null;
        Connection db = null;
        ConnectionElement connectionElement = null;
        try {
            sqlDriver = new ConnectionPool();
            sqlDriver.setMaxConnections(1);
            sqlDriver.setDebug(true);
            connectionElement = new ConnectionElement(this.url, this.user, this.password);
            connectionElement.setAllowCloseOnIdle(false);
            connectionElement.setDriver(this.driver);
            db = sqlDriver.getConnection(connectionElement);
        }
        catch (SQLException e) {
            this.processLog.add("ERROR: Could not get database connection: " + e.toString());
            processOK = false;
        }
        try {
            OrganizationList organizationList = new OrganizationList();
            organizationList.buildList(db);
            Calendar runDateStart = Calendar.getInstance();
            Calendar runDateEnd = Calendar.getInstance();
            switch (runDateStart.get(7)) {
                case 7: {
                    runDateStart.add(5, -3);
                    runDateEnd.add(5, -3);
                    break;
                }
                case 1: {
                    runDateStart.add(5, -4);
                    runDateEnd.add(5, -4);
                    break;
                }
                case 2: {
                    runDateStart.add(5, -5);
                    runDateEnd.add(5, -5);
                    break;
                }
                case 3: {
                    runDateStart.add(5, 1);
                    runDateEnd.add(5, 1);
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    runDateStart.add(5, -1);
                    runDateEnd.add(5, -1);
                    break;
                }
                case 6: {
                    runDateStart.add(5, -2);
                    runDateEnd.add(5, -2);
                    break;
                }
                default: {
                    while (runDateStart.get(7) != 4) {
                        runDateStart.add(5, 1);
                        runDateEnd.add(5, 1);
                    }
                    break block5;
                }
            }
            runDateStart.add(5, -2);
            runDateEnd.add(5, 2);
            runDateStart.set(10, 0);
            runDateStart.set(12, 0);
            runDateStart.set(13, 0);
            runDateStart.set(14, 0);
            runDateEnd.set(10, 0);
            runDateEnd.set(12, 0);
            runDateEnd.set(13, 0);
            runDateEnd.set(14, 0);
            this.processLog.add("INFO: Processing organizations/vehicles: " + organizationList.size() + " for " + runDateStart.getTime() + " through " + runDateEnd.getTime());
            int vehicleCount = 0;
            for (Organization dealer : organizationList) {
                InventoryList inventoryList = new InventoryList();
                inventoryList.setOrgId(dealer.getId());
                inventoryList.setShowSold(0);
                inventoryList.setAdRunDateStart(new Date(runDateStart.getTime().getTime()));
                inventoryList.setAdRunDateEnd(new Date(runDateEnd.getTime().getTime()));
                inventoryList.setBuildPictureId(true);
                inventoryList.setBuildOptions(true);
                inventoryList.buildList(db);
                Iterator inventory = inventoryList.iterator();
                while (inventory.hasNext()) {
                    ++vehicleCount;
                    Inventory vehicle = (Inventory)inventory.next();
                    DataRecord thisRecord = new DataRecord();
                    thisRecord.setName("vehicle");
                    thisRecord.setAction("insert");
                    thisRecord.addField("accountId", dealer.getId());
                    thisRecord.addField("accountNumber", dealer.getAccountNumber());
                    thisRecord.addField("accountName", dealer.getName());
                    thisRecord.addField("id", vehicle.getId());
                    thisRecord.addField("make", vehicle.getVehicle().getMake().getName());
                    thisRecord.addField("model", vehicle.getVehicle().getModel().getName());
                    thisRecord.addField("year", vehicle.getVehicle().getYear());
                    thisRecord.addField("color", vehicle.getExteriorColor());
                    thisRecord.addField("mileage", vehicle.getMileageString());
                    StringBuffer optionText = new StringBuffer();
                    if (vehicle.hasOptions()) {
                        Iterator options = vehicle.getOptions().iterator();
                        while (options.hasNext()) {
                            Option thisOption = (Option)options.next();
                            optionText.append(thisOption.getName());
                            if (!options.hasNext()) continue;
                            optionText.append(" ");
                        }
                    }
                    thisRecord.addField("options", optionText.toString());
                    thisRecord.addField("comments", PilotOnlineReader.toOneLine(vehicle.getComments()));
                    thisRecord.addField("condition", vehicle.getCondition());
                    thisRecord.addField("sellingPrice", vehicle.getSellingPriceString());
                    thisRecord.addField("accountPhone", dealer.getPhoneNumber("Main"));
                    thisRecord.addField("accountEmail", dealer.getEmailAddress("Primary"));
                    if (vehicle.hasPicture()) {
                        String pictureName = vehicle.getPicture().getFilename();
                        if (pictureName.endsWith("TH")) {
                            pictureName = pictureName.substring(0, pictureName.indexOf("TH"));
                        }
                        thisRecord.addField("pictureFilename", pictureName + ".jpg");
                        this.picturesToProcess.add(pictureName);
                    } else {
                        thisRecord.addField("pictureFilename", "");
                    }
                    writer.save(thisRecord);
                }
            }
            this.processLog.add("INFO: Vehicles added-> " + vehicleCount);
            writer.close();
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace(System.out);
                this.processLog.add("ERROR: Querying organizations/vehicles-> " + ex.getMessage());
                processOK = false;
                writer.close();
            }
            catch (Throwable throwable) {
                writer.close();
                sqlDriver.free(db);
                sqlDriver.destroy();
                sqlDriver = null;
                throw throwable;
            }
            sqlDriver.free(db);
            sqlDriver.destroy();
            sqlDriver = null;
        }
        sqlDriver.free(db);
        sqlDriver.destroy();
        sqlDriver = null;
        if (processOK && this.picturesToProcess.size() > 0) {
            this.processLog.add("INFO: Processing pictures (resize/copy): " + this.picturesToProcess.size());
            Iterator pictures = this.picturesToProcess.iterator();
            int failureCount = 0;
            while (pictures.hasNext()) {
                String thisPicture = (String)pictures.next();
                File sourcePicture = new File(this.pictureSourcePath + thisPicture.substring(0, 4) + fs + thisPicture.substring(4, 8) + fs + thisPicture);
                File destinationPicture = new File(this.pictureDestinationPath + thisPicture + ".jpg");
                if (!sourcePicture.exists() || destinationPicture.exists()) continue;
                try {
                    ImageUtils.saveThumbnail(sourcePicture, destinationPicture, 285.0, -1.0);
                }
                catch (Exception e) {
                    ++failureCount;
                    e.printStackTrace(System.out);
                    this.processLog.add("ERROR: Processing picture-> " + e.getMessage());
                }
            }
            if (failureCount == this.picturesToProcess.size()) {
                this.processLog.add("ERROR: No pictures scaled");
                processOK = false;
            }
        }
        if (processOK && this.picturesToProcess.size() > 0) {
            this.processLog.add("INFO: FTP Sending pictures");
            boolean sendComplete = false;
            ftp = new NCFTPApp();
            ftp.setDeleteSourceFilesAfterSend(true);
            ftp.setMakeRemoteDir(true);
            ftp.addFile(this.pictureDestinationPath + "*.jpg");
            for (int retryCount = 0; !sendComplete && retryCount < 10; ++retryCount) {
                boolean bl = processOK = ftp.put(this.ftpPictures) == 0;
                if (!processOK) {
                    this.processLog.add("ERROR: FTP Sending pictures-> " + ftp.getStdErr());
                    continue;
                }
                sendComplete = true;
            }
        } else if (this.picturesToProcess.size() > 0) {
            this.processLog.add("ERROR: FTP Sending pictures-> Skipped because of previous error");
        }
        if (processOK) {
            this.processLog.add("INFO: FTP Sending data");
            boolean sendComplete = false;
            ftp = new NCFTPApp();
            ftp.setDeleteSourceFilesAfterSend(true);
            ftp.setMakeRemoteDir(true);
            ftp.addFile(((TextWriter)writer).getFilename());
            for (int retryCount = 0; !sendComplete && retryCount < 6; ++retryCount) {
                boolean bl = processOK = ftp.put(this.ftpData) == 0;
                if (!processOK) {
                    this.processLog.add("ERROR: FTP Sending data-> " + ftp.getStdErr());
                    continue;
                }
                sendComplete = true;
            }
        } else {
            this.processLog.add("ERROR: FTP Sending data-> Skipped because of previous error");
        }
        this.processLog.add("INFO: PilotOnlineReader-> Finished " + new java.util.Date());
        if (this.logUrl != null) {
            try {
                CFSHttpXMLWriter serverLog = new CFSHttpXMLWriter();
                serverLog.setUrl(this.logUrl);
                serverLog.setId(this.logId);
                serverLog.setCode(this.logCode);
                serverLog.setSystemId(this.logSystemId);
                serverLog.setClientId(this.logClientId);
                DataRecord logRecord = new DataRecord();
                logRecord.setName("processLog");
                logRecord.setAction("insert");
                logRecord.addField("name", this.getName());
                logRecord.addField("version", this.getVersion());
                logRecord.addField("systemId", this.logSystemId);
                logRecord.addField("clientId", this.logClientId);
                logRecord.addField("status", processOK ? 0 : 1);
                StringBuffer logText = new StringBuffer();
                Iterator logData = this.processLog.iterator();
                while (logData.hasNext()) {
                    String logItem = (String)logData.next();
                    logText.append(logItem);
                    if (!logData.hasNext()) continue;
                    logText.append(System.getProperty("line.separator"));
                }
                logRecord.addField("message", logText.toString());
                serverLog.save(logRecord);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (System.getProperty("DEBUG") != null) {
            for (String logItem : this.processLog) {
                System.out.println(logItem);
            }
        }
        return processOK;
    }

    private static String toOneLine(String in) {
        if (in != null && in.length() > 0) {
            String out = StringUtils.replace(in, "\r\n", " ");
            out = StringUtils.replace(out, "\r", " ");
            out = StringUtils.replace(out, "\n", " ");
            return out;
        }
        return "";
    }
}

