/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.media.autoguide.tasks;

import com.zeroio.iteam.base.FileItemList;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.modules.media.autoguide.base.Inventory;

public class AutoGuideMaintenance {
    public static final String fs = System.getProperty("file.separator");

    public AutoGuideMaintenance(Connection db, HashMap siteInfo, HashMap config) {
        try {
            String filePath = (String)config.get("FileLibrary") + (String)siteInfo.get("name") + fs + "autoguide" + fs;
            ArrayList<Integer> deleteList = new ArrayList<Integer>();
            Calendar dateCheck = Calendar.getInstance();
            dateCheck.add(5, -30);
            PreparedStatement pst = db.prepareStatement("SELECT inventory_id, max(run_date) AS last_date FROM autoguide_ad_run WHERE inventory_id IN (SELECT inventory_id FROM autoguide_inventory WHERE sold = ?) GROUP BY inventory_id HAVING max(run_date) < ? ");
            pst.setBoolean(1, true);
            pst.setDate(2, new Date(dateCheck.getTimeInMillis()));
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                Integer id = new Integer(rs.getInt("inventory_id"));
                deleteList.add(id);
            }
            rs.close();
            pst.close();
            System.out.println("AutoGuideMaintenance-> Vehicles to delete: " + deleteList.size());
            Iterator i = deleteList.iterator();
            while (i.hasNext()) {
                Inventory thisItem = new Inventory(db, (Integer)i.next());
                FileItemList previousFiles = new FileItemList();
                previousFiles.setLinkModuleId(14);
                previousFiles.setLinkItemId(thisItem.getId());
                previousFiles.buildList(db);
                previousFiles.delete(db, filePath);
                thisItem.delete(db);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println("AutoGuideMaintenance-> Finished");
        }
    }
}

