/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.media.autoguide.utils;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.database.ConnectionPool;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aspcfs.modules.media.autoguide.base.Make;
import org.aspcfs.modules.media.autoguide.base.Model;
import org.aspcfs.modules.media.autoguide.base.Vehicle;

public class ParseKBB {
    private String file = null;
    private String driver = null;
    private String url = null;
    private String user = null;
    private String pass = null;

    public static void main(String[] args) {
        ParseKBB thisApp = new ParseKBB();
        thisApp.setFile(System.getProperty("file"));
        thisApp.setDriver(System.getProperty("driver"));
        thisApp.setUrl(System.getProperty("url"));
        thisApp.setUser(System.getProperty("user"));
        thisApp.setPass(System.getProperty("pass"));
        thisApp.process();
        System.exit(0);
    }

    public void setFile(String tmp) {
        this.file = tmp;
    }

    public void setDriver(String tmp) {
        this.driver = tmp;
    }

    public void setUrl(String tmp) {
        this.url = tmp;
    }

    public void setUser(String tmp) {
        this.user = tmp;
    }

    public void setPass(String tmp) {
        this.pass = tmp;
    }

    public String getFile() {
        return this.file;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPass() {
        return this.pass;
    }

    public void process() {
        Logger logger = Logger.getLogger("org.aspcfs.modules.media.autoguide");
        if (this.file == null || this.url == null) {
            logger.info("Not configured");
            return;
        }
        Date startDate = new Date();
        long startMs = System.currentTimeMillis();
        ConnectionPool sqlDriver = null;
        logger.info("Starting...");
        boolean recordCount = false;
        try {
            sqlDriver = new ConnectionPool();
        }
        catch (SQLException e) {
            // empty catch block
        }
        Connection db = null;
        try {
            sqlDriver.setForceClose(false);
            sqlDriver.setMaxConnections(1);
            ConnectionElement thisElement = new ConnectionElement(this.url, this.user, this.pass);
            thisElement.setDriver(this.driver);
            db = sqlDriver.getConnection(thisElement);
            String line = null;
            try {
                BufferedReader in = new BufferedReader(new FileReader(this.file));
                while ((line = in.readLine()) != null) {
                    this.processLine(db, line);
                }
                in.close();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Error reading file", ex);
            }
            sqlDriver.free(db);
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "SQL Error", e);
        }
        sqlDriver.destroy();
        sqlDriver = null;
        Date endDate = new Date();
        long endMs = System.currentTimeMillis();
        logger.info("Start : " + startDate.toString());
        logger.info("End   : " + endDate.toString());
        logger.info("Millis: " + (endMs - startMs) + "ms");
    }

    private void processLine(Connection db, String line) throws SQLException {
        Logger logger = Logger.getLogger("org.aspcfs.modules.media.autoguide");
        StringTokenizer st = new StringTokenizer(line, ",");
        String modelText = st.nextToken().trim();
        String makeText = st.nextToken().trim();
        Make make = new Make(makeText);
        if (!make.exists(db)) {
            make.insert(db);
            logger.fine("Inserting Make-> " + make.getName());
        }
        Model model = new Model(modelText);
        model.setMakeId(make.getId());
        if (!model.exists(db)) {
            logger.fine("Inserting Model-> " + model.getName());
            model.insert(db);
        }
        while (st.hasMoreTokens()) {
            String yearString = st.nextToken().trim();
            if (yearString.indexOf(" ") > -1) {
                StringTokenizer multipleYears = new StringTokenizer(yearString, " ");
                while (multipleYears.hasMoreTokens()) {
                    String thisYear = multipleYears.nextToken().trim();
                    int year = Integer.parseInt(thisYear);
                    Vehicle thisVehicle = new Vehicle(year, make.getId(), model.getId());
                    int id = thisVehicle.generateId(db);
                    if (id != -1) continue;
                    thisVehicle.insert(db);
                    logger.fine("Inserting Year-> " + thisVehicle.getYear());
                }
                continue;
            }
            int year = Integer.parseInt(yearString);
            Vehicle thisVehicle = new Vehicle(year, make.getId(), model.getId());
            int id = thisVehicle.generateId(db);
            if (id != -1) continue;
            thisVehicle.insert(db);
            logger.fine("Inserting Year-> " + thisVehicle.getYear());
        }
    }
}

