/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.mycfs.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.accounts.base.OrganizationList;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.modules.mycfs.base.AlertType;
import org.aspcfs.modules.mycfs.base.CFSNote;
import org.aspcfs.modules.mycfs.base.CFSNoteList;
import org.aspcfs.modules.mycfs.base.CalendarEventList;
import org.aspcfs.modules.mycfs.beans.CalendarBean;
import org.aspcfs.modules.tasks.base.Task;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.SMTPMessage;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.Template;
import org.aspcfs.utils.web.CalendarView;
import org.aspcfs.utils.web.CountrySelect;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;
import org.aspcfs.utils.web.StateSelect;

public final class MyCFS
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        String module = context.getRequest().getParameter("module");
        String includePage = context.getRequest().getParameter("include");
        context.getRequest().setAttribute("IncludePage", (Object)includePage);
        this.addModuleBean(context, module, module);
        return "IncludeOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInbox(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-inbox-view")) {
            return "PermissionError";
        }
        PagedListInfo inboxInfo = this.getPagedListInfo(context, "InboxInfo");
        inboxInfo.setLink("MyCFSInbox.do?command=Inbox");
        Connection db = null;
        CFSNoteList noteList = new CFSNoteList();
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            noteList.setPagedListInfo(inboxInfo);
            noteList.setSentTo(((UserBean)((Object)context.getSession().getAttribute("User"))).getUserRecord().getContact().getId());
            noteList.setSentFrom(this.getUserId(context));
            if (context.getRequest().getParameter("return") != null) {
                inboxInfo.setListView("new");
            }
            if ("old".equals(inboxInfo.getListView())) {
                noteList.setOldMessagesOnly(true);
            }
            if ("sent".equals(inboxInfo.getListView())) {
                if ("sent_namelast".equals(inboxInfo.getColumnToSortBy())) {
                    inboxInfo.setColumnToSortBy("m.sent");
                }
                noteList.setSentMessagesOnly(true);
            } else if ("m.sent".equals(inboxInfo.getColumnToSortBy())) {
                inboxInfo.setColumnToSortBy("sent_namelast");
            }
            noteList.buildList(db);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
        context.getRequest().setAttribute("CFSNoteList", (Object)noteList);
        this.addModuleBean(context, "MyInbox", "Inbox Home");
        return "InboxOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteHeadline(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-miner-delete")) {
            return "PermissionError";
        }
        Enumeration parameters = context.getRequest().getParameterNames();
        int orgId = -1;
        Connection db = null;
        try {
            db = this.getConnection(context);
            while (parameters.hasMoreElements()) {
                String param = (String)parameters.nextElement();
                if (!context.getRequest().getParameter(param).equals("on")) continue;
                orgId = Integer.parseInt(param);
                Organization newOrg = new Organization();
                newOrg.setOrgId(orgId);
                newOrg.deleteMinerOnly(db);
                if (System.getProperty("DEBUG") == null) continue;
                System.out.println("MyCFS-> " + param + ": " + context.getRequest().getParameter(param) + "<br>");
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "", "Headline Delete OK");
        return "DeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandCFSNoteDelete(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-inbox-view")) {
            return "PermissionError";
        }
        Connection db = null;
        int myId = -1;
        PagedListInfo inboxInfo = this.getPagedListInfo(context, "InboxInfo");
        try {
            db = this.getConnection(context);
            int noteId = Integer.parseInt(context.getRequest().getParameter("id"));
            myId = inboxInfo.getListView().equals("sent") ? this.getUserId(context) : ((UserBean)((Object)context.getSession().getAttribute("User"))).getUserRecord().getContact().getId();
            CFSNote newNote = new CFSNote(db, noteId, myId, inboxInfo.getListView());
            if (System.getProperty("DEBUG") != null) {
                System.out.println("\nMYCFS view mode" + context.getRequest().getParameter("listView"));
            }
            newNote.setCurrentView(inboxInfo.getListView());
            newNote.delete(db, myId);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "MyInbox", "Inbox Home");
        return this.executeCommandInbox(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandCFSNoteTrash(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-inbox-view")) {
            return "PermissionError";
        }
        String returnPage = context.getRequest().getParameter("return");
        PagedListInfo inboxInfo = this.getPagedListInfo(context, "InboxInfo");
        Connection db = null;
        int myId = -1;
        try {
            db = this.getConnection(context);
            int noteId = Integer.parseInt(context.getRequest().getParameter("id"));
            myId = inboxInfo.getListView().equals("sent") ? this.getUserId(context) : ((UserBean)((Object)context.getSession().getAttribute("User"))).getUserRecord().getContact().getId();
            CFSNote newNote = new CFSNote(db, noteId, myId, inboxInfo.getListView());
            if (System.getProperty("DEBUG") != null) {
                System.out.println("MyCFS-> Status before: " + newNote.getStatus());
            }
            if (newNote.getStatus() == 2) {
                newNote.setStatus(1);
            } else {
                newNote.setStatus(2);
            }
            newNote.updateStatus(db);
            if (System.getProperty("DEBUG") != null) {
                System.out.println("MyCFS-> Status after: " + newNote.getStatus());
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "MyInbox", "Inbox Home");
        return this.executeCommandInbox(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandHeadline(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-miner-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Customize Headlines", "Customize Headlines");
        PagedListInfo orgListInfo = this.getPagedListInfo(context, "HeadlineListInfo");
        orgListInfo.setLink("MyCFS.do?command=Headline");
        Connection db = null;
        OrganizationList organizationList = new OrganizationList();
        try {
            db = this.getConnection(context);
            organizationList.setPagedListInfo(orgListInfo);
            organizationList.setMinerOnly(true);
            organizationList.setEnteredBy(this.getUserId(context));
            organizationList.buildList(db);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("OrgList", (Object)organizationList);
        return "HeadlineOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsertHeadline(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-miner-add")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Customize Headlines", "");
        boolean existsAlready = false;
        Connection db = null;
        String name = context.getRequest().getParameter("name");
        String sym = context.getRequest().getParameter("stockSymbol");
        Organization newOrg = new Organization();
        newOrg.setName(name);
        newOrg.setTicker(sym);
        newOrg.setIndustry("1");
        newOrg.setEnteredBy(this.getUserId(context));
        newOrg.setModifiedBy(this.getUserId(context));
        newOrg.setOwner(-1);
        newOrg.setMinerOnly(true);
        try {
            db = this.getConnection(context);
            existsAlready = newOrg.checkIfExists(db, name);
            newOrg.insert(db);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("OrgDetails", (Object)newOrg);
        return this.executeCommandHeadline(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandCFSNoteDetails(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-inbox-view")) {
            return "PermissionError";
        }
        PagedListInfo inboxInfo = this.getPagedListInfo(context, "InboxInfo");
        Connection db = null;
        int myId = -1;
        CFSNote newNote = null;
        try {
            int msgId = Integer.parseInt(context.getRequest().getParameter("id"));
            db = this.getConnection(context);
            myId = inboxInfo.getListView().equals("sent") ? this.getUserId(context) : ((UserBean)((Object)context.getSession().getAttribute("User"))).getUserRecord().getContact().getId();
            newNote = new CFSNote(db, msgId, myId, inboxInfo.getListView());
            if (!inboxInfo.getListView().equalsIgnoreCase("sent") && newNote.getStatus() == 0) {
                newNote.setStatus(1);
                newNote.updateStatus(db);
            }
        }
        catch (Exception errorMessage) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "MyInbox", "Inbox Details");
        context.getRequest().setAttribute("NoteDetails", (Object)newNote);
        return "CFSNoteDetailsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandNewMessage(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-inbox-view")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            CFSNote newNote = (CFSNote)((Object)context.getFormBean());
            if (newNote == null) {
                newNote = new CFSNote();
            }
            String subject = context.getRequest().getParameter("subject");
            String body = context.getRequest().getParameter("body");
            String mailRecipients = context.getRequest().getParameter("mailrecipients");
            if (subject != null && !"".equals(subject)) {
                newNote.setSubject(subject);
            }
            if (body != null && !"".equals(body)) {
                newNote.setBody(body);
            }
            if (mailRecipients != null) {
                context.getRequest().setAttribute("mailRecipients", (Object)new String("true"));
            }
            context.getRequest().setAttribute("Note", (Object)newNote);
            context.getRequest().setAttribute("forwardType", (Object)"9");
            context.getSession().removeAttribute("selectedContacts");
            context.getSession().removeAttribute("finalContacts");
            context.getSession().removeAttribute("contactListInfo");
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "MyInbox", "");
        return "CFSNewMessageOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSendMessage(ActionContext context) {
        int noteType = -1;
        boolean recordInserted = false;
        Connection db = null;
        boolean savecopy = false;
        boolean copyrecipients = false;
        HashMap selectedList = (HashMap)context.getSession().getAttribute("finalContacts");
        HashMap<String, String> errors = null;
        if (selectedList == null) {
            selectedList = new HashMap();
        }
        CFSNote thisNote = new CFSNote();
        thisNote.setEnteredBy(this.getUserId(context));
        thisNote.setModifiedBy(this.getUserId(context));
        thisNote.setReplyId(this.getUserId(context));
        thisNote.setType(1);
        if (context.getRequest().getParameter("subject") != null) {
            thisNote.setSubject(context.getRequest().getParameter("subject"));
            context.getRequest().setAttribute("subject", (Object)thisNote.getSubject());
        } else {
            thisNote.setSubject("error");
        }
        if (context.getRequest().getParameter("body") != null) {
            thisNote.setBody(context.getRequest().getParameter("body"));
            context.getRequest().setAttribute("body", (Object)thisNote.getBody());
        } else {
            thisNote.setBody("error");
        }
        if (context.getRequest().getParameter("actionId") != null) {
            thisNote.setActionId(context.getRequest().getParameter("actionId"));
        }
        if (context.getRequest().getParameter("savecopy") != null) {
            savecopy = true;
        }
        if (context.getRequest().getParameter("mailrecipients") != null) {
            copyrecipients = true;
            context.getRequest().setAttribute("mailrecipients", (Object)"true");
        }
        boolean isValid = false;
        Contact thisContact = null;
        User thisRecord = ((UserBean)((Object)context.getSession().getAttribute("User"))).getUserRecord();
        thisRecord.setBuildContact(true);
        try {
            noteType = Integer.parseInt(context.getRequest().getParameter("forwardType"));
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            isValid = this.validateObject(context, db, (Object)thisNote);
            if (isValid) {
                thisRecord.buildResources(db);
                if (selectedList.size() != 0) {
                    String replyAddr = thisRecord.getContact().getPrimaryEmailAddress();
                    int contactId = -1;
                    String email = "";
                    Set s = selectedList.keySet();
                    Iterator i = s.iterator();
                    while (i.hasNext() && isValid) {
                        Integer hashKey = (Integer)i.next();
                        contactId = hashKey;
                        if (selectedList.get(hashKey) != null) {
                            Object st = selectedList.get(hashKey);
                            email = st.toString();
                        }
                        thisContact = new Contact();
                        thisContact.setId(hashKey);
                        thisContact.setBuildDetails(true);
                        thisContact.build(db);
                        thisContact.checkEnabledUserAccount(db);
                        CFSNote tmpNote = new CFSNote();
                        tmpNote.setEnteredBy(this.getUserId(context));
                        tmpNote.setModifiedBy(this.getUserId(context));
                        tmpNote.setReplyId(this.getUserId(context));
                        tmpNote.setType(1);
                        tmpNote.setSubject(thisNote.getSubject());
                        tmpNote.setBody(thisNote.getBody());
                        tmpNote.setActionId(thisNote.getActionId());
                        tmpNote.setSentTo(contactId);
                        if (!(email.startsWith("P:") || !copyrecipients && thisContact.hasAccount())) {
                            SMTPMessage mail = new SMTPMessage();
                            mail.setHost(MyCFS.getPref(context, "MAILSERVER"));
                            mail.setFrom(MyCFS.getPref(context, "EMAILADDRESS"));
                            if (replyAddr != null && !replyAddr.equals("")) {
                                mail.addReplyTo(replyAddr);
                            }
                            mail.setType("text/html");
                            mail.setTo(email);
                            mail.setSubject(tmpNote.getSubject());
                            String message = systemStatus.getLabel("mail.body.emailContactWithBody");
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("${thisRecord.contact.nameFirstLast}", thisRecord.getContact().getNameFirstLast());
                            map.put("${thisNote.body}", StringUtils.toHtml(tmpNote.getBody()));
                            Template template = new Template(message);
                            template.setParseElements(map);
                            mail.setBody(template.getParsedText());
                            if (System.getProperty("DEBUG") != null) {
                                System.out.println("Sending Mail .. " + tmpNote.getBody());
                            }
                            if (mail.send() == 2) {
                                if (System.getProperty("DEBUG") != null) {
                                    System.out.println("MyCFS-> Send error: " + mail.getErrorMsg() + "<br><br>");
                                }
                                System.err.println(mail.getErrorMsg());
                                if (errors == null) {
                                    errors = new HashMap();
                                }
                                errors.put("contact" + thisContact.getId(), systemStatus.getLabel("mail.contactErrorMessage") + mail.getErrorMsg());
                                continue;
                            }
                            if (System.getProperty("DEBUG") != null) {
                                System.out.println("MyCFS-> Sending message to " + email);
                            }
                            recordInserted = tmpNote.insert(db);
                            recordInserted = tmpNote.insertLink(db, thisContact.hasAccount());
                            this.processInsertHook(context, (Object)tmpNote);
                            continue;
                        }
                        if (email.startsWith("P:") && !thisContact.hasAccount()) {
                            if (errors == null) {
                                errors = new HashMap();
                            }
                            errors.put("contact" + thisContact.getId(), systemStatus.getLabel("mail.contactNoEmailAddress"));
                            continue;
                        }
                        if (email.startsWith("P:") && thisContact.getOrgId() != -1 && (!thisContact.hasEnabledAccount() || copyrecipients)) {
                            if (errors == null) {
                                errors = new HashMap();
                            }
                            errors.put("contact" + thisContact.getId(), systemStatus.getLabel("mail.contactNoEmailAddress"));
                            continue;
                        }
                        recordInserted = tmpNote.insert(db);
                        recordInserted = tmpNote.insertLink(db, thisContact.hasAccount());
                        this.processInsertHook(context, (Object)tmpNote);
                    }
                } else {
                    isValid = false;
                    if (errors == null) {
                        errors = new HashMap<String, String>();
                    }
                    errors.put("contactsError", systemStatus.getLabel("mail.contactsNotSelected"));
                }
            }
            context.getSession().removeAttribute("DepartmentList");
            context.getSession().removeAttribute("ProjectListSelect");
        }
        catch (Exception errorMessage) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        if (context.getAction().getActionName().equals("ExternalContactsCallsForward")) {
            this.addModuleBean(context, "External Contacts", "");
        } else if (context.getAction().getActionName().equals("MyCFSInbox")) {
            this.addModuleBean(context, "MyInbox", "");
        } else if (context.getAction().getActionName().equals("MyTasksForward")) {
            this.addModuleBean(context, "My Tasks", "");
        }
        if (errors != null) {
            this.processErrors(context, errors);
        }
        if (isValid) {
            return MyCFS.getReturn(context, "SendMessage");
        }
        if (noteType == 9) {
            return this.executeCommandNewMessage(context);
        }
        if (noteType == 15) {
            return this.executeCommandForwardMessage(context);
        }
        context.getRequest().setAttribute("Error", (Object)new Exception("Programming Error: Please check code"));
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandForwardMessage(ActionContext context) {
        Connection db = null;
        int myId = -1;
        CFSNote newNote = null;
        PagedListInfo inboxInfo = this.getPagedListInfo(context, "InboxInfo");
        if (!this.hasPermission(context, "myhomepage-inbox-view")) {
            return "PermissionError";
        }
        String forward = context.getRequest().getParameter("return");
        if (forward != null && !"".equals(forward.trim())) {
            context.getRequest().setAttribute("return", (Object)forward);
        }
        context.getSession().removeAttribute("selectedContacts");
        context.getSession().removeAttribute("finalContacts");
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            String msgId = context.getRequest().getParameter("id");
            int noteType = Integer.parseInt(context.getRequest().getParameter("forwardType"));
            context.getRequest().setAttribute("forwardType", (Object)("" + noteType));
            db = this.getConnection(context);
            newNote = new CFSNote();
            if (noteType == 9) {
                myId = inboxInfo.getListView().equals("sent") ? this.getUserId(context) : ((UserBean)((Object)context.getSession().getAttribute("User"))).getUserRecord().getContact().getId();
                newNote = new CFSNote(db, Integer.parseInt(msgId), myId, inboxInfo.getListView());
                HashMap recipients = newNote.buildRecipientList(db);
                Iterator i = recipients.keySet().iterator();
                StringBuffer recipientList = new StringBuffer();
                while (i.hasNext()) {
                    Object st = i.next();
                    recipientList.append(st);
                    if (!i.hasNext()) continue;
                    recipientList.append(",");
                }
                String originalMessage = systemStatus.getLabel("mail.label.originalMessage");
                String from = systemStatus.getLabel("mail.label.from");
                String fwd = systemStatus.getLabel("mail.label.forward");
                String sent = systemStatus.getLabel("mail.label.sent");
                String to = systemStatus.getLabel("mail.label.to");
                String subject = systemStatus.getLabel("mail.label.subject.colon");
                newNote.setSubject(fwd + StringUtils.toString(newNote.getSubject()));
                newNote.setBody(originalMessage + from + StringUtils.toString(newNote.getSentName()) + "\n" + sent + DateUtils.getServerToUserDateTimeString(this.getUserTimeZone(context), 3, 1, newNote.getEntered()) + "\n" + to + recipientList.toString() + "\n" + subject + StringUtils.toString(newNote.getSubject()) + "\n\n" + StringUtils.toString(newNote.getBody()) + "\n\n");
            } else if (noteType == 15) {
                Task thisTask = new Task(db, Integer.parseInt(msgId));
                context.getRequest().setAttribute("TaskId", (Object)msgId);
                String userName = ((UserBean)((Object)context.getSession().getAttribute("User"))).getUserRecord().getContact().getNameLastFirst();
                String taskDetails = systemStatus.getLabel("mail.label.taskDetails");
                String task = systemStatus.getLabel("mail.label.task");
                String from = systemStatus.getLabel("mail.label.from");
                String dueDate = systemStatus.getLabel("mail.label.dueDate");
                String relevantNotes = systemStatus.getLabel("mail.label.relevantNotes");
                newNote.setBody(taskDetails + "\n" + task + StringUtils.toString(thisTask.getDescription()) + "\n" + from + StringUtils.toString(userName) + "\n" + dueDate + (thisTask.getDueDate() != null ? DateUtils.getServerToUserDateString(this.getUserTimeZone(context), 3, thisTask.getDueDate()) : "-NA-") + "\n" + ("".equals(thisTask.getNotes()) ? "" : relevantNotes + StringUtils.toString(thisTask.getNotes())) + "\n\n");
            }
            this.freeConnection(context, db);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (context.getAction().getActionName().equals("MyCFSInbox")) {
            this.addModuleBean(context, "My Inbox", "");
        } else if (context.getAction().getActionName().equals("LeadsCallsForward")) {
            this.addModuleBean(context, "View Opportunities", "Opportunity Activities");
        } else {
            this.addModuleBean(context, "My Tasks", "Forward Message");
        }
        context.getRequest().setAttribute("Note", (Object)newNote);
        return "ForwardMessageOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandReplyToMessage(ActionContext context) {
        Connection db = null;
        CFSNote newNote = null;
        PagedListInfo inboxInfo = this.getPagedListInfo(context, "InboxInfo");
        if (!this.hasPermission(context, "myhomepage-inbox-view")) {
            return "PermissionError";
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        String originalMessage = systemStatus.getLabel("mail.label.originalMessage");
        String from = systemStatus.getLabel("mail.label.from");
        String sent = systemStatus.getLabel("mail.label.sent");
        String to = systemStatus.getLabel("mail.label.to");
        String subject = systemStatus.getLabel("mail.label.subject.colon");
        String reply = systemStatus.getLabel("mail.label.reply");
        try {
            int noteType = Integer.parseInt(context.getRequest().getParameter("forwardType"));
            context.getRequest().setAttribute("forwardType", (Object)"9");
            String msgId = context.getRequest().getParameter("id");
            db = this.getConnection(context);
            int myId = -1;
            myId = inboxInfo.getListView().equals("sent") ? this.getUserId(context) : ((UserBean)((Object)context.getSession().getAttribute("User"))).getUserRecord().getContact().getId();
            String listView = inboxInfo.getListView();
            newNote = new CFSNote(db, Integer.parseInt(msgId), myId, listView);
            HashMap recipients = newNote.buildRecipientList(db);
            Iterator i = recipients.keySet().iterator();
            StringBuffer recipientList = new StringBuffer();
            while (i.hasNext()) {
                Object st = i.next();
                recipientList.append(st);
                if (!i.hasNext()) continue;
                recipientList.append(",");
            }
            newNote.setSubject(reply + StringUtils.toString(newNote.getSubject()));
            newNote.setBody(originalMessage + from + StringUtils.toString(newNote.getSentName()) + "\n" + sent + DateUtils.getServerToUserDateTimeString(this.getUserTimeZone(context), 3, 1, newNote.getEntered()) + "\n" + to + recipientList.toString() + "\n" + subject + StringUtils.toString(newNote.getSubject()) + "\n\n" + StringUtils.toString(newNote.getBody()) + "\n\n");
            User sender = this.getUser(context, newNote.getReplyId());
            Contact recipient = new Contact(db, sender.getContactId());
            context.getRequest().setAttribute("Recipient", (Object)recipient);
            HashMap thisList = null;
            if (context.getSession().getAttribute("finalContacts") != null) {
                thisList = (HashMap)context.getSession().getAttribute("finalContacts");
                thisList.clear();
            } else {
                thisList = new HashMap();
                context.getSession().setAttribute("finalContacts", (Object)thisList);
            }
            String recipientEmail = recipient.getPrimaryEmailAddress();
            thisList.put(new Integer(sender.getContactId()), recipientEmail);
            if (context.getSession().getAttribute("selectedContacts") != null) {
                HashMap tmp = (HashMap)context.getSession().getAttribute("selectedContacts");
                tmp.clear();
            }
            this.freeConnection(context, db);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "MyInbox", "Message Reply");
        context.getRequest().setAttribute("Note", (Object)newNote);
        return MyCFS.getReturn(context, "ReplyMessage");
    }

    public String executeCommandHome(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-dashboard-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Home", "");
        if (this.getUserId(context) == 0) {
            return "MaintenanceModeOK";
        }
        UserBean thisUser = (UserBean)((Object)context.getSession().getAttribute("User"));
        User thisRec = thisUser.getUserRecord();
        UserList shortChildList = thisRec.getShortChildList();
        UserList newUserList = thisRec.getFullChildList(shortChildList, new UserList());
        newUserList = UserList.sortEnabledUsers(newUserList, new UserList());
        newUserList.setMyId(this.getUserId(context));
        newUserList.setMyValue(thisUser.getContact().getNameLastFirst());
        newUserList.setIncludeMe(true);
        newUserList.setJsEvent("onChange = \"javascript:fillFrame('calendar','MyCFS.do?command=MonthView&source=Calendar&userId='+document.getElementById('userId').value); javascript:fillFrame('calendardetails','MyCFS.do?command=Alerts&source=CalendarDetails&userId='+document.getElementById('userId').value);javascript:changeDivContent('userName','Scheduled Actions for ' + document.getElementById('userId').options[document.getElementById('userId').selectedIndex].firstChild.nodeValue);\"");
        HtmlSelect userListSelect = newUserList.getHtmlSelectObj("userId", this.getUserId(context));
        userListSelect.addAttribute("id", "userId");
        context.getRequest().setAttribute("NewUserList", (Object)userListSelect);
        SystemStatus systemStatus = this.getSystemStatus(context);
        CalendarBean calendarInfo = (CalendarBean)context.getSession().getAttribute("CalendarInfo");
        if (calendarInfo == null) {
            calendarInfo = new CalendarBean(thisRec.getLocale());
            if (this.hasPermission(context, "myhomepage-tasks-view")) {
                calendarInfo.addAlertType("Task", "org.aspcfs.modules.tasks.base.TaskListScheduledActions", systemStatus.getLabel("calendar.Tasks"));
            }
            if (this.hasPermission(context, "contacts-external_contacts-calls-view") || this.hasPermission(context, "accounts-accounts-contacts-calls-view")) {
                calendarInfo.addAlertType("Call", "org.aspcfs.modules.contacts.base.CallListScheduledActions", systemStatus.getLabel("calendar.Activities"));
            }
            if (this.hasPermission(context, "projects-projects-view")) {
                calendarInfo.addAlertType("Project", "com.zeroio.iteam.base.ProjectListScheduledActions", systemStatus.getLabel("calendar.Projects"));
            }
            if (this.hasPermission(context, "accounts-accounts-view")) {
                calendarInfo.addAlertType("Accounts", "org.aspcfs.modules.accounts.base.AccountsListScheduledActions", systemStatus.getLabel("calendar.Accounts"));
            }
            if (this.hasPermission(context, "contacts-external_contacts-opportunities-view") || this.hasPermission(context, "pipeline-opportunities-view")) {
                calendarInfo.addAlertType("Opportunity", "org.aspcfs.modules.pipeline.base.OpportunityListScheduledActions", systemStatus.getLabel("calendar.Opportunities"));
            }
            if (this.hasPermission(context, "products-view")) {
                calendarInfo.addAlertType("Quote", "org.aspcfs.modules.quotes.base.QuotesListScheduledActions", systemStatus.getLabel("calendar.Quotes"));
            }
            if (this.hasPermission(context, "products-view") || this.hasPermission(context, "tickets-tickets-view")) {
                calendarInfo.addAlertType("Ticket", "org.aspcfs.modules.troubletickets.base.TicketListScheduledActions", systemStatus.getLabel("calendar.Tickets"));
            }
            if (this.hasPermission(context, "projects-projects-view")) {
                calendarInfo.addAlertType("Project Ticket", "org.aspcfs.modules.troubletickets.base.ProjectTicketListScheduledActions", systemStatus.getLabel("calendar.projectTickets"));
            }
            context.getSession().setAttribute("CalendarInfo", (Object)calendarInfo);
        } else {
            calendarInfo.setSelectedUserId(-1);
        }
        return "HomeOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAlerts(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-dashboard-view")) {
            return "PermissionError";
        }
        Connection db = null;
        this.addModuleBean(context, "Home", "");
        CalendarBean calendarInfo = null;
        CalendarView companyCalendar = null;
        String returnPage = context.getRequest().getParameter("return");
        calendarInfo = (CalendarBean)context.getSession().getAttribute(returnPage != null ? returnPage + "CalendarInfo" : "CalendarInfo");
        try {
            db = this.getConnection(context);
            calendarInfo.update(db, context);
            int userId = this.getUserId(context);
            User thisUser = this.getUser(context, userId);
            companyCalendar = new CalendarView(calendarInfo, thisUser.getLocale());
            companyCalendar.setSystemStatus(this.getSystemStatus(context));
            companyCalendar.addHolidays();
            if (context.getRequest().getParameter("userId") != null) {
                userId = Integer.parseInt(context.getRequest().getParameter("userId"));
                if (userId == this.getUserId(context)) {
                    Integer tmpUserId = (Integer)context.getSession().getAttribute("calendarUserId");
                    if (tmpUserId != null) {
                        context.getSession().removeAttribute("calendarUserId");
                    }
                } else {
                    context.getSession().setAttribute("calendarUserId", (Object)new Integer(userId));
                }
            } else if (context.getSession().getAttribute("calendarUserId") != null) {
                userId = (Integer)context.getSession().getAttribute("calendarUserId");
            }
            if (thisUser.getExpires() != null) {
                String expiryDate = DateUtils.getServerToUserDateString(this.getUserTimeZone(context), 3, thisUser.getExpires());
                companyCalendar.addEvent(expiryDate, CalendarEventList.EVENT_TYPES[9], "Your user login expires");
            }
            String selectedAlertType = calendarInfo.getCalendarDetailsView();
            String param1 = "org.aspcfs.utils.web.CalendarView";
            String param2 = "java.sql.Connection";
            ArrayList alertTypes = calendarInfo.getAlertTypes();
            for (int i = 0; i < alertTypes.size(); ++i) {
                AlertType thisAlert = (AlertType)alertTypes.get(i);
                Object thisInstance = Class.forName(thisAlert.getClassName()).newInstance();
                if (!selectedAlertType.equalsIgnoreCase("all") && !selectedAlertType.toLowerCase().equals(thisAlert.getName().toLowerCase())) continue;
                Method method = Class.forName(thisAlert.getClassName()).getMethod("setModule", Class.forName("org.aspcfs.modules.actions.CFSModule"));
                method.invoke(thisInstance, this);
                method = Class.forName(thisAlert.getClassName()).getMethod("setContext", Class.forName("com.darkhorseventures.framework.actions.ActionContext"));
                method.invoke(thisInstance, context);
                method = Class.forName(thisAlert.getClassName()).getMethod("setUserId", Class.forName("java.lang.String"));
                method.invoke(thisInstance, String.valueOf(userId));
                method = Class.forName(thisAlert.getClassName()).getMethod("setAlertRangeStart", Class.forName("java.sql.Timestamp"));
                Timestamp startDate = DatabaseUtils.parseTimestamp(DateUtils.getUserToServerDateTimeString(calendarInfo.getTimeZone(), 3, 1, companyCalendar.getCalendarStartDate(context), Locale.US));
                method.invoke(thisInstance, startDate);
                method = Class.forName(thisAlert.getClassName()).getMethod("setAlertRangeEnd", Class.forName("java.sql.Timestamp"));
                Timestamp endDate = DatabaseUtils.parseTimestamp(DateUtils.getUserToServerDateTimeString(calendarInfo.getTimeZone(), 3, 1, companyCalendar.getCalendarEndDate(context), Locale.US));
                method.invoke(thisInstance, endDate);
                method = Class.forName(thisAlert.getClassName()).getMethod("buildAlerts", Class.forName(param1), Class.forName(param2));
                method.invoke(thisInstance, companyCalendar, db);
                if (selectedAlertType.equalsIgnoreCase("all")) continue;
                break;
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("CompanyCalendar", (Object)companyCalendar);
        return "CalendarDetailsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMonthView(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-dashboard-view")) {
            return "PermissionError";
        }
        Connection db = null;
        CalendarBean calendarInfo = null;
        CalendarView companyCalendar = null;
        this.addModuleBean(context, "Home", "");
        String returnPage = context.getRequest().getParameter("return");
        String beanName = returnPage != null ? returnPage + "CalendarInfo" : "CalendarInfo";
        calendarInfo = (CalendarBean)context.getSession().getAttribute(beanName);
        if (calendarInfo == null) {
            calendarInfo = new CalendarBean(this.getUser(context, this.getUserId(context)).getLocale());
            context.getSession().setAttribute(beanName, (Object)calendarInfo);
        }
        try {
            db = this.getConnection(context);
            calendarInfo.update(db, context);
            int userId = this.getUserId(context);
            User thisUser = this.getUser(context, userId);
            companyCalendar = new CalendarView(calendarInfo, thisUser.getLocale());
            companyCalendar.setSystemStatus(this.getSystemStatus(context));
            if (context.getRequest().getParameter("userId") != null) {
                userId = Integer.parseInt(context.getRequest().getParameter("userId"));
                if (userId == this.getUserId(context)) {
                    Integer tmpUserId = (Integer)context.getSession().getAttribute("calendarUserId");
                    if (tmpUserId != null) {
                        context.getSession().removeAttribute("calendarUserId");
                    }
                } else {
                    context.getSession().setAttribute("calendarUserId", (Object)new Integer(userId));
                }
            } else if (context.getSession().getAttribute("calendarUserId") != null) {
                userId = (Integer)context.getSession().getAttribute("calendarUserId");
            }
            if (thisUser.getExpires() != null) {
                String expiryDate = DateUtils.getServerToUserDateString(this.getUserTimeZone(context), 3, thisUser.getExpires());
                companyCalendar.addEventCount(CalendarEventList.EVENT_TYPES[9], expiryDate, new Integer(1));
            }
            User selectedUser = new User();
            selectedUser.setBuildContact(true);
            selectedUser.buildRecord(db, userId);
            context.getRequest().setAttribute("SelectedUser", (Object)selectedUser);
            String param1 = "org.aspcfs.utils.web.CalendarView";
            String param2 = "java.sql.Connection";
            ArrayList alertTypes = calendarInfo.getAlertTypes();
            for (int i = 0; i < alertTypes.size(); ++i) {
                AlertType thisAlert = (AlertType)alertTypes.get(i);
                Object thisInstance = Class.forName(thisAlert.getClassName()).newInstance();
                Method method = Class.forName(thisAlert.getClassName()).getMethod("setModule", Class.forName("org.aspcfs.modules.actions.CFSModule"));
                method.invoke(thisInstance, this);
                method = Class.forName(thisAlert.getClassName()).getMethod("setContext", Class.forName("com.darkhorseventures.framework.actions.ActionContext"));
                method.invoke(thisInstance, context);
                method = Class.forName(thisAlert.getClassName()).getMethod("setUserId", Class.forName("java.lang.String"));
                method.invoke(thisInstance, String.valueOf(userId));
                Timestamp startDate = DatabaseUtils.parseTimestamp(DateUtils.getUserToServerDateTimeString(calendarInfo.getTimeZone(), 3, 1, companyCalendar.getCalendarStartDate(context), Locale.US));
                method = Class.forName(thisAlert.getClassName()).getMethod("setAlertRangeStart", Class.forName("java.sql.Timestamp"));
                method.invoke(thisInstance, startDate);
                Timestamp endDate = DatabaseUtils.parseTimestamp(DateUtils.getUserToServerDateTimeString(calendarInfo.getTimeZone(), 3, 1, companyCalendar.getCalendarEndDate(context), Locale.US));
                method = Class.forName(thisAlert.getClassName()).getMethod("setAlertRangeEnd", Class.forName("java.sql.Timestamp"));
                method.invoke(thisInstance, endDate);
                method = Class.forName(thisAlert.getClassName()).getMethod("buildAlertCount", Class.forName(param1), Class.forName(param2));
                method.invoke(thisInstance, companyCalendar, db);
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("CompanyCalendar", (Object)companyCalendar);
        return "CalendarOK";
    }

    public String executeCommandDayView(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-dashboard-view")) {
            return "PermissionError";
        }
        CalendarBean calendarInfo = null;
        this.addModuleBean(context, "Home", "");
        String returnPage = context.getRequest().getParameter("return");
        calendarInfo = (CalendarBean)context.getSession().getAttribute(returnPage != null ? returnPage + "CalendarInfo" : "CalendarInfo");
        calendarInfo.setCalendarView("day");
        calendarInfo.resetParams("day");
        return this.executeCommandAlerts(context);
    }

    public String executeCommandTodaysView(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-dashboard-view")) {
            return "PermissionError";
        }
        CalendarBean calendarInfo = null;
        this.addModuleBean(context, "Home", "");
        String returnPage = context.getRequest().getParameter("return");
        calendarInfo = (CalendarBean)context.getSession().getAttribute(returnPage != null ? returnPage + "CalendarInfo" : "CalendarInfo");
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(calendarInfo.getTimeZone());
        calendarInfo.setCalendarView("day");
        calendarInfo.resetParams("day");
        calendarInfo.setPrimaryMonth(cal.get(2) + 1);
        calendarInfo.setPrimaryYear(cal.get(1));
        return this.executeCommandAlerts(context);
    }

    public String executeCommandWeekView(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-profile-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Home", "");
        CalendarBean calendarInfo = null;
        String returnPage = context.getRequest().getParameter("return");
        calendarInfo = (CalendarBean)context.getSession().getAttribute(returnPage != null ? returnPage + "CalendarInfo" : "CalendarInfo");
        calendarInfo.setCalendarView("week");
        calendarInfo.resetParams("week");
        return this.executeCommandAlerts(context);
    }

    public String executeCommandAgendaView(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-dashboard-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Home", "");
        CalendarBean calendarInfo = null;
        String returnPage = context.getRequest().getParameter("return");
        calendarInfo = (CalendarBean)context.getSession().getAttribute(returnPage != null ? returnPage + "CalendarInfo" : "CalendarInfo");
        calendarInfo.setAgendaView(true);
        calendarInfo.resetParams("agenda");
        return this.executeCommandAlerts(context);
    }

    public String executeCommandMyProfile(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-profile-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "MyProfile", "");
        return "MyProfileOK";
    }

    public String executeCommandMyCFSProfile(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-profile-personal-view")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
            User thisUser = new User(db, this.getUserId(context));
            thisUser.setBuildContact(true);
            thisUser.setBuildContactDetails(true);
            thisUser.buildResources(db);
            ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
            StateSelect stateSelect = new StateSelect(systemStatus, thisUser.getContact().getAddressList().getCountries() + "," + prefs.get("SYSTEM.COUNTRY"));
            stateSelect.setPreviousStates(thisUser.getContact().getAddressList().getSelectedStatesHashMap());
            context.getRequest().setAttribute("StateSelect", (Object)stateSelect);
            this.buildFormElements(context, db);
            context.getRequest().setAttribute("User", (Object)thisUser);
            context.getRequest().setAttribute("EmployeeBean", (Object)thisUser.getContact());
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            return "SystemError";
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "MyProfile", "");
        return "ProfileOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateProfile(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-profile-personal-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        int resultCount = -1;
        boolean isValid = false;
        Contact thisContact = (Contact)((Object)context.getFormBean());
        thisContact.setRequestItems(context);
        thisContact.setEnteredBy(this.getUserId(context));
        thisContact.setModifiedBy(this.getUserId(context));
        try {
            db = this.getConnection(context);
            isValid = this.validateObject(context, db, (Object)thisContact);
            if (isValid) {
                resultCount = thisContact.update(db);
            }
            if (resultCount == -1 || !isValid) {
                this.buildFormElements(context, db);
            } else {
                thisContact.checkUserAccount(db);
                this.updateUserContact(db, context, thisContact.getUserId());
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (resultCount == 1) {
            return "UpdateProfileOK";
        }
        if (resultCount == -1 || !isValid) {
            return this.executeCommandMyCFSProfile(context);
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    public String executeCommandMyCFSPassword(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-profile-password-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            User thisUser = new User(db, this.getUserId(context));
            thisUser.setBuildContact(false);
            thisUser.buildResources(db);
            context.getRequest().setAttribute("User", (Object)thisUser);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            return "SystemError";
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "MyProfile", "");
        return "PasswordOK";
    }

    public String executeCommandMyCFSWebdav(ActionContext context) {
        Connection db = null;
        try {
            db = this.getConnection(context);
            User thisUser = new User(db, this.getUserId(context));
            thisUser.setBuildContact(false);
            thisUser.buildResources(db);
            context.getRequest().setAttribute("User", (Object)thisUser);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            return "SystemError";
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "MyProfile", "");
        return "WebdavOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdatePassword(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-profile-password-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        int resultCount = 0;
        User tempUser = (User)((Object)context.getFormBean());
        try {
            db = this.getConnection(context);
            User thisUser = new User(db, this.getUserId(context));
            thisUser.setBuildContact(false);
            thisUser.buildResources(db);
            tempUser.setUsername(thisUser.getUsername());
            resultCount = tempUser.updatePassword(db, context, thisUser.getPassword());
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (resultCount == -1) {
            this.processErrors(context, tempUser.getErrors());
            context.getRequest().setAttribute("NewUser", (Object)tempUser);
        }
        if (resultCount == -1) {
            return this.executeCommandMyCFSPassword(context);
        }
        if (resultCount == 1) {
            return "UpdatePasswordOK";
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    public String executeCommandMyCFSSettings(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-profile-view")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            User thisUser = new User(db, this.getUserId(context));
            thisUser.setBuildContact(true);
            thisUser.buildResources(db);
            context.getRequest().setAttribute("User", (Object)thisUser);
            context.getRequest().setAttribute("EmployeeBean", (Object)thisUser.getContact());
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            return "SystemError";
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "MyProfile", "");
        return "SettingsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateSettings(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-profile-view")) {
            return "PermissionError";
        }
        String timeZone = context.getRequest().getParameter("timeZone");
        Connection db = null;
        try {
            db = this.getConnection(context);
            this.getUser(context, this.getUserId(context)).setTimeZone(timeZone);
            this.getUser(context, this.getUserId(context)).updateSettings(db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "UpdateSettingsOK";
    }

    protected void buildFormElements(ActionContext context, Connection db) throws SQLException {
        SystemStatus systemStatus = this.getSystemStatus(context);
        LookupList departmentList = new LookupList(db, "lookup_department");
        departmentList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("DepartmentList", (Object)departmentList);
        LookupList phoneTypeList = new LookupList(db, "lookup_contactphone_types");
        context.getRequest().setAttribute("ContactPhoneTypeList", (Object)phoneTypeList);
        LookupList emailTypeList = new LookupList(db, "lookup_contactemail_types");
        context.getRequest().setAttribute("ContactEmailTypeList", (Object)emailTypeList);
        LookupList addressTypeList = new LookupList(db, "lookup_contactaddress_types");
        context.getRequest().setAttribute("ContactAddressTypeList", (Object)addressTypeList);
        StateSelect stateSelect = (StateSelect)context.getRequest().getAttribute("StateSelect");
        if (stateSelect == null) {
            stateSelect = new StateSelect(systemStatus);
            context.getRequest().setAttribute("StateSelect", (Object)stateSelect);
        }
        CountrySelect countrySelect = new CountrySelect(systemStatus);
        context.getRequest().setAttribute("CountrySelect", (Object)countrySelect);
    }
}

