/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.mycfs.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actionlist.base.ActionItemLog;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactHistory;
import org.aspcfs.utils.DatabaseUtils;

public class CFSNote
extends GenericBean {
    public static final int CALL = 1;
    public static final int NEW = 0;
    public static final int READ = 1;
    public static final int OLD = 2;
    public static final int DELETE = 3;
    public static final int SENDER = 1;
    public static final int RECIPIENT = 2;
    public String sentToList = "";
    private int id = -1;
    private String subject = "";
    private String body = "";
    private int replyId = -1;
    private int sentTo = -1;
    private int status = 0;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private Timestamp viewed = null;
    private Timestamp sent = null;
    private boolean enabled = true;
    private String sentName = "";
    private int type = -1;
    private boolean deleteFlag = false;
    private String currentView = "none";
    private Timestamp entered = null;
    private Timestamp modified = null;
    protected HashMap recipientList;
    private int actionId = -1;

    public CFSNote() {
    }

    public CFSNote(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public CFSNote(Connection db, int noteId) throws SQLException {
        this.queryRecord(db, noteId);
    }

    public CFSNote(Connection db, String noteId, int myId, String listView) throws SQLException {
        this.queryRecord(db, Integer.parseInt(noteId), myId, listView);
    }

    public CFSNote(Connection db, int noteId, int myId, String listView) throws SQLException {
        this.queryRecord(db, noteId, myId, listView);
    }

    private void queryRecord(Connection db, int noteId, int myId, String listView) throws SQLException {
        if (noteId == -1) {
            throw new SQLException("CFS Note ID not specified");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT m.*, ml.id AS ml_id, ml.sent_to, ml.status, ml.viewed, ml.enabled, ml.sent_from, ct_sent.namefirst AS sent_namefirst, ct_sent.namelast AS sent_namelast FROM cfsinbox_messagelink ml, cfsinbox_message m LEFT JOIN contact ct_eb ON (m.enteredby = ct_eb.user_id) LEFT JOIN contact ct_mb ON (m.modifiedby = ct_mb.user_id) LEFT JOIN contact ct_sent ON (m.enteredby = ct_sent.user_id) WHERE m.id > -1 AND (m.id = ml.id) AND m.id = ? ");
        if (listView.equalsIgnoreCase("sent")) {
            sql.append("AND ml.sent_from = ? ");
        } else {
            sql.append("AND ml.sent_to = ? ");
        }
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(1, noteId);
        pst.setInt(2, myId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
    }

    private void queryRecord(Connection db, int noteId) throws SQLException {
        if (noteId == -1) {
            throw new SQLException("CFS Note ID not specified");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT m.* FROM cfsinbox_message m WHERE m.id = ? ");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(1, noteId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildBaseRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
    }

    private void buildBaseRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("id"));
        this.subject = rs.getString("subject");
        this.body = rs.getString("body");
        this.replyId = rs.getInt("reply_id");
        this.enteredBy = rs.getInt("enteredby");
        this.sent = rs.getTimestamp("sent");
        this.entered = rs.getTimestamp("entered");
        this.modified = rs.getTimestamp("modified");
        this.type = rs.getInt("type");
        this.modifiedBy = rs.getInt("modifiedby");
        this.deleteFlag = rs.getBoolean("delete_flag");
    }

    public void setSentName(String sentName) {
        this.sentName = sentName;
    }

    public void setSent(String tmp) {
        this.sent = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setDeleteFlag(String tmp) {
        this.deleteFlag = DatabaseUtils.parseBoolean(tmp);
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setType(String type) {
        this.type = Integer.parseInt(type);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        Date tmpDate = new Date();
        this.modified = new Timestamp(tmpDate.getTime());
        this.modified = Timestamp.valueOf(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setSubject(String tmp) {
        this.subject = tmp;
    }

    public void setBody(String tmp) {
        this.body = tmp;
    }

    public void setReplyId(int tmp) {
        this.replyId = tmp;
    }

    public void setReplyId(String tmp) {
        this.replyId = Integer.parseInt(tmp);
    }

    public void setStatus(int tmp) {
        this.status = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setViewed(Timestamp tmp) {
        this.viewed = tmp;
    }

    public void setSent(Timestamp tmp) {
        this.sent = tmp;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setSentTo(int sentTo) {
        this.sentTo = sentTo;
    }

    public void setSentTo(String sentTo) {
        this.sentTo = Integer.parseInt(sentTo);
    }

    public void setDeleteFlag(boolean deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    public void setCurrentView(String currentView) {
        this.currentView = currentView;
    }

    public void setActionId(int actionId) {
        this.actionId = actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = Integer.parseInt(actionId);
    }

    public int getActionId() {
        return this.actionId;
    }

    public HashMap getRecipientList() {
        return this.recipientList;
    }

    public HashMap buildRecipientList(Connection db) throws SQLException {
        this.sentToList = "";
        HashMap<String, Integer> recipients = new HashMap<String, Integer>();
        try {
            if (this.id != -1) {
                PreparedStatement pst = db.prepareStatement("SELECT ct_eb.namefirst as sent_namefirst, ct_eb.namelast as sent_namelast, ct_eb.company AS sent_company,ml.status FROM cfsinbox_messagelink ml LEFT JOIN contact ct_eb ON (ml.sent_to = ct_eb.contact_id) WHERE ml.id > -1 AND ml.id = ? ");
                pst.setInt(1, this.getId());
                ResultSet rs = pst.executeQuery();
                while (rs.next()) {
                    String recipient = Contact.getNameFirstLastOrCompany(rs.getString("sent_namefirst"), rs.getString("sent_namelast"), rs.getString("sent_company"));
                    Integer status = new Integer(rs.getInt("status"));
                    recipients.put(recipient, status);
                }
                rs.close();
                pst.close();
            }
            this.recipientList = recipients;
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        return recipients;
    }

    public String getSentName() {
        return this.sentName;
    }

    public String getStatusText(SystemStatus systemStatus) {
        if (this.status == 0) {
            return systemStatus.getLabel("note.unread", "Unread");
        }
        if (this.status == 1) {
            return systemStatus.getLabel("note.read", "Read");
        }
        if (this.status == 2) {
            return systemStatus.getLabel("note.archived", "Archived");
        }
        return systemStatus.getLabel("note.deleted", "Deleted");
    }

    public String getStatusColor(int noteStatus) {
        if (noteStatus == 0) {
            return "red";
        }
        if (noteStatus == 1) {
            return "blue";
        }
        if (noteStatus == 2) {
            return "orange";
        }
        return "green";
    }

    public String getStatusText(int noteStatus) {
        if (noteStatus == 0) {
            return "Unread";
        }
        if (noteStatus == 1) {
            return "Read";
        }
        if (noteStatus == 2) {
            return "Archived";
        }
        return "Deleted";
    }

    public int getType() {
        return this.type;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public String getEnteredString() {
        try {
            return DateFormat.getDateInstance(3).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getEnteredDateTimeString() {
        try {
            return DateFormat.getDateTimeInstance(3, 3).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public int getId() {
        return this.id;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    public int getReplyId() {
        return this.replyId;
    }

    public int getStatus() {
        return this.status;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getViewed() {
        return this.viewed;
    }

    public Timestamp getSent() {
        return this.sent;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getSentTo() {
        return this.sentTo;
    }

    public String getModified() {
        return this.modified.toString();
    }

    public String getModifiedString() {
        try {
            return DateFormat.getDateInstance(3).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getModifiedDateTimeString() {
        try {
            return DateFormat.getDateTimeInstance(3, 3).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public boolean getDeleteFlag() {
        return this.deleteFlag;
    }

    public String getCurrentView() {
        return this.currentView;
    }

    public boolean insert(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            this.id = DatabaseUtils.getNextSeq(db, "cfsinbox_message_id_seq");
            sql.append("INSERT INTO cfsinbox_message (" + (this.id > -1 ? "id, " : "") + "enteredby, modifiedby, body, reply_id, " + DatabaseUtils.addQuotes(db, "type") + ", delete_flag) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.getEnteredBy());
            pst.setInt(++i, this.getModifiedBy());
            pst.setString(++i, this.getBody());
            pst.setInt(++i, this.getReplyId());
            pst.setInt(++i, this.getType());
            pst.setBoolean(++i, this.getDeleteFlag());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "cfsinbox_message_id_seq", this.id);
            this.update(db, true);
            if (this.actionId > 0) {
                this.updateLog(db);
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public boolean updateLog(Connection db) throws SQLException {
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            ActionItemLog thisLog = new ActionItemLog();
            thisLog.setEnteredBy(this.getEnteredBy());
            thisLog.setModifiedBy(this.getModifiedBy());
            thisLog.setItemId(this.getActionId());
            thisLog.setLinkItemId(this.getId());
            thisLog.setType(42420035);
            thisLog.insert(db);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public boolean insertLink(Connection db, boolean isUser) throws SQLException {
        try {
            int i = 0;
            PreparedStatement pst = db.prepareStatement("INSERT INTO cfsinbox_messagelink (id, sent_to, sent_from) VALUES (?, ?, ?) ");
            pst.setInt(++i, this.getId());
            pst.setInt(++i, this.getSentTo());
            pst.setInt(++i, this.getEnteredBy());
            pst.execute();
            pst.close();
            if (!isUser) {
                pst = db.prepareStatement("UPDATE cfsinbox_messagelink SET status = 3 WHERE  id = ? AND sent_to = ? ");
                pst.setInt(1, this.getId());
                pst.setInt(2, this.getSentTo());
                pst.execute();
                pst.close();
            }
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = -1;
        try {
            db.setAutoCommit(false);
            resultCount = this.update(db, false);
            db.commit();
        }
        catch (Exception e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return resultCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(Connection db, int myId) throws SQLException {
        try {
            PreparedStatement pst = null;
            ResultSet rs = null;
            int inboxCount = -1;
            int outboxCount = -1;
            String outboxQuery = "SELECT count(*) as outboxcount FROM cfsinbox_message WHERE id = ? AND delete_flag = ? ";
            String inboxQuery = "SELECT count(*) as inboxcount FROM cfsinbox_messagelink WHERE id =" + this.getId() + " " + "AND status <> 3 ";
            db.setAutoCommit(false);
            pst = db.prepareStatement(outboxQuery);
            pst.setInt(1, this.getId());
            pst.setBoolean(2, false);
            rs = pst.executeQuery();
            if (rs.next()) {
                outboxCount = rs.getInt("outboxcount");
            }
            rs.close();
            pst.close();
            pst = db.prepareStatement(inboxQuery);
            rs = pst.executeQuery();
            if (rs.next()) {
                inboxCount = rs.getInt("inboxcount");
            }
            rs.close();
            pst.close();
            ContactHistory.deleteObject(db, 14, this.getId());
            if (outboxCount == 0 && inboxCount == 1 || outboxCount == 1 && inboxCount == 0) {
                pst = db.prepareStatement("DELETE FROM cfsinbox_messagelink WHERE id = ? ");
                pst.setInt(1, this.getId());
                pst.execute();
                pst.close();
                pst = db.prepareStatement("DELETE FROM cfsinbox_message WHERE id = ? ");
                pst.setInt(1, this.getId());
                pst.execute();
                pst.close();
            } else if (!this.getCurrentView().equalsIgnoreCase("sent")) {
                pst = db.prepareStatement("UPDATE cfsinbox_messagelink SET status = ? WHERE  id = ? AND sent_to = ? ");
                pst.setInt(1, 3);
                pst.setInt(2, this.getId());
                pst.setInt(3, myId);
                pst.executeUpdate();
                pst.close();
            } else {
                pst = db.prepareStatement("UPDATE cfsinbox_message SET delete_flag = ? WHERE  id = ? ");
                pst.setBoolean(1, true);
                pst.setInt(2, this.getId());
                pst.executeUpdate();
                pst.close();
            }
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            if (System.getProperty("DEBUG") != null) {
                System.out.println("CFSNote-> " + e.toString());
                throw new SQLException(e.getMessage());
            }
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    public int updateStatus(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            throw new SQLException("CFS Note ID was not specified");
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE cfsinbox_messagelink SET status = ?, viewed = CURRENT_TIMESTAMP WHERE id = ? AND sent_to = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, this.getStatus());
        pst.setInt(++i, this.getId());
        pst.setInt(++i, this.getSentTo());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    protected int update(Connection db, boolean override) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            throw new SQLException("CFS Note ID was not specified");
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE cfsinbox_message SET subject = ?, body = ?, modified = CURRENT_TIMESTAMP, modifiedby = ? WHERE id = ? ");
        if (!override) {
            sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        }
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.getSubject());
        pst.setString(++i, this.getBody());
        pst.setInt(++i, this.getModifiedBy());
        pst.setInt(++i, this.getId());
        if (!override && this.getModified() != null) {
            pst.setTimestamp(++i, this.modified);
        }
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        if (!this.getCurrentView().equalsIgnoreCase("sent")) {
            this.setId(rs.getInt("id"));
            this.subject = rs.getString("subject");
            this.body = rs.getString("body");
            this.replyId = rs.getInt("reply_id");
            this.enteredBy = rs.getInt("enteredby");
            this.sent = rs.getTimestamp("sent");
            this.entered = rs.getTimestamp("entered");
            this.modified = rs.getTimestamp("modified");
            this.type = rs.getInt("type");
            this.modifiedBy = rs.getInt("modifiedby");
            this.deleteFlag = rs.getBoolean("delete_flag");
            this.sentTo = rs.getInt("sent_to");
            this.status = rs.getInt("status");
            this.viewed = rs.getTimestamp("viewed");
            this.sentName = rs.getString("sent_namefirst") + " " + rs.getString("sent_namelast");
        } else {
            this.setId(rs.getInt("id"));
            this.subject = rs.getString("subject");
            this.body = rs.getString("body");
            this.entered = rs.getTimestamp("sent");
            this.deleteFlag = rs.getBoolean("delete_flag");
        }
    }
}

