/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.mycfs.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import org.aspcfs.modules.mycfs.base.CFSNote;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class CFSNoteList
extends Vector {
    public static final String tableName = "cfsinbox_message";
    public static final String uniqueField = "id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int sentTo = -1;
    private int sentFrom = -1;
    private boolean oldMessagesOnly = false;
    private boolean sentMessagesOnly = false;
    private boolean newMessagesOnly = false;
    private boolean buildAll = false;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void setNewMessagesOnly(boolean newMessagesOnly) {
        this.newMessagesOnly = newMessagesOnly;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setSentTo(int sentTo) {
        this.sentTo = sentTo;
    }

    public void setSentFrom(int sentFrom) {
        this.sentFrom = sentFrom;
    }

    public void setOldMessagesOnly(boolean oldMessagesOnly) {
        this.oldMessagesOnly = oldMessagesOnly;
    }

    public void setSentMessagesOnly(boolean sentMessagesOnly) {
        this.sentMessagesOnly = sentMessagesOnly;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getSentTo() {
        return this.sentTo;
    }

    public int getSentFrom() {
        return this.sentFrom;
    }

    public boolean getOldMessagesOnly() {
        return this.oldMessagesOnly;
    }

    public boolean getBuildAll() {
        return this.buildAll;
    }

    public void setBuildAll(boolean tmp) {
        this.buildAll = tmp;
    }

    public void setBuildAll(String tmp) {
        this.buildAll = DatabaseUtils.parseBoolean(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        if (this.sentMessagesOnly) {
            sqlCount.append("SELECT COUNT(*) AS recordcount FROM cfsinbox_message m WHERE m.id > -1 ");
        } else {
            sqlCount.append("SELECT COUNT(*) AS recordcount FROM cfsinbox_messagelink ml,cfsinbox_message m LEFT JOIN contact ct_eb ON (m.enteredby = ct_eb.user_id) LEFT JOIN contact ct_mb ON (m.modifiedby = ct_mb.user_id) LEFT JOIN contact ct_sent ON (m.enteredby = ct_sent.user_id) WHERE m.id > -1 AND (m.id = ml.id) ");
        }
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND subject < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("m.entered", "desc");
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY m.entered desc ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        if (this.sentMessagesOnly) {
            sqlSelect.append("m.id, m.subject, m.body, m.sent, m.delete_flag FROM cfsinbox_message m WHERE m.id > -1 ");
        } else {
            sqlSelect.append("m.*, ml.id AS ml_id, ml.sent_to, ml.status, ml.viewed, ml.enabled, ml.sent_from, ct_sent.namefirst AS sent_namefirst, ct_sent.namelast AS sent_namelast FROM cfsinbox_messagelink ml, cfsinbox_message m LEFT JOIN contact ct_eb ON (m.enteredby = ct_eb.user_id) LEFT JOIN contact ct_mb ON (m.modifiedby = ct_mb.user_id) LEFT JOIN contact ct_sent ON (m.enteredby = ct_sent.user_id) WHERE m.id > -1 AND (m.id = ml.id) ");
        }
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            CFSNote thisNote = new CFSNote();
            if (this.pagedListInfo != null) {
                thisNote.setCurrentView(this.pagedListInfo.getListView());
            }
            thisNote.buildRecord(rs);
            this.addElement(thisNote);
        }
        rs.close();
        pst.close();
        for (CFSNote thisNote : this) {
            thisNote.buildRecipientList(db);
        }
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.sentMessagesOnly) {
            sqlFilter.append("AND m.delete_flag = ? ");
        }
        if (this.buildAll) {
            return;
        }
        if (this.sentTo > -1 && !this.sentMessagesOnly) {
            sqlFilter.append("AND ml.sent_to = ? ");
        } else {
            sqlFilter.append("AND m.enteredby = ? ");
        }
        if (this.oldMessagesOnly) {
            sqlFilter.append("AND ml.status = 2 ");
        } else if (this.newMessagesOnly) {
            sqlFilter.append("AND ml.status IN (0) ");
        } else if (!this.sentMessagesOnly) {
            sqlFilter.append("AND ml.status IN (0,1) ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.sentMessagesOnly) {
            pst.setBoolean(++i, false);
        }
        if (this.buildAll) {
            return i;
        }
        if (this.sentTo > -1 && !this.sentMessagesOnly) {
            pst.setInt(++i, this.sentTo);
        } else {
            pst.setInt(++i, this.sentFrom);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }
}

