/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.mycfs.base;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.StringTokenizer;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.utils.StringUtils;

public class CalendarEvent
implements Comparable {
    protected String subject = "";
    protected String location = "";
    protected String category = "";
    protected String icon = "";
    protected int id = -1;
    protected int idsub = -1;
    protected String details = "";
    protected String HTMLClass = "";
    protected String link = "";
    protected int status = -1;
    protected String month = "";
    protected String day = "";
    protected String year = "";
    protected String time = "00:00";
    protected int repeatType = 0;
    protected ArrayList invites = null;
    protected ArrayList reminders = null;
    protected String comments = "";
    private Comparator eventComparator = new comparatorEvent();
    private ArrayList relatedLinks = null;

    public void setDate(Timestamp eventDate) {
        SimpleDateFormat shortDateFormat;
        String eventDateString;
        StringTokenizer st;
        if (eventDate != null && (st = new StringTokenizer(eventDateString = (shortDateFormat = new SimpleDateFormat("M/d/yyyy")).format(eventDate), "/")).hasMoreTokens()) {
            this.setMonth(st.nextToken());
            this.setDay(st.nextToken());
            this.setYear(st.nextToken());
        }
    }

    public void setMonth(String tmp) {
        this.month = tmp;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setIdsub(int idsub) {
        this.idsub = idsub;
    }

    public void setDay(String tmp) {
        this.day = tmp;
    }

    public void setYear(String tmp) {
        this.year = tmp;
    }

    public void setTime(String tmp) {
        this.time = this.time != null && !this.time.equals("") ? tmp : "00:00";
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setLink(String tmp) {
        this.link = tmp;
    }

    public void setSubject(String tmp) {
        this.subject = tmp;
    }

    public void setCategory(String tmp) {
        this.category = tmp;
    }

    public void setHTMLClass(String tmp) {
        this.HTMLClass = tmp;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setRelatedLinks(ArrayList relatedLinks) {
        this.relatedLinks = relatedLinks;
    }

    public void addRelatedLink(String link) {
        if (this.relatedLinks == null) {
            this.relatedLinks = new ArrayList();
        }
        this.relatedLinks.add(link);
    }

    public ArrayList getRelatedLinks() {
        return this.relatedLinks;
    }

    public int getStatus() {
        return this.status;
    }

    public int getIdsub() {
        return this.idsub;
    }

    public int getId() {
        return this.id;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getCategory() {
        return this.category;
    }

    public static String getIcon(String thisCategory, SystemStatus systemStatus) {
        if (thisCategory.equals("event")) {
            return "<img border=\"0\" src=\"images/event-timed.gif\" align=\"texttop\" width=\"12\" height=\"12\" title=\"" + CalendarEvent.getLabel("calendar.Event", systemStatus, "Event") + "\" />";
        }
        if (thisCategory.equalsIgnoreCase("holiday")) {
            return "<img border=\"0\" src=\"images/event-star12.gif\" align=\"texttop\" width=\"12\" height=\"12\" title=\"" + CalendarEvent.getLabel("calendar.Holiday", systemStatus, "Holiday") + "\" />";
        }
        if (thisCategory.equalsIgnoreCase("System Alerts")) {
            return "<img border=\"0\" src=\"images/box-hold.gif\" align=\"texttop\" width=\"16\" height=\"15\" title=\"" + CalendarEvent.getLabel("calendar.UserAccountExpires", systemStatus, "User Account Expires") + "\" />";
        }
        if (thisCategory.equalsIgnoreCase("Opportunity") || thisCategory.equalsIgnoreCase("Opportunities")) {
            return "<img border=\"0\" src=\"images/alertopp.gif\" align=\"texttop\" title=\"" + CalendarEvent.getLabel("calendar.Opportunities", systemStatus, "Opportunities") + "\" />";
        }
        if (thisCategory.equalsIgnoreCase("Activities") || thisCategory.equalsIgnoreCase("Contact Activities") || thisCategory.equalsIgnoreCase("Opportunity Activities")) {
            return "<img border=\"0\" src=\"images/alertcall.gif\" align=\"texttop\" title=\"" + CalendarEvent.getLabel("calendar.Activities", systemStatus, "Activities") + "\" />";
        }
        if (thisCategory.equalsIgnoreCase("Pending Activities")) {
            return "<img border=\"0\" src=\"images/box-hold.gif\" align=\"texttop\" title=\"" + CalendarEvent.getLabel("calendar.PendingActivities", systemStatus, "Pending Activities") + "\" />";
        }
        if (thisCategory.equalsIgnoreCase("Assignments")) {
            return "<img border=\"0\" src=\"images/alertassignment.gif\" align=\"texttop\" title=\"" + CalendarEvent.getLabel("calendar.Assignments", systemStatus, "Assignments") + "\" />";
        }
        if (thisCategory.equalsIgnoreCase("Account Alerts") || thisCategory.equalsIgnoreCase("Account Contract Alerts")) {
            return "<img border=\"0\" src=\"images/accounts.gif\" width=\"14\" height=\"14\" align=\"texttop\" title=\"" + CalendarEvent.getLabel("calendar.Accounts", systemStatus, "Accounts") + "\" />";
        }
        if (thisCategory.equalsIgnoreCase("Tasks")) {
            return "<img src=\"images/box.gif\" border=\"0\" align=\"texttop\" width=\"14\" height=\"14\" title=\"" + CalendarEvent.getLabel("calendar.Tasks", systemStatus, "Tasks") + "\" />";
        }
        if (thisCategory.equalsIgnoreCase("Ticket Requests")) {
            return "<img src=\"images/tree0.gif\" border=\"0\" align=\"texttop\" title=\"" + CalendarEvent.getLabel("calendar.Tickets", systemStatus, "Tickets") + "\" />";
        }
        if (thisCategory.equalsIgnoreCase("Project Tickets")) {
            return "<img src=\"images/tree1.gif\" border=\"0\" align=\"texttop\" title=\"" + CalendarEvent.getLabel("calendar.projectTickets", systemStatus, "Project Tickets") + "\" />";
        }
        return "";
    }

    public String getDateTimeString() {
        return this.year + "-" + this.month + "-" + this.day + " " + this.time;
    }

    public String getDateString() {
        return this.month + "/" + this.day + "/" + this.year;
    }

    public boolean isHoliday() {
        return "holiday".equalsIgnoreCase(this.category);
    }

    public static String getLabel(String label, SystemStatus systemStatus, String defaultValue) {
        String value;
        if (systemStatus != null && (value = systemStatus.getLabel(label)) != null) {
            return StringUtils.toHtml(value);
        }
        return StringUtils.toHtml(defaultValue);
    }

    public String toString() {
        return this.month + "/" + this.day + "/" + this.year + ": " + this.category;
    }

    public int compareTo(Object object) {
        return this.eventComparator.compare(this, object);
    }

    public int compareDateTo(Object object) {
        return this.eventComparator.compare(this, object);
    }

    class comparatorEvent
    implements Comparator {
        comparatorEvent() {
        }

        public int compare(Object left, Object right) {
            return ((CalendarEvent)left).getDateTimeString().compareTo(((CalendarEvent)right).getDateTimeString());
        }
    }
}

