/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.mycfs.beans;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.modules.mycfs.base.AlertType;

public class CalendarBean {
    private String calendarDetailsView = "all";
    private String calendarView = "";
    Calendar cal = null;
    private int primaryMonth = -1;
    private int monthSelected = -1;
    private int primaryYear = -1;
    private int yearSelected = -1;
    private int daySelected = -1;
    private int startMonthOfWeek = -1;
    private int startDayOfWeek = -1;
    private int selectedUserId = -1;
    private String selectedUserName = "";
    private boolean agendaView = true;
    private ArrayList alertTypes = new ArrayList();
    private TimeZone timeZone = null;

    public CalendarBean() {
    }

    public CalendarBean(Locale locale) {
        this.cal = Calendar.getInstance(locale);
        this.primaryMonth = this.cal.get(2) + 1;
        this.monthSelected = this.cal.get(2) + 1;
        this.primaryYear = this.cal.get(1);
        this.yearSelected = this.cal.get(1);
    }

    public void setCalendarDetailsView(String calendarDetailsView) {
        this.calendarDetailsView = calendarDetailsView;
    }

    public void setDaySelected(int daySelected) {
        this.daySelected = daySelected;
    }

    public void setCalendarView(String calendarView) {
        this.calendarView = calendarView;
    }

    public void setSelectedUserId(int selectedUserId) {
        this.selectedUserId = selectedUserId;
    }

    public void setSelectedUserName(String selectedUserName) {
        this.selectedUserName = selectedUserName;
    }

    public void setPrimaryYear(int primaryYear) {
        this.primaryYear = primaryYear;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public int getPrimaryYear() {
        return this.primaryYear;
    }

    public void setMonthSelected(int monthSelected) {
        this.monthSelected = monthSelected;
    }

    public void setYearSelected(int yearSelected) {
        this.yearSelected = yearSelected;
    }

    public void setStartMonthOfWeek(int startMonthOfWeek) {
        this.startMonthOfWeek = startMonthOfWeek;
    }

    public void setStartDayOfWeek(int startDayOfWeek) {
        this.startDayOfWeek = startDayOfWeek;
    }

    public void setAgendaView(boolean agendaView) {
        this.agendaView = agendaView;
    }

    public void setSelectedUserName(Connection db) throws SQLException {
        int thisContactId = new User(db, this.selectedUserId).getContactId();
        Contact thisContact = new Contact(db, thisContactId);
        this.setSelectedUserName(thisContact.getNameLastFirst());
    }

    public String getSelectedUserName() {
        return this.selectedUserName;
    }

    public void setAlertTypes(ArrayList alertTypes) {
        this.alertTypes = alertTypes;
    }

    public void setPrimaryMonth(int primaryMonth) {
        this.primaryMonth = primaryMonth;
    }

    public int getPrimaryMonth() {
        return this.primaryMonth;
    }

    public void addAlertType(String alert, String className, String displayName) {
        this.alertTypes.add(new AlertType(alert, className, displayName));
    }

    public ArrayList getAlertTypes() {
        return this.alertTypes;
    }

    public boolean isAgendaView() {
        return this.agendaView;
    }

    public int getStartMonthOfWeek() {
        return this.startMonthOfWeek;
    }

    public int getStartDayOfWeek() {
        return this.startDayOfWeek;
    }

    public int getMonthSelected() {
        return this.monthSelected;
    }

    public int getYearSelected() {
        return this.yearSelected;
    }

    public String getCalendarView() {
        return this.calendarView;
    }

    public int getSelectedUserId() {
        return this.selectedUserId;
    }

    public int getDaySelected() {
        return this.daySelected;
    }

    public String getCalendarDetailsView() {
        return this.calendarDetailsView;
    }

    public Date getStartOfWeekDate() {
        Calendar thisCal = Calendar.getInstance();
        thisCal.set(this.yearSelected, this.startMonthOfWeek - 1, this.startDayOfWeek);
        return thisCal.getTime();
    }

    public Date getEndOfWeekDate() {
        Calendar thisCal = Calendar.getInstance();
        thisCal.set(this.yearSelected, this.startMonthOfWeek - 1, this.startDayOfWeek);
        thisCal.add(5, 6);
        return thisCal.getTime();
    }

    public void update(Connection db, ActionContext context) throws SQLException {
        HttpServletRequest request = context.getRequest();
        UserBean thisUser = (UserBean)((Object)request.getSession().getAttribute("User"));
        String tZone = thisUser.getUserRecord().getTimeZone();
        if (tZone != null && (this.timeZone == null || this.timeZone != null && !this.timeZone.hasSameRules(TimeZone.getTimeZone(tZone)))) {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("CalendarBean-> Setting timezone to " + tZone);
            }
            this.setTimeZone(TimeZone.getTimeZone(tZone));
            this.cal.setTimeZone(this.timeZone);
            if (this.timeZone == null) {
                this.primaryMonth = this.cal.get(2) + 1;
                this.primaryYear = this.cal.get(1);
                this.monthSelected = this.cal.get(2) + 1;
                this.yearSelected = this.cal.get(1);
            }
        }
        if (request.getParameter("primaryMonth") != null) {
            this.setPrimaryMonth(Integer.parseInt(request.getParameter("primaryMonth")));
        }
        if (request.getParameter("primaryYear") != null) {
            this.setPrimaryYear(Integer.parseInt(request.getParameter("primaryYear")));
        }
        if (request.getParameter("alertsView") != null) {
            this.setCalendarDetailsView(request.getParameter("alertsView"));
        }
        if (request.getParameter("userId") != null) {
            this.setSelectedUserId(Integer.parseInt(request.getParameter("userId")));
            this.setSelectedUserName(db);
        }
        if (request.getParameter("day") != null) {
            this.setDaySelected(Integer.parseInt(request.getParameter("day")));
        }
        if (request.getParameter("month") != null) {
            this.monthSelected = Integer.parseInt(request.getParameter("month"));
        }
        if (request.getParameter("year") != null) {
            this.yearSelected = Integer.parseInt(request.getParameter("year"));
        }
        if (request.getParameter("startMonthOfWeek") != null) {
            this.startMonthOfWeek = Integer.parseInt(request.getParameter("startMonthOfWeek"));
        }
        if (request.getParameter("startDayOfWeek") != null) {
            this.startDayOfWeek = Integer.parseInt(request.getParameter("startDayOfWeek"));
        }
        if (this.getSelectedUserId() == -1) {
            this.setSelectedUserId(((UserBean)((Object)context.getSession().getAttribute("User"))).getUserId());
            this.setSelectedUserName(db);
        }
    }

    public void resetParams(String viewChanged) {
        if (viewChanged.equalsIgnoreCase("month")) {
            this.daySelected = -1;
            this.startDayOfWeek = -1;
            this.startMonthOfWeek = -1;
        }
        if (viewChanged.equalsIgnoreCase("week")) {
            this.daySelected = -1;
            this.agendaView = false;
        }
        if (viewChanged.equalsIgnoreCase("day")) {
            this.startDayOfWeek = -1;
            this.startMonthOfWeek = -1;
            this.agendaView = false;
        }
        if (viewChanged.equalsIgnoreCase("agenda")) {
            this.startDayOfWeek = -1;
            this.startMonthOfWeek = -1;
            this.daySelected = -1;
        }
    }
}

