/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.netapps.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.webutils.FileDownload;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.netapps.base.ContractExpiration;
import org.aspcfs.modules.netapps.base.ContractExpirationList;
import org.aspcfs.modules.netapps.base.ContractExpirationLogList;
import org.aspcfs.utils.JasperReportUtils;
import org.aspcfs.utils.UserUtils;
import org.aspcfs.utils.web.PagedListInfo;

public final class NetworkApplications
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        if (!this.hasPermission(context, "netapps_expiration_contracts-view")) {
            return "PermissionError";
        }
        return this.executeCommandSearchForm(context);
    }

    public String executeCommandSearchForm(ActionContext context) {
        if (!this.hasPermission(context, "netapps_expiration_contracts-view")) {
            return "PermissionError";
        }
        return NetworkApplications.getReturn(context, "SearchForm");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSearch(ActionContext context) {
        if (!this.hasPermission(context, "netapps_expiration_contracts-view")) {
            return "PermissionError";
        }
        PagedListInfo pagedListInfo = this.getPagedListInfo(context, "ExpirationContractListInfo");
        pagedListInfo.setLink("NetworkApplications.do?command=Search");
        Connection db = null;
        ContractExpirationList thisList = null;
        try {
            db = this.getConnection(context);
            thisList = new ContractExpirationList();
            thisList.setPagedListInfo(pagedListInfo);
            thisList.setExcludeUnapprovedContracts(true);
            pagedListInfo.setSearchCriteria(thisList, context);
            thisList.buildList(db);
            context.getRequest().setAttribute("ImportResults", (Object)thisList);
            context.getRequest().setAttribute("approved", (Object)"approved");
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return NetworkApplications.getReturn(context, "Search");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandList(ActionContext context) {
        if (!this.hasPermission(context, "netapps_expiration_contracts-view")) {
            return "PermissionError";
        }
        Connection db = null;
        PagedListInfo pagedListInfo = this.getPagedListInfo(context, "ExpirationContractListInfo");
        pagedListInfo.setLink("NetworkApplications.do?command=List");
        try {
            db = this.getConnection(context);
            ContractExpirationList thisList = new ContractExpirationList();
            thisList.setPagedListInfo(pagedListInfo);
            thisList.setExcludeUnapprovedContracts(true);
            thisList.buildList(db);
            context.getRequest().setAttribute("ImportResults", (Object)thisList);
            context.getRequest().setAttribute("approved", (Object)"approved");
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return NetworkApplications.getReturn(context, "List");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        if (!this.hasPermission(context, "netapps_expiration_contracts-view")) {
            return "PermissionError";
        }
        Connection db = null;
        String expirationId = context.getRequest().getParameter("expirationId");
        try {
            db = this.getConnection(context);
            ContractExpiration thisContractExpiration = new ContractExpiration(db, Integer.parseInt(expirationId));
            context.getRequest().setAttribute("contractExpiration", (Object)thisContractExpiration);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return NetworkApplications.getReturn(context, "ContractExpirationDetails");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewHistory(ActionContext context) {
        if (!this.hasPermission(context, "netapps_expiration_contracts-view")) {
            return "PermissionError";
        }
        Connection db = null;
        String expirationId = context.getRequest().getParameter("expirationId");
        PagedListInfo pagedListInfo = this.getPagedListInfo(context, "ExpirationContractHistoryListInfo");
        pagedListInfo.setLink("NetworkApplications.do?command=ViewHistory&expirationId=" + expirationId);
        try {
            db = this.getConnection(context);
            ContractExpiration thisContractExpiration = new ContractExpiration(db, Integer.parseInt(expirationId));
            context.getRequest().setAttribute("contractExpiration", (Object)thisContractExpiration);
            ContractExpirationLogList thisList = new ContractExpirationLogList();
            thisList.setPagedListInfo(pagedListInfo);
            thisList.setExpirationId(expirationId);
            thisList.buildList(context.getRequest(), db);
            context.getRequest().setAttribute("contractExpirationLogList", (Object)thisList);
            thisList.setPagedListInfo(pagedListInfo);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return NetworkApplications.getReturn(context, "ContractExpirationHistory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "netapps_expiration_contracts-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        String expirationId = context.getRequest().getParameter("expirationId");
        try {
            db = this.getConnection(context);
            ContractExpiration thisContractExpiration = new ContractExpiration(db, Integer.parseInt(expirationId));
            context.getRequest().setAttribute("contractExpiration", (Object)thisContractExpiration);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return NetworkApplications.getReturn(context, "Modify");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateQuote(ActionContext context) {
        if (!this.hasPermission(context, "netapps_expiration_contracts-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        int resultCount = 0;
        try {
            db = this.getConnection(context);
            ContractExpiration thisContractExpiration = (ContractExpiration)((Object)context.getFormBean());
            thisContractExpiration.setModifiedBy(this.getUserId(context));
            resultCount = thisContractExpiration.updateQuoteInformation(db);
            context.getRequest().setAttribute("contractExpiration", (Object)thisContractExpiration);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if ("list".equals(context.getRequest().getParameter("return"))) {
            return this.executeCommandSearch(context);
        }
        return this.executeCommandView(context);
    }

    public String executeCommandConfirmDelete(ActionContext context) {
        if (!this.hasPermission(context, "netapps_expiration_contracts-delete")) {
            return "PermissionError";
        }
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "netapps_expiration_contracts-delete")) {
            return "PermissionError";
        }
        if (!this.hasPermission(context, "netapps_expiration_contracts_imports-delete")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean recordDeleted = false;
        String expirationId = context.getRequest().getParameter("expirationId");
        try {
            db = this.getConnection(context);
            ContractExpiration thisContractExpiration = new ContractExpiration(db, Integer.parseInt(expirationId));
            if (thisContractExpiration.getStatusId() == 7 && !(recordDeleted = thisContractExpiration.delete(context.getRequest(), db))) {
                context.getRequest().setAttribute("ContractExpirationDetails", (Object)thisContractExpiration);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return NetworkApplications.getReturn(context, "Delete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPrintReport(ActionContext context) {
        block9: {
            if (!this.hasPermission(context, "netapps_expiration_contracts-view")) {
                return "PermissionError";
            }
            Connection db = null;
            try {
                db = this.getConnection(context);
                String endDateStart = context.getRequest().getParameter("endDateStart");
                String endDateEnd = context.getRequest().getParameter("endDateEnd");
                Calendar calendar = Calendar.getInstance();
                if ("".equals(endDateStart)) {
                    endDateStart = calendar.getTimeInMillis() + "";
                }
                if ("".equals(endDateEnd)) {
                    endDateEnd = calendar.getTimeInMillis() + "";
                }
                Timestamp tmpTimestampStart = new Timestamp(Long.parseLong(endDateStart));
                Timestamp tmpTimestampEnd = new Timestamp(Long.parseLong(endDateEnd));
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("date_start", tmpTimestampStart);
                map.put("date_end", tmpTimestampEnd);
                map.put("language", UserUtils.getUserLocale(context.getRequest()).getLanguage());
                map.put("country", UserUtils.getUserLocale(context.getRequest()).getCountry());
                map.put("currency", UserUtils.getUserCurrency(context.getRequest()));
                String reportPath = this.getWebInfPath(context, "reports");
                map.put("path", reportPath);
                String filename = "dataline_contract_renewal.xml";
                byte[] bytes = JasperReportUtils.getReportAsBytes(reportPath + filename, map, db);
                if (bytes != null) {
                    FileDownload fileDownload = new FileDownload();
                    fileDownload.setDisplayName("ExpirationContracts.pdf");
                    fileDownload.sendFile(context, bytes, "application/pdf");
                    break block9;
                }
                String string = "SystemError";
                return string;
            }
            catch (Exception errorMessage) {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                String string = "SystemError";
                return string;
            }
            finally {
                this.freeConnection(context, db);
            }
        }
        return "-none-";
    }
}

