/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.netapps.actions;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.framework.actions.ActionContext;
import com.isavvix.tools.FileInfo;
import com.isavvix.tools.HttpMultiPartParser;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemVersion;
import com.zeroio.webutils.FileDownload;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.aspcfs.apps.transfer.reader.mapreader.PropertyMap;
import org.aspcfs.controller.ImportManager;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.base.Import;
import org.aspcfs.modules.base.ImportList;
import org.aspcfs.modules.netapps.base.ContractExpiration;
import org.aspcfs.modules.netapps.base.ContractExpirationImport;
import org.aspcfs.modules.netapps.base.ContractExpirationImportValidate;
import org.aspcfs.modules.netapps.base.ContractExpirationList;
import org.aspcfs.utils.FileUtils;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public final class NetworkApplicationsImports
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return this.executeCommandView(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        if (!this.hasPermission(context, "netapps_expiration_contracts_imports-view")) {
            return "PermissionError";
        }
        Connection db = null;
        PagedListInfo pagedListInfo = this.getPagedListInfo(context, "NetworkApplicationsImportListInfo");
        pagedListInfo.setLink("NetworkApplicationsImports.do?command=View");
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            ImportManager manager = systemStatus.getImportManager(context);
            ImportList thisList = new ImportList();
            thisList.setType(917200409);
            thisList.setPagedListInfo(pagedListInfo);
            if ("my".equals(pagedListInfo.getListView())) {
                thisList.setEnteredIdRange(this.getUserRange(context));
            } else {
                thisList.setEnteredBy(this.getUserId(context));
            }
            thisList.setManager(manager);
            thisList.buildList(db);
            thisList.updateRecordCounts();
            context.getRequest().setAttribute("ImportList", (Object)thisList);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return NetworkApplicationsImports.getReturn(context, "View");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandNew(ActionContext context) {
        if (!this.hasPermission(context, "netapps_expiration_contracts_imports-add")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            this.buildFormElements(db, context);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return NetworkApplicationsImports.getReturn(context, "New");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        if (!this.hasPermission(context, "netapps_expiration_contracts_imports-add")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean contractRecordInserted = false;
        boolean fileRecordInserted = false;
        ContractExpirationImport thisImport = (ContractExpirationImport)context.getFormBean();
        try {
            db = this.getConnection(context);
            String filePath = this.getPath(context, "netapps");
            HttpMultiPartParser multiPart = new HttpMultiPartParser();
            multiPart.setUsePathParam(false);
            multiPart.setUseUniqueName(true);
            multiPart.setUseDateForFolder(true);
            multiPart.setExtensionId(this.getUserId(context));
            HashMap parts = multiPart.parseData(context.getRequest(), filePath);
            String subject = (String)parts.get("name");
            String description = (String)parts.get("description");
            thisImport.setEnteredBy(this.getUserId(context));
            thisImport.setModifiedBy(this.getUserId(context));
            thisImport.setType(917200409);
            thisImport.setName(subject);
            thisImport.setDescription(description);
            contractRecordInserted = thisImport.insert(db);
            if (contractRecordInserted) {
                if (parts.get("id") instanceof FileInfo) {
                    FileInfo newFileInfo = (FileInfo)parts.get("id");
                    FileItem thisItem = new FileItem();
                    thisItem.setLinkModuleId(917200409);
                    thisItem.setLinkItemId(thisImport.getId());
                    thisItem.setEnteredBy(this.getUserId(context));
                    thisItem.setModifiedBy(this.getUserId(context));
                    thisItem.setSubject(subject);
                    thisItem.setClientFilename(newFileInfo.getClientFileName());
                    thisItem.setFilename(newFileInfo.getRealFilename());
                    thisItem.setVersion(1.0);
                    thisItem.setSize(newFileInfo.getSize());
                    fileRecordInserted = thisItem.insert(db);
                    if (!fileRecordInserted) {
                        this.processErrors(context, thisItem.getErrors());
                    }
                } else {
                    fileRecordInserted = false;
                    HashMap<String, String> errors = new HashMap<String, String>();
                    errors.put("actionError", "The file could not be sent by your computer, make sure the file exists");
                    this.processErrors(context, errors);
                    context.getRequest().setAttribute("name", (Object)subject);
                }
            }
            if (contractRecordInserted && fileRecordInserted) {
                thisImport = new ContractExpirationImport(db, thisImport.getId());
                thisImport.buildFileDetails(db);
            } else if (contractRecordInserted) {
                thisImport.delete(db);
                thisImport.setId(-1);
            }
            context.getRequest().setAttribute("ImportDetails", (Object)thisImport);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (fileRecordInserted && contractRecordInserted) {
            return NetworkApplicationsImports.getReturn(context, "Save");
        }
        return NetworkApplicationsImports.getReturn(context, "New");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "netapps_expiration_contracts_imports-view")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            String importId = context.getRequest().getParameter("importId");
            ContractExpirationImport thisImport = new ContractExpirationImport(db, Integer.parseInt(importId));
            thisImport.buildFileDetails(db);
            SystemStatus systemStatus = this.getSystemStatus(context);
            ImportManager manager = systemStatus.getImportManager(context);
            Object activeImport = manager.getImport(thisImport.getId());
            if (thisImport.isRunning() && activeImport != null) {
                thisImport.updateRecordCounts(manager);
            } else if (thisImport.isRunning() && activeImport == null) {
                thisImport.updateStatus(db, 4);
            }
            this.buildFormElements(db, context);
            context.getRequest().setAttribute("ImportDetails", (Object)thisImport);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return NetworkApplicationsImports.getReturn(context, "Details");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInitValidate(ActionContext context) {
        if (!this.hasPermission(context, "netapps_expiration_contracts_imports-add")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            String importId = context.getRequest().getParameter("importId");
            ContractExpirationImport thisImport = new ContractExpirationImport(db, Integer.parseInt(importId));
            thisImport.buildFileDetails(db);
            context.getRequest().setAttribute("ImportDetails", (Object)thisImport);
            String propertyFile = context.getServletContext().getRealPath("/") + "WEB-INF" + System.getProperty("file.separator") + "cfs-import-properties.xml";
            PropertyMap thisMap = new PropertyMap(propertyFile, "netAppContractExpiration");
            FileItem importFile = thisImport.getFile();
            context.getRequest().setAttribute("FileItem", (Object)importFile);
            String filePath = this.getPath(context, "netapps") + NetworkApplicationsImports.getDatePath(importFile.getModified()) + importFile.getFilename();
            if (FileUtils.fileExists(filePath)) {
                ContractExpirationImportValidate validator = new ContractExpirationImportValidate();
                validator.setContractExpirationImport(thisImport);
                validator.setFilePath(filePath);
                validator.setPropertyMap(thisMap);
                validator.initialize();
                context.getRequest().setAttribute("ImportValidator", (Object)validator);
            } else {
                context.getRequest().setAttribute("actionError", (Object)"Import file does not exist.");
            }
            this.buildValidateFormElements(db, context, thisImport);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return NetworkApplicationsImports.getReturn(context, "InitValidate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandValidate(ActionContext context) {
        if (!this.hasPermission(context, "netapps_expiration_contracts_imports-add")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            String importId = context.getRequest().getParameter("importId");
            ContractExpirationImport thisImport = new ContractExpirationImport(db, Integer.parseInt(importId));
            thisImport.buildFileDetails(db);
            thisImport.setProperties(context.getRequest());
            context.getRequest().setAttribute("ImportDetails", (Object)thisImport);
            String propertyFile = context.getServletContext().getRealPath("/") + "WEB-INF" + System.getProperty("file.separator") + "cfs-import-properties.xml";
            PropertyMap thisMap = new PropertyMap(propertyFile, "netAppContractExpiration");
            FileItem importFile = thisImport.getFile();
            context.getRequest().setAttribute("FileItem", (Object)importFile);
            String filePath = this.getPath(context, "netapps") + NetworkApplicationsImports.getDatePath(importFile.getModified()) + importFile.getFilename();
            if (FileUtils.fileExists(filePath)) {
                ContractExpirationImportValidate validator = new ContractExpirationImportValidate();
                validator.setContractExpirationImport(thisImport);
                validator.setFilePath(filePath);
                validator.setPropertyMap(thisMap);
                validator.validate(context.getRequest());
                context.getRequest().setAttribute("ImportValidator", (Object)validator);
                if (validator.getErrors().size() == 0) {
                    String string = this.executeCommandProcess(context);
                    return string;
                }
            } else {
                context.getRequest().setAttribute("actionError", (Object)"Import file does not exist.");
            }
            this.buildValidateFormElements(db, context, thisImport);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return NetworkApplicationsImports.getReturn(context, "Validate");
    }

    public String executeCommandProcess(ActionContext context) {
        try {
            ContractExpirationImportValidate validator = (ContractExpirationImportValidate)context.getRequest().getAttribute("ImportValidator");
            ContractExpirationImport thisImport = (ContractExpirationImport)context.getRequest().getAttribute("ImportDetails");
            FileItem thisItem = (FileItem)context.getRequest().getAttribute("FileItem");
            ConnectionElement ce = (ConnectionElement)context.getSession().getAttribute("ConnectionElement");
            SystemStatus systemStatus = this.getSystemStatus(context);
            ImportManager manager = systemStatus.getImportManager(context);
            Object activeImport = manager.getImport(thisImport.getId());
            if (activeImport == null) {
                thisImport.setPropertyMap(validator.getPropertyMap());
                thisImport.setFilePath(validator.getFilePath());
                thisImport.setUserId(this.getUserId(context));
                thisImport.setConnectionElement(ce);
                thisImport.setFileItem(thisItem);
                manager.add(thisImport);
            } else {
                context.getRequest().setAttribute("actionError", (Object)("The import \"" + thisImport.getName() + "\" is already running"));
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            return "SystemError";
        }
        return NetworkApplicationsImports.getReturn(context, "Process");
    }

    public String executeCommandCancel(ActionContext context) {
        if (!this.hasPermission(context, "netapps_expiration_contracts_imports-add")) {
            return "PermissionError";
        }
        String importId = context.getRequest().getParameter("importId");
        try {
            SystemStatus systemStatus = this.getSystemStatus(context);
            ImportManager manager = systemStatus.getImportManager(context);
            if (!manager.cancel(Integer.parseInt(importId))) {
                context.getRequest().setAttribute("actionError", (Object)"Cancel Failed: Import is no longer running");
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            return "SystemError";
        }
        if ("list".equals(context.getRequest().getParameter("return"))) {
            return NetworkApplicationsImports.getReturn(context, "Cancel");
        }
        return NetworkApplicationsImports.getReturn(context, "CancelDetails");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        Connection db = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        if (!this.hasPermission(context, "netapps_expiration_contracts_imports-delete")) {
            return "PermissionError";
        }
        String importId = context.getRequest().getParameter("importId");
        try {
            db = this.getConnection(context);
            ContractExpirationImport thisImport = new ContractExpirationImport(db, Integer.parseInt(importId));
            DependencyList dependencies = thisImport.processDependencies(db);
            htmlDialog.addMessage(dependencies.getHtmlString());
            if (dependencies.size() == 0) {
                htmlDialog.setTitle("Confirm");
                htmlDialog.setShowAndConfirm(false);
                htmlDialog.setDeleteUrl("javascript:window.location.href='NetworkApplicationsImports.do?command=Delete&importId=" + importId + "'");
            } else {
                htmlDialog.setTitle("Confirm");
                htmlDialog.setHeader("Are you sure you want to delete this item:");
                htmlDialog.addButton("Delete All", "javascript:window.location.href='NetworkApplicationsImports.do?command=Delete&importId=" + importId + "'");
                htmlDialog.addButton("No", "javascript:parent.window.close()");
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        Connection db = null;
        if (!this.hasPermission(context, "netapps_expiration_contracts_imports-delete")) {
            return "PermissionError";
        }
        String importId = context.getRequest().getParameter("importId");
        try {
            db = this.getConnection(context);
            ContractExpirationImport thisImport = new ContractExpirationImport(db, Integer.parseInt(importId));
            int recordDeleted = thisImport.updateStatus(db, 8);
            ContractExpirationImport.deleteImportedRecords(db, thisImport.getId());
            if (recordDeleted > 0) {
                FileItem importFile = new FileItem(db, thisImport.getId(), 917200409);
                importFile.delete(db, this.getPath(context, "netapps"));
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("refreshUrl", (Object)"NetworkApplicationsImports.do?command=View");
        return NetworkApplicationsImports.getReturn(context, "Delete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownload(ActionContext context) {
        block24: {
            if (!this.hasPermission(context, "netapps_expiration_contracts_imports-view")) {
                return "PermissionError";
            }
            Exception errorMessage = null;
            String itemId = context.getRequest().getParameter("fid");
            String importId = context.getRequest().getParameter("importId");
            String stream = context.getRequest().getParameter("stream");
            String version = context.getRequest().getParameter("ver");
            FileItem thisItem = null;
            ContractExpirationImport thisImport = null;
            Connection db = null;
            try {
                db = this.getConnection(context);
                thisImport = new ContractExpirationImport(db, Integer.parseInt(importId));
                thisItem = new FileItem(db, Integer.parseInt(itemId), Integer.parseInt(importId), 917200409);
                if (version != null) {
                    thisItem.buildVersionList(db);
                }
            }
            catch (Exception e) {
                errorMessage = e;
            }
            finally {
                this.freeConnection(context, db);
            }
            try {
                if (version == null) {
                    FileItem itemToDownload = thisItem;
                    itemToDownload.setEnteredBy(this.getUserId(context));
                    String filePath = this.getPath(context, "netapps") + NetworkApplicationsImports.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                    FileDownload fileDownload = new FileDownload();
                    fileDownload.setFullPath(filePath);
                    fileDownload.setDisplayName(itemToDownload.getClientFilename());
                    if (fileDownload.fileExists()) {
                        if ("true".equals(stream)) {
                            fileDownload.setFileTimestamp(thisItem.getModificationDate().getTime());
                            fileDownload.streamContent(context);
                        } else {
                            fileDownload.sendFile(context);
                        }
                    } else {
                        db = null;
                        System.err.println("NetworkApplicationsImports-> Trying to send a file that does not exist");
                        context.getRequest().setAttribute("actionError", (Object)"The requested download no longer exists on the system");
                        context.getRequest().setAttribute("ImportDetails", (Object)thisImport);
                        context.getRequest().setAttribute("FileItem", (Object)itemToDownload);
                        String string = NetworkApplicationsImports.getReturn(context, "Details");
                        return string;
                    }
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block24;
                }
                FileItemVersion itemToDownload = thisItem.getVersion(Double.parseDouble(version));
                itemToDownload.setEnteredBy(this.getUserId(context));
                String filePath = this.getPath(context, "netapps") + NetworkApplicationsImports.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                FileDownload fileDownload = new FileDownload();
                fileDownload.setFullPath(filePath);
                fileDownload.setDisplayName(itemToDownload.getClientFilename());
                if (fileDownload.fileExists()) {
                    fileDownload.sendFile(context);
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block24;
                }
                db = null;
                System.err.println("NetworkApplicationsImports-> Trying to send a file that does not exist");
                context.getRequest().setAttribute("actionError", (Object)"The requested download no longer exists on the system");
                String string = this.executeCommandView(context);
                return string;
            }
            catch (SocketException se) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println(se.toString());
                }
            }
            catch (Exception e) {
                context.getRequest().setAttribute("Error", (Object)e);
                String string = "SystemError";
                return string;
            }
            finally {
                if (db != null) {
                    this.freeConnection(context, db);
                }
            }
        }
        return "-none-";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandApprove(ActionContext context) {
        if (!this.hasPermission(context, "netapps_expiration_contracts_imports-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        String importId = context.getRequest().getParameter("importId");
        try {
            db = this.getConnection(context);
            ContractExpirationImport thisImport = new ContractExpirationImport(db, Integer.parseInt(importId));
            if (thisImport.canApprove()) {
                thisImport.updateStatus(db, 7);
            } else {
                context.getRequest().setAttribute("actionError", (Object)"Import has not yet been successfully processed");
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return NetworkApplicationsImports.getReturn(context, "Approve");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewResults(ActionContext context) {
        if (!this.hasPermission(context, "netapps_expiration_contracts_imports-view")) {
            return "PermissionError";
        }
        Connection db = null;
        String importId = context.getRequest().getParameter("importId");
        PagedListInfo pagedListInfo = this.getPagedListInfo(context, "NetworkApplicationsImportResultsInfo");
        pagedListInfo.setLink("NetworkApplicationsImports.do?command=ViewResults&importId=" + importId);
        try {
            db = this.getConnection(context);
            ContractExpirationImport thisImport = new ContractExpirationImport(db, Integer.parseInt(importId));
            context.getRequest().setAttribute("ImportDetails", (Object)thisImport);
            ContractExpirationList thisList = new ContractExpirationList();
            thisList.setPagedListInfo(pagedListInfo);
            thisList.setImportId(Integer.parseInt(importId));
            thisList.setExcludeUnapprovedContracts(false);
            thisList.buildList(db);
            context.getRequest().setAttribute("ImportResults", (Object)thisList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return NetworkApplicationsImports.getReturn(context, "ViewResults");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandContractExpirationDetails(ActionContext context) {
        if (!this.hasPermission(context, "netapps_expiration_contracts_imports-view")) {
            return "PermissionError";
        }
        Connection db = null;
        String expirationId = context.getRequest().getParameter("expirationId");
        try {
            db = this.getConnection(context);
            ContractExpiration thisContractExpiration = new ContractExpiration(db, Integer.parseInt(expirationId));
            context.getRequest().setAttribute("contractExpiration", (Object)thisContractExpiration);
            Import thisImport = new Import(db, thisContractExpiration.getImportId());
            context.getRequest().setAttribute("ImportDetails", (Object)thisImport);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return NetworkApplicationsImports.getReturn(context, "ContractExpirationDetails");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteContractExpiration(ActionContext context) {
        if (!this.hasPermission(context, "netapps_expiration_contracts_imports-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean recordDeleted = false;
        String expirationId = context.getRequest().getParameter("expirationId");
        try {
            db = this.getConnection(context);
            ContractExpiration thisContractExpiration = new ContractExpiration(db, Integer.parseInt(expirationId));
            if (thisContractExpiration.getStatusId() != 7 && !(recordDeleted = thisContractExpiration.delete(context.getRequest(), db))) {
                context.getRequest().setAttribute("ContractExpirationDetails", (Object)thisContractExpiration);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordDeleted) {
            return NetworkApplicationsImports.getReturn(context, "DeleteContractExpiration");
        }
        if ("list".equals(context.getRequest().getParameter("return"))) {
            return NetworkApplicationsImports.getReturn(context, "DeleteContractExpirationListFailed");
        }
        return NetworkApplicationsImports.getReturn(context, "DeleteContractExpirationDetailsFailed");
    }

    private void buildValidateFormElements(Connection db, ActionContext context, ContractExpirationImport thisImport) throws SQLException {
        SystemStatus systemStatus = this.getSystemStatus(context);
        AccessTypeList accessTypeList = null;
        if (thisImport.getType() == 917200409) {
            accessTypeList = systemStatus.getAccessTypeList(db, 626030332);
        }
        context.getRequest().setAttribute("AccessTypeList", (Object)accessTypeList);
    }

    private void buildFormElements(Connection db, ActionContext context) throws SQLException {
        SystemStatus systemStatus = this.getSystemStatus(context);
        LookupList sourceList = new LookupList(db, "lookup_contact_source");
        sourceList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("SourceTypeList", (Object)sourceList);
        LookupList siteList = new LookupList(db, "lookup_site_id");
        siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
        siteList.addItem(-2, systemStatus.getLabel("accounts.allSites"));
        context.getRequest().setAttribute("SiteList", (Object)siteList);
    }
}

