/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.netapps.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.netapps.base.ContractExpirationLog;
import org.aspcfs.modules.netapps.base.ContractExpirationLogList;
import org.aspcfs.utils.DatabaseUtils;

public class ContractExpiration
extends GenericBean {
    private int id = -1;
    private String serialNumber = null;
    private String agreementNumber = null;
    private String services = null;
    private Timestamp startDate = null;
    private Timestamp endDate = null;
    private String installedAtCompanyName = null;
    private String installedAtSiteName = null;
    private String groupName = null;
    private String productNumber = null;
    private String systemName = null;
    private String operatingSystem = null;
    private int noOfShelves = -1;
    private int noOfDisks = -1;
    private int nvram = -1;
    private int memory = -1;
    private String autosupportStatus = null;
    private String installedAtAddress = null;
    private String city = null;
    private String stateProvince = null;
    private String postalCode = null;
    private String country = null;
    private String installedAtContactFirstName = null;
    private String contactLastName = null;
    private String contactEmail = null;
    private String agreementCompany = null;
    private double quoteAmount = -1.0;
    private Timestamp quoteGeneratedDate = null;
    private Timestamp quoteAcceptedDate = null;
    private Timestamp quoteRejectedDate = null;
    private String comment = null;
    private int importId = -1;
    private int statusId = -1;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private boolean override = false;
    private ContractExpirationLogList history = new ContractExpirationLogList();

    public ContractExpiration() {
    }

    public ContractExpiration(Connection db, int tmpExpirationId) throws SQLException {
        this.queryRecord(db, tmpExpirationId);
    }

    public ContractExpiration(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setSerialNumber(String tmp) {
        this.serialNumber = tmp;
    }

    public void setAgreementNumber(String tmp) {
        this.agreementNumber = tmp;
    }

    public void setServices(String tmp) {
        this.services = tmp;
    }

    public void setStartDate(Timestamp tmp) {
        this.startDate = tmp;
    }

    public void setStartDate(String tmp) {
        this.startDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEndDate(Timestamp tmp) {
        this.endDate = tmp;
    }

    public void setEndDate(String tmp) {
        this.endDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setInstalledAtCompanyName(String tmp) {
        this.installedAtCompanyName = tmp;
    }

    public void setInstalledAtSiteName(String tmp) {
        this.installedAtSiteName = tmp;
    }

    public void setGroupName(String tmp) {
        this.groupName = tmp;
    }

    public void setProductNumber(String tmp) {
        this.productNumber = tmp;
    }

    public void setSystemName(String tmp) {
        this.systemName = tmp;
    }

    public void setOperatingSystem(String tmp) {
        this.operatingSystem = tmp;
    }

    public void setNoOfShelves(int tmp) {
        this.noOfShelves = tmp;
    }

    public void setNoOfShelves(String tmp) {
        this.noOfShelves = Integer.parseInt(tmp);
    }

    public void setNoOfDisks(int tmp) {
        this.noOfDisks = tmp;
    }

    public void setNoOfDisks(String tmp) {
        this.noOfDisks = Integer.parseInt(tmp);
    }

    public void setNvram(int tmp) {
        this.nvram = tmp;
    }

    public void setNvram(String tmp) {
        this.nvram = Integer.parseInt(tmp);
    }

    public void setMemory(int tmp) {
        this.memory = tmp;
    }

    public void setMemory(String tmp) {
        this.memory = Integer.parseInt(tmp);
    }

    public void setAutosupportStatus(String tmp) {
        this.autosupportStatus = tmp;
    }

    public void setInstalledAtAddress(String tmp) {
        this.installedAtAddress = tmp;
    }

    public void setCity(String tmp) {
        this.city = tmp;
    }

    public void setStateProvince(String tmp) {
        this.stateProvince = tmp;
    }

    public void setPostalCode(String tmp) {
        this.postalCode = tmp;
    }

    public void setCountry(String tmp) {
        this.country = tmp;
    }

    public void setInstalledAtContactFirstName(String tmp) {
        this.installedAtContactFirstName = tmp;
    }

    public void setContactLastName(String tmp) {
        this.contactLastName = tmp;
    }

    public void setContactEmail(String tmp) {
        this.contactEmail = tmp;
    }

    public void setAgreementCompany(String tmp) {
        this.agreementCompany = tmp;
    }

    public void setQuoteAmount(double tmp) {
        this.quoteAmount = tmp;
    }

    public void setQuoteAmount(String tmp) {
        this.quoteAmount = Double.parseDouble(tmp);
    }

    public void setQuoteGeneratedDate(Timestamp tmp) {
        this.quoteGeneratedDate = tmp;
    }

    public void setQuoteGeneratedDate(String tmp) {
        this.quoteGeneratedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setQuoteAcceptedDate(Timestamp tmp) {
        this.quoteAcceptedDate = tmp;
    }

    public void setQuoteAcceptedDate(String tmp) {
        this.quoteAcceptedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setQuoteRejectedDate(Timestamp tmp) {
        this.quoteRejectedDate = tmp;
    }

    public void setQuoteRejectedDate(String tmp) {
        this.quoteRejectedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setComment(String tmp) {
        this.comment = tmp;
    }

    public void setImportId(int tmp) {
        this.importId = tmp;
    }

    public void setImportId(String tmp) {
        this.importId = Integer.parseInt(tmp);
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setOverride(boolean tmp) {
        this.override = tmp;
    }

    public void setOverride(String tmp) {
        this.override = DatabaseUtils.parseBoolean(tmp);
    }

    public void setHistory(ContractExpirationLogList tmp) {
        this.history = tmp;
    }

    public int getId() {
        return this.id;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getAgreementNumber() {
        return this.agreementNumber;
    }

    public String getServices() {
        return this.services;
    }

    public Timestamp getStartDate() {
        return this.startDate;
    }

    public Timestamp getEndDate() {
        return this.endDate;
    }

    public String getInstalledAtCompanyName() {
        return this.installedAtCompanyName;
    }

    public String getInstalledAtSiteName() {
        return this.installedAtSiteName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getProductNumber() {
        return this.productNumber;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public int getNoOfShelves() {
        return this.noOfShelves;
    }

    public int getNoOfDisks() {
        return this.noOfDisks;
    }

    public int getNvram() {
        return this.nvram;
    }

    public int getMemory() {
        return this.memory;
    }

    public String getAutosupportStatus() {
        return this.autosupportStatus;
    }

    public String getInstalledAtAddress() {
        return this.installedAtAddress;
    }

    public String getCity() {
        return this.city;
    }

    public String getStateProvince() {
        return this.stateProvince;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public String getCountry() {
        return this.country;
    }

    public String getInstalledAtContactFirstName() {
        return this.installedAtContactFirstName;
    }

    public String getContactLastName() {
        return this.contactLastName;
    }

    public String getContactEmail() {
        return this.contactEmail;
    }

    public String getAgreementCompany() {
        return this.agreementCompany;
    }

    public double getQuoteAmount() {
        return this.quoteAmount;
    }

    public Timestamp getQuoteGeneratedDate() {
        return this.quoteGeneratedDate;
    }

    public Timestamp getQuoteAcceptedDate() {
        return this.quoteAcceptedDate;
    }

    public Timestamp getQuoteRejectedDate() {
        return this.quoteRejectedDate;
    }

    public String getComment() {
        return this.comment;
    }

    public int getImportId() {
        return this.importId;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public boolean getOverride() {
        return this.override;
    }

    public ContractExpirationLogList getHistory() {
        return this.history;
    }

    public boolean isApproved() {
        return this.statusId != 6;
    }

    public boolean queryRecord(Connection db, int tmpExpirationId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement(" SELECT *  FROM netapp_contractexpiration  WHERE expiration_id = ? ");
        pst.setInt(1, tmpExpirationId);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        return true;
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "netapp_contractexpiration_expiration_id_seq");
        PreparedStatement pst = null;
        pst = db.prepareStatement("INSERT INTO netapp_contractexpiration (" + (this.id > -1 ? "expiration_id, " : "") + "serial_number, " + "agreement_number, " + "services, " + "startdate, " + "enddate, " + "installed_at_company_name, " + "installed_at_site_name, " + "group_name, " + "product_number, " + "system_name, " + "operating_system, " + "no_of_shelves, " + "no_of_disks, " + "nvram, " + "memory, " + "auto_support_status, " + "installed_at_address, " + "city, " + "state_province, " + "postal_code, " + "country, " + "installed_at_contact_firstname, " + "contact_lastname, " + "contact_email, " + "agreement_company, " + "quote_amount, " + "quotegenerateddate, " + "quoteaccepteddate, " + "quoterejecteddate, " + "comment, " + "import_id , " + "status_id, " + "enteredBy, " + "modifiedBy )" + "VALUES (" + (this.id > -1 ? "?, " : "") + "?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setString(++i, this.serialNumber);
        pst.setString(++i, this.agreementNumber);
        pst.setString(++i, this.services);
        DatabaseUtils.setTimestamp(pst, ++i, this.startDate);
        DatabaseUtils.setTimestamp(pst, ++i, this.endDate);
        pst.setString(++i, this.installedAtCompanyName);
        pst.setString(++i, this.installedAtSiteName);
        pst.setString(++i, this.groupName);
        pst.setString(++i, this.productNumber);
        pst.setString(++i, this.systemName);
        pst.setString(++i, this.operatingSystem);
        DatabaseUtils.setInt(pst, ++i, this.noOfShelves);
        DatabaseUtils.setInt(pst, ++i, this.noOfDisks);
        DatabaseUtils.setInt(pst, ++i, this.nvram);
        DatabaseUtils.setInt(pst, ++i, this.memory);
        pst.setString(++i, this.autosupportStatus);
        pst.setString(++i, this.installedAtAddress);
        pst.setString(++i, this.city);
        pst.setString(++i, this.stateProvince);
        pst.setString(++i, this.postalCode);
        pst.setString(++i, this.country);
        pst.setString(++i, this.installedAtContactFirstName);
        pst.setString(++i, this.contactLastName);
        pst.setString(++i, this.contactEmail);
        pst.setString(++i, this.agreementCompany);
        DatabaseUtils.setDouble(pst, ++i, this.quoteAmount);
        DatabaseUtils.setTimestamp(pst, ++i, this.quoteGeneratedDate);
        DatabaseUtils.setTimestamp(pst, ++i, this.quoteAcceptedDate);
        DatabaseUtils.setTimestamp(pst, ++i, this.quoteRejectedDate);
        pst.setString(++i, this.comment);
        DatabaseUtils.setInt(pst, ++i, this.importId);
        DatabaseUtils.setInt(pst, ++i, this.statusId);
        DatabaseUtils.setInt(pst, ++i, this.enteredBy);
        DatabaseUtils.setInt(pst, ++i, this.modifiedBy);
        pst.execute();
        this.id = DatabaseUtils.getCurrVal(db, "netapp_contractexpiration_expiration_id_seq", this.id);
        pst.close();
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (!this.isValid()) {
            return resultCount;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE netapp_contractexpiration SET  serial_number = ? , agreement_number = ? , services = ? , startdate = ? , enddate = ? , installed_at_company_name = ? , installed_at_site_name = ? , group_name = ? , product_number = ? , system_name = ? , operating_system = ? , no_of_shelves = ? , no_of_disks = ? , nvram = ? , memory = ? , auto_support_status = ? , installed_at_address = ? , city = ? , state_province = ? , postal_code = ? , country = ? , installed_at_contact_firstname = ? , contact_lastname = ? , contact_email = ? , agreement_company = ? , import_id = ? , modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , " + "modifiedBy = ?  " + "WHERE expiration_id = ? ");
        pst = db.prepareStatement(sql.toString());
        int i = 0;
        pst.setString(++i, this.serialNumber);
        pst.setString(++i, this.agreementNumber);
        pst.setString(++i, this.services);
        DatabaseUtils.setTimestamp(pst, ++i, this.startDate);
        DatabaseUtils.setTimestamp(pst, ++i, this.endDate);
        pst.setString(++i, this.installedAtCompanyName);
        pst.setString(++i, this.installedAtSiteName);
        pst.setString(++i, this.groupName);
        pst.setString(++i, this.productNumber);
        pst.setString(++i, this.systemName);
        pst.setString(++i, this.operatingSystem);
        DatabaseUtils.setInt(pst, ++i, this.noOfShelves);
        DatabaseUtils.setInt(pst, ++i, this.noOfDisks);
        DatabaseUtils.setInt(pst, ++i, this.nvram);
        DatabaseUtils.setInt(pst, ++i, this.memory);
        pst.setString(++i, this.autosupportStatus);
        pst.setString(++i, this.installedAtAddress);
        pst.setString(++i, this.city);
        pst.setString(++i, this.stateProvince);
        pst.setString(++i, this.postalCode);
        pst.setString(++i, this.country);
        pst.setString(++i, this.installedAtContactFirstName);
        pst.setString(++i, this.contactLastName);
        pst.setString(++i, this.contactEmail);
        pst.setString(++i, this.agreementCompany);
        DatabaseUtils.setInt(pst, ++i, this.importId);
        DatabaseUtils.setInt(pst, ++i, this.modifiedBy);
        DatabaseUtils.setInt(pst, ++i, this.id);
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public int updateQuoteInformation(Connection db) throws SQLException {
        int resultCount = 0;
        if (!this.isValid()) {
            return resultCount;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE netapp_contractexpiration SET  quote_amount = ?, quotegenerateddate = ?, quoteaccepteddate = ?, quoterejecteddate = ?, comment = ? ");
        if (!this.override) {
            sql.append(" , modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , modifiedby = ? ");
        }
        sql.append("WHERE expiration_id = ? ");
        if (!this.override) {
            sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        }
        pst = db.prepareStatement(sql.toString());
        int i = 0;
        DatabaseUtils.setDouble(pst, ++i, this.quoteAmount);
        DatabaseUtils.setTimestamp(pst, ++i, this.quoteGeneratedDate);
        DatabaseUtils.setTimestamp(pst, ++i, this.quoteAcceptedDate);
        DatabaseUtils.setTimestamp(pst, ++i, this.quoteRejectedDate);
        pst.setString(++i, this.comment);
        if (!this.override) {
            pst.setInt(++i, this.modifiedBy);
        }
        DatabaseUtils.setInt(pst, ++i, this.id);
        if (!this.override && this.getModified() != null) {
            pst.setTimestamp(++i, this.modified);
        }
        resultCount = pst.executeUpdate();
        pst.close();
        this.updateLog(db);
        return resultCount;
    }

    public void updateLog(Connection db) throws SQLException {
        ContractExpirationLog thisEntry = new ContractExpirationLog();
        thisEntry.setEnteredBy(this.getModifiedBy());
        thisEntry.setModifiedBy(this.getModifiedBy());
        thisEntry.setQuoteAmount(this.getQuoteAmount());
        thisEntry.setQuoteGeneratedDate(this.getQuoteGeneratedDate());
        thisEntry.setQuoteAcceptedDate(this.getQuoteAcceptedDate());
        thisEntry.setQuoteRejectedDate(this.getQuoteRejectedDate());
        thisEntry.setComment(this.getComment());
        thisEntry.setExpirationId(this.getId());
        this.history.add(thisEntry);
        for (ContractExpirationLog thisLog : this.history) {
            thisLog.process(db, this.getId());
        }
    }

    public boolean isValid() {
        return !this.hasErrors();
    }

    public static int updateImportStatus(Connection db, int importId, int status) throws SQLException {
        int count = 0;
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            String sql = "UPDATE netapp_contractexpiration SET status_id = ? WHERE import_id = ? ";
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql);
            pst.setInt(++i, status);
            pst.setInt(++i, importId);
            count = pst.executeUpdate();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return count;
    }

    public boolean delete(HttpServletRequest request, Connection db) throws SQLException {
        PreparedStatement pst = null;
        pst = db.prepareStatement(" DELETE  FROM netapp_contractexpiration_log  WHERE expiration_id = ? ");
        pst.setInt(1, this.id);
        pst.execute();
        pst.close();
        pst = null;
        pst = db.prepareStatement(" DELETE  FROM netapp_contractexpiration  WHERE expiration_id = ? ");
        pst.setInt(1, this.id);
        pst.execute();
        pst.close();
        return true;
    }

    public ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("startDate");
        thisList.add("endDate");
        thisList.add("quoteGeneratedDate");
        thisList.add("quoteAcceptedDate");
        thisList.add("quoteRejectedDate");
        return thisList;
    }

    public static ArrayList getNumberParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("quoteAmount");
        return thisList;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = DatabaseUtils.getInt(rs, "expiration_id");
        this.serialNumber = rs.getString("serial_number");
        this.agreementNumber = rs.getString("agreement_number");
        this.services = rs.getString("services");
        this.startDate = rs.getTimestamp("startdate");
        this.endDate = rs.getTimestamp("enddate");
        this.installedAtCompanyName = rs.getString("installed_at_company_name");
        this.installedAtSiteName = rs.getString("installed_at_site_name");
        this.groupName = rs.getString("group_name");
        this.productNumber = rs.getString("product_number");
        this.systemName = rs.getString("system_name");
        this.operatingSystem = rs.getString("operating_system");
        this.noOfShelves = DatabaseUtils.getInt(rs, "no_of_shelves");
        this.noOfDisks = DatabaseUtils.getInt(rs, "no_of_disks");
        this.nvram = DatabaseUtils.getInt(rs, "nvram");
        this.memory = DatabaseUtils.getInt(rs, "memory");
        this.autosupportStatus = rs.getString("auto_support_status");
        this.installedAtAddress = rs.getString("installed_at_address");
        this.city = rs.getString("city");
        this.stateProvince = rs.getString("state_province");
        this.postalCode = rs.getString("postal_code");
        this.country = rs.getString("country");
        this.installedAtContactFirstName = rs.getString("installed_at_contact_firstname");
        this.contactLastName = rs.getString("contact_lastname");
        this.contactEmail = rs.getString("contact_email");
        this.agreementCompany = rs.getString("agreement_company");
        this.quoteAmount = DatabaseUtils.getDouble(rs, "quote_amount");
        this.quoteGeneratedDate = rs.getTimestamp("quotegenerateddate");
        this.quoteAcceptedDate = rs.getTimestamp("quoteaccepteddate");
        this.quoteRejectedDate = rs.getTimestamp("quoterejecteddate");
        this.comment = rs.getString("comment");
        this.importId = DatabaseUtils.getInt(rs, "import_id");
        this.statusId = DatabaseUtils.getInt(rs, "status_id");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = DatabaseUtils.getInt(rs, "enteredBy");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = DatabaseUtils.getInt(rs, "modifiedBy");
    }
}

