/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.netapps.base;

import com.darkhorseventures.database.ConnectionElement;
import com.zeroio.iteam.base.FileItem;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.apps.transfer.reader.mapreader.Property;
import org.aspcfs.apps.transfer.reader.mapreader.PropertyMap;
import org.aspcfs.controller.ImportManager;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.base.Import;
import org.aspcfs.modules.netapps.base.ContractExpiration;
import org.aspcfs.modules.netapps.base.ContractExpirationList;
import org.aspcfs.utils.CFSFileReader;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.StringUtils;

public class ContractExpirationImport
extends Import
implements Runnable {
    public static final String fs = System.getProperty("file.separator");
    private PropertyMap propertyMap = null;
    private String filePath = null;
    private int userId = -1;
    private int accessTypeId = -1;
    private ImportManager manager = null;
    private Connection db = null;
    private ConnectionElement connectionElement = null;
    private File errorFile = null;
    private BufferedWriter fos = null;
    private FileItem fileItem = null;
    private Thread importThread = null;
    private ContractExpirationList contractExpirationList = null;

    public ContractExpirationImport() {
    }

    public ContractExpirationImport(Connection db, int importId) throws SQLException {
        super(db, importId);
    }

    public void setProperties(HttpServletRequest request) {
        if (request.getParameter("accessType") != null) {
            this.setAccessTypeId(request.getParameter("accessType"));
        }
    }

    public void setAccessTypeId(int tmp) {
        this.accessTypeId = tmp;
    }

    public void setAccessTypeId(String tmp) {
        this.accessTypeId = Integer.parseInt(tmp);
    }

    public void setUserId(int tmp) {
        this.userId = tmp;
    }

    public void setUserId(String tmp) {
        this.userId = Integer.parseInt(tmp);
    }

    public void setPropertyMap(PropertyMap tmp) {
        this.propertyMap = tmp;
    }

    public void setFilePath(String tmp) {
        this.filePath = tmp;
    }

    public void setDb(Connection tmp) {
        this.db = tmp;
    }

    public void setManager(ImportManager tmp) {
        this.manager = tmp;
    }

    public void setErrorFile(File tmp) {
        this.errorFile = tmp;
    }

    public void setFileItem(FileItem tmp) {
        this.fileItem = tmp;
    }

    public void setImportThread(Thread tmp) {
        this.importThread = tmp;
    }

    public void setContractExpirationList(ContractExpirationList tmp) {
        this.contractExpirationList = tmp;
    }

    public Thread getImportThread() {
        return this.importThread;
    }

    public FileItem getFileItem() {
        return this.fileItem;
    }

    public File getErrorFile() {
        return this.errorFile;
    }

    public ImportManager getManager() {
        return this.manager;
    }

    public Connection getDb() {
        return this.db;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public PropertyMap getPropertyMap() {
        return this.propertyMap;
    }

    public int getUserId() {
        return this.userId;
    }

    public int getAccessTypeId() {
        return this.accessTypeId;
    }

    public void setConnectionElement(ConnectionElement tmp) {
        this.connectionElement = tmp;
    }

    public ConnectionElement getConnectionElement() {
        return this.connectionElement;
    }

    public ContractExpirationList getContractExpirationList() {
        return this.contractExpirationList;
    }

    public void start() {
        this.importThread = new Thread(this);
        this.importThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ArrayList thisRecord = new ArrayList();
        String line = null;
        StringBuffer error = new StringBuffer();
        int recordCount = 1;
        boolean recordInserted = false;
        boolean done = false;
        ArrayList header = null;
        Thread currentThread = Thread.currentThread();
        try {
            this.db = this.manager.getConnection(this.connectionElement);
            this.contractExpirationList = new ContractExpirationList();
            this.contractExpirationList.buildList(this.db);
            this.errorFile = new File(this.filePath + "_error");
            this.fos = new BufferedWriter(new FileWriter(this.errorFile));
            if (this.db == null) {
                throw new Exception("FATAL: Could not get database connection!");
            }
            if (this.updateStatus(this.db, 3) < 1) {
                throw new Exception("Error updating status to RUNNING");
            }
            CFSFileReader fileReader = new CFSFileReader(this.filePath, this.getFileType());
            CFSFileReader.Record record = fileReader.nextLine();
            header = record.data;
            this.recordError(null, record.line, 0);
            while (this.importThread == currentThread && !done) {
                record = fileReader.nextLine();
                if (record != null) {
                    if (error.length() > 0) {
                        error.delete(0, error.length());
                    }
                    recordInserted = false;
                    ++recordCount;
                    try {
                        Timestamp tmp;
                        thisRecord = record.data;
                        line = fileReader.padLine(record.line, header.size() - thisRecord.size());
                        ContractExpiration thisExpiration = new ContractExpiration();
                        thisExpiration.setImportId(this.getId());
                        thisExpiration.setStatusId(6);
                        String propertyValue = "";
                        propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("serialNumber"));
                        if (!"".equals(StringUtils.toString(propertyValue))) {
                            thisExpiration.setSerialNumber(propertyValue);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("agreementNumber"))))) {
                            thisExpiration.setAgreementNumber(propertyValue);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("services"))))) {
                            thisExpiration.setServices(propertyValue);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("startDate"))))) {
                            tmp = DateUtils.getUserToServerDateTime(null, 3, 1, propertyValue, Locale.getDefault());
                            thisExpiration.setStartDate(tmp);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("endDate"))))) {
                            tmp = DateUtils.getUserToServerDateTime(null, 3, 1, propertyValue, Locale.getDefault());
                            thisExpiration.setEndDate(tmp);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("installedAtCompanyName"))))) {
                            thisExpiration.setInstalledAtCompanyName(propertyValue);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("installedAtSiteName"))))) {
                            thisExpiration.setInstalledAtSiteName(propertyValue);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("groupName"))))) {
                            thisExpiration.setGroupName(propertyValue);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("productNumber"))))) {
                            thisExpiration.setProductNumber(propertyValue);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("systemName"))))) {
                            thisExpiration.setSystemName(propertyValue);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("operatingSystem"))))) {
                            thisExpiration.setOperatingSystem(propertyValue);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("noOfShelves"))))) {
                            thisExpiration.setNoOfShelves(propertyValue);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("noOfDisks"))))) {
                            thisExpiration.setNoOfDisks(propertyValue);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("nvram"))))) {
                            thisExpiration.setNvram(propertyValue);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("memory"))))) {
                            thisExpiration.setMemory(propertyValue);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("autosupportStatus"))))) {
                            thisExpiration.setAutosupportStatus(propertyValue);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("installedAtAddress"))))) {
                            thisExpiration.setInstalledAtAddress(propertyValue);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("city"))))) {
                            thisExpiration.setCity(propertyValue);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("stateProvince"))))) {
                            thisExpiration.setStateProvince(propertyValue);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("postalCode"))))) {
                            thisExpiration.setPostalCode(propertyValue);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("country"))))) {
                            thisExpiration.setCountry(propertyValue);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("installedAtContactFirstName"))))) {
                            thisExpiration.setInstalledAtContactFirstName(propertyValue);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("contactLastName"))))) {
                            thisExpiration.setContactLastName(propertyValue);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("contactEmail"))))) {
                            thisExpiration.setContactEmail(propertyValue);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("agreementCompany"))))) {
                            thisExpiration.setAgreementCompany(propertyValue);
                        }
                        if (error.length() == 0) {
                            int thisExpirationId = 0;
                            thisExpirationId = this.isExists(thisExpiration);
                            if (thisExpirationId > 0) {
                                thisExpiration.setId(thisExpirationId);
                                thisExpiration.setModifiedBy(this.userId);
                                int resultCount = 0;
                                resultCount = thisExpiration.update(this.db);
                                recordInserted = resultCount == 1;
                            } else {
                                thisExpiration.setEnteredBy(this.userId);
                                thisExpiration.setModifiedBy(this.userId);
                                recordInserted = thisExpiration.insert(this.db);
                            }
                            if (recordInserted) {
                                this.incrementTotalImportedRecords();
                                continue;
                            }
                            this.incrementTotalFailedRecords();
                            continue;
                        }
                        this.recordError(error.toString(), line, recordCount);
                    }
                    catch (Exception unknownException) {
                        unknownException.printStackTrace();
                        if (error.length() == 0) {
                            this.recordError(unknownException.toString(), line, recordCount);
                            continue;
                        }
                        this.recordError(error.toString() + "; " + unknownException.toString(), line, recordCount);
                    }
                    continue;
                }
                done = true;
            }
            if (done) {
                this.setStatusId(6);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.recordError(e.toString(), "", -1);
            try {
                this.setStatusId(4);
            }
            catch (Exception statusException) {
                e.printStackTrace();
            }
        }
        finally {
            if (this.importThread == currentThread) {
                this.stop();
            }
        }
    }

    public void cancel() {
        try {
            this.importThread = null;
            this.setStatusId(5);
            this.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        this.importThread = null;
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("ContactExpirationImport -> Starting cleanup for ImportId: " + this.getId());
        }
        try {
            this.recordResults(this.db);
            this.fos.flush();
            this.fos.close();
            if (this.getTotalFailedRecords() > 0) {
                this.fileItem.setSubject("Error file");
                this.fileItem.setFilename(this.fileItem.getFilename() + "_error");
                this.fileItem.setClientFilename(this.getId() + "_error.csv");
                this.fileItem.setVersion(1.1);
                this.fileItem.setSize((int)this.errorFile.length());
                this.fileItem.insertVersion(this.db);
            } else {
                this.errorFile.delete();
            }
            this.manager.free(this);
        }
        catch (Exception e) {
            if (System.getProperty("DEBUG") != null) {
                e.printStackTrace();
            }
        }
        finally {
            this.manager.free(this.db);
        }
    }

    private void recordError(String error, String line, int lineNumber) {
        try {
            if (lineNumber == 0) {
                line = line + ",\"_ERROR\"";
            } else if (lineNumber == -1) {
                line = line + error;
            } else if (lineNumber > 0) {
                line = line + ",\"" + error + "\"";
                this.incrementTotalFailedRecords();
            }
            line = line + "\n";
            this.fos.write(line);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private String getValue(ArrayList thisRecord, Property type) {
        String value = null;
        if (type.getMappedColumn() > -1 && thisRecord.size() > type.getMappedColumn()) {
            value = (String)thisRecord.get(type.getMappedColumn());
        } else if (!"".equals(StringUtils.toString(type.getDefaultValue()))) {
            value = type.getDefaultValue();
        }
        return value;
    }

    public boolean delete(Connection db) throws SQLException {
        try {
            db.setAutoCommit(false);
            if (this.getStatusId() != 1 || this.getStatusId() != 2) {
                ContractExpirationImport.deleteImportedRecords(db, this.getId());
            }
            PreparedStatement pst = db.prepareStatement("DELETE from import WHERE import_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    private int isExists(ContractExpiration thisContractExpiration) {
        for (ContractExpiration tmpContractExpiration : this.contractExpirationList) {
            if (!tmpContractExpiration.getSerialNumber().equals(thisContractExpiration.getSerialNumber()) || !tmpContractExpiration.getAgreementNumber().equals(thisContractExpiration.getAgreementNumber()) || !tmpContractExpiration.getServices().equals(thisContractExpiration.getServices())) continue;
            return tmpContractExpiration.getId();
        }
        return -1;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        DependencyList dependencyList = new DependencyList();
        boolean i = false;
        boolean recordCount = false;
        return dependencyList;
    }

    public static boolean deleteImportedRecords(Connection db, int tmpImportId) throws SQLException {
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = db.prepareStatement("DELETE FROM netapp_contractexpiration WHERE import_id = ? AND status_id = ?");
            int i = 0;
            pst.setInt(++i, tmpImportId);
            pst.setInt(++i, 6);
            pst.executeUpdate();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }
}

