/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.netapps.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import org.aspcfs.modules.base.SyncableList;
import org.aspcfs.modules.netapps.base.ContractExpiration;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class ContractExpirationList
extends Vector
implements SyncableList {
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    protected int includeEnabled = 1;
    public static final String tableName = "netapp_contractexpiration";
    public static final String uniqueField = "expiration_id";
    protected Timestamp lastAnchor = null;
    protected Timestamp nextAnchor = null;
    protected int syncType = -1;
    protected PagedListInfo pagedListInfo = null;
    private String serialNumber = null;
    private String agreementNumber = null;
    private String services = null;
    private Timestamp startDate = null;
    private Timestamp endDate = null;
    private String installedAtCompanyName = null;
    private String installedAtSiteName = null;
    protected java.sql.Date endDateStart = null;
    protected java.sql.Date endDateEnd = null;
    private int importId = -1;
    private int statusId = -1;
    private boolean excludeUnapprovedContracts = true;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setSyncType(String tmp) {
        this.syncType = Integer.parseInt(tmp);
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setSerialNumber(String tmp) {
        this.serialNumber = tmp;
    }

    public void setAgreementNumber(String tmp) {
        this.agreementNumber = tmp;
    }

    public void setServices(String tmp) {
        this.services = tmp;
    }

    public void setStartDate(Timestamp tmp) {
        this.startDate = tmp;
    }

    public void setStartDate(String tmp) {
        this.startDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEndDate(Timestamp tmp) {
        this.endDate = tmp;
    }

    public void setEndDate(String tmp) {
        this.endDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setInstalledAtCompanyName(String tmp) {
        this.installedAtCompanyName = tmp;
    }

    public void setInstalledAtSiteName(String tmp) {
        this.installedAtSiteName = tmp;
    }

    public void setEndDateStart(java.sql.Date tmp) {
        this.endDateStart = tmp;
    }

    public void setEndDateStart(String tmp) {
        try {
            Date tmpDate = DateFormat.getDateInstance(3).parse(tmp);
            this.endDateStart = new java.sql.Date(new Date().getTime());
            this.endDateStart.setTime(tmpDate.getTime());
        }
        catch (Exception e) {
            this.endDateStart = null;
        }
    }

    public void setEndDateEnd(java.sql.Date tmp) {
        this.endDateEnd = tmp;
    }

    public void setEndDateEnd(String tmp) {
        try {
            Date tmpDate = DateFormat.getDateInstance(3).parse(tmp);
            this.endDateEnd = new java.sql.Date(new Date().getTime());
            this.endDateEnd.setTime(tmpDate.getTime());
        }
        catch (Exception e) {
            this.endDateEnd = null;
        }
    }

    public void setImportId(int tmp) {
        this.importId = tmp;
    }

    public void setImportId(String tmp) {
        this.importId = Integer.parseInt(tmp);
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public void setExcludeUnapprovedContracts(boolean tmp) {
        this.excludeUnapprovedContracts = tmp;
    }

    public void setExcludeUnapprovedContracts(String tmp) {
        this.excludeUnapprovedContracts = DatabaseUtils.parseBoolean(tmp);
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public Timestamp getLastAnchor() {
        return this.lastAnchor;
    }

    public Timestamp getNextAnchor() {
        return this.nextAnchor;
    }

    public int getSyncType() {
        return this.syncType;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getAgreementNumber() {
        return this.agreementNumber;
    }

    public String getServices() {
        return this.services;
    }

    public Timestamp getStartDate() {
        return this.startDate;
    }

    public Timestamp getEndDate() {
        return this.endDate;
    }

    public String getInstalledAtCompanyName() {
        return this.installedAtCompanyName;
    }

    public String getInstalledAtSiteName() {
        return this.installedAtSiteName;
    }

    public java.sql.Date getEndDateStart() {
        return this.endDateStart;
    }

    public java.sql.Date getEndDateEnd() {
        return this.endDateEnd;
    }

    public int getImportId() {
        return this.importId;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public boolean getExcludeUnapprovedContracts() {
        return this.excludeUnapprovedContracts;
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        while (rs.next()) {
            ContractExpiration thisExpiration = this.getObject(rs);
            this.add(thisExpiration);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM netapp_contractexpiration WHERE expiration_id >= 0 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("enddate, serial_number, agreement_number, services ", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY serial_number ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("ce.* FROM netapp_contractexpiration ce WHERE expiration_id >= 0 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        return rs;
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND entered > ? ");
            }
            sqlFilter.append("AND entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND modified > ? ");
            sqlFilter.append("AND entered < ? ");
            sqlFilter.append("AND modified < ? ");
        }
        if (this.serialNumber != null) {
            sqlFilter.append("AND lower(serial_number) like lower(?) ");
        }
        if (this.agreementNumber != null) {
            sqlFilter.append("AND lower(agreement_number) like lower(?) ");
        }
        if (this.services != null) {
            sqlFilter.append("AND lower(services) like lower(?) ");
        }
        if (this.startDate != null) {
            sqlFilter.append("AND startdate = ? ");
        }
        if (this.endDate != null) {
            sqlFilter.append("AND enddate = ? ");
        }
        if (this.installedAtCompanyName != null) {
            sqlFilter.append("AND lower(installed_at_company_name) like lower(?) ");
        }
        if (this.installedAtSiteName != null) {
            sqlFilter.append("AND lower(installed_at_site_name) like lower(?) ");
        }
        if (this.endDateStart != null) {
            sqlFilter.append("AND enddate >= ? ");
        }
        if (this.endDateEnd != null) {
            sqlFilter.append("AND enddate <= ? ");
        }
        if (this.importId != -1) {
            sqlFilter.append("AND import_id = ? ");
        }
        if (this.statusId != -1) {
            sqlFilter.append("AND status_id = ? ");
        }
        if (this.excludeUnapprovedContracts) {
            sqlFilter.append("AND (status_id IS NULL OR status_id = ?) ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.serialNumber != null) {
            pst.setString(++i, "%" + this.serialNumber + "%");
        }
        if (this.agreementNumber != null) {
            pst.setString(++i, "%" + this.agreementNumber + "%");
        }
        if (this.services != null) {
            pst.setString(++i, "%" + this.services + "%");
        }
        if (this.startDate != null) {
            pst.setTimestamp(++i, this.startDate);
        }
        if (this.endDate != null) {
            pst.setTimestamp(++i, this.endDate);
        }
        if (this.installedAtCompanyName != null) {
            pst.setString(++i, "%" + this.installedAtCompanyName + "%");
        }
        if (this.installedAtSiteName != null) {
            pst.setString(++i, this.installedAtSiteName);
        }
        if (this.endDateStart != null) {
            pst.setDate(++i, this.endDateStart);
        }
        if (this.endDateEnd != null) {
            pst.setDate(++i, this.endDateEnd);
        }
        if (this.importId != -1) {
            pst.setInt(++i, this.importId);
        }
        if (this.statusId != -1) {
            pst.setInt(++i, this.statusId);
        }
        if (this.excludeUnapprovedContracts) {
            pst.setInt(++i, 7);
        }
        return i;
    }

    public ContractExpiration getObject(ResultSet rs) throws SQLException {
        return new ContractExpiration(rs);
    }
}

