/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.netapps.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.utils.DatabaseUtils;

public class ContractExpirationLog
extends GenericBean {
    private int id = -1;
    private int expirationId = -1;
    private String entryText = "";
    private double quoteAmount = -1.0;
    private Timestamp quoteGeneratedDate = null;
    private Timestamp quoteAcceptedDate = null;
    private Timestamp quoteRejectedDate = null;
    private String comment = null;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private boolean override = false;
    private boolean systemMessage = false;
    private String enteredByName = null;

    public ContractExpirationLog() {
    }

    public ContractExpirationLog(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setExpirationId(int tmp) {
        this.expirationId = tmp;
    }

    public void setExpirationId(String tmp) {
        this.expirationId = Integer.parseInt(tmp);
    }

    public void setEntryText(String tmp) {
        this.entryText = tmp;
    }

    public void setQuoteAmount(double tmp) {
        this.quoteAmount = tmp;
    }

    public void setQuoteGeneratedDate(Timestamp tmp) {
        this.quoteGeneratedDate = tmp;
    }

    public void setQuoteGeneratedDate(String tmp) {
        this.quoteGeneratedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setQuoteAcceptedDate(Timestamp tmp) {
        this.quoteAcceptedDate = tmp;
    }

    public void setQuoteAcceptedDate(String tmp) {
        this.quoteAcceptedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setQuoteRejectedDate(Timestamp tmp) {
        this.quoteRejectedDate = tmp;
    }

    public void setQuoteRejectedDate(String tmp) {
        this.quoteRejectedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setComment(String tmp) {
        this.comment = tmp;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setOverride(boolean tmp) {
        this.override = tmp;
    }

    public void setOverride(String tmp) {
        this.override = DatabaseUtils.parseBoolean(tmp);
    }

    public void setSystemMessage(boolean tmp) {
        this.systemMessage = tmp;
    }

    public void setSystemMessage(String tmp) {
        this.systemMessage = DatabaseUtils.parseBoolean(tmp);
    }

    public void setEnteredByName(String tmp) {
        this.enteredByName = tmp;
    }

    public int getId() {
        return this.id;
    }

    public int getExpirationId() {
        return this.expirationId;
    }

    public String getEntryText() {
        return this.entryText;
    }

    public double getQuoteAmount() {
        return this.quoteAmount;
    }

    public Timestamp getQuoteGeneratedDate() {
        return this.quoteGeneratedDate;
    }

    public Timestamp getQuoteAcceptedDate() {
        return this.quoteAcceptedDate;
    }

    public Timestamp getQuoteRejectedDate() {
        return this.quoteRejectedDate;
    }

    public String getComment() {
        return this.comment;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public boolean getOverride() {
        return this.override;
    }

    public boolean getSystemMessage() {
        return this.systemMessage;
    }

    public String getEnteredByName() {
        return this.enteredByName;
    }

    public void process(Connection db, int expirationId) throws SQLException {
        if (expirationId != -1) {
            this.insert(db);
        }
    }

    public boolean queryRecord(Connection db, int tmpId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = db.prepareStatement(" SELECT ncl.*, ct_eb.namelast AS eb_namelast, ct_eb.namefirst AS eb_namefirst FROM netapp_contractexpiration_log ncl LEFT JOIN contact ct_eb ON (ncl.enteredby = ct_eb.user_id)  WHERE ncl.id = ? ");
        pst.setInt(1, tmpId);
        rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        return true;
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "netapp_contractexpiration_log_id_seq");
        PreparedStatement pst = null;
        pst = db.prepareStatement("INSERT INTO netapp_contractexpiration_log (" + (this.id > -1 ? "id, " : "") + "expiration_id, " + "quote_amount, " + "quotegenerateddate, " + "quoteaccepteddate, " + "quoterejecteddate, " + "comment, " + "enteredBy, " + "modifiedBy )" + "VALUES (" + (this.id > -1 ? "?, " : "") + "?,?,?,?,?,?,?,?)");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.expirationId);
        DatabaseUtils.setDouble(pst, ++i, this.quoteAmount);
        DatabaseUtils.setTimestamp(pst, ++i, this.quoteGeneratedDate);
        DatabaseUtils.setTimestamp(pst, ++i, this.quoteAcceptedDate);
        DatabaseUtils.setTimestamp(pst, ++i, this.quoteRejectedDate);
        pst.setString(++i, this.comment);
        DatabaseUtils.setInt(pst, ++i, this.enteredBy);
        DatabaseUtils.setInt(pst, ++i, this.modifiedBy);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "netapp_contractexpiration_log_id_seq", this.id);
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (!this.isValid()) {
            return resultCount;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE netapp_contractexpiration_log SET  expiration_id = ? , quote_amount = ? , quotegenerateddate = ? , quoteaccepteddate = ? , quoterejecteddate = ? , comment = ? , modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , " + "modifiedBy = ?  " + "WHERE id = ? ");
        pst = db.prepareStatement(sql.toString());
        int i = 0;
        pst.setInt(++i, this.expirationId);
        DatabaseUtils.setDouble(pst, ++i, this.quoteAmount);
        DatabaseUtils.setTimestamp(pst, ++i, this.quoteGeneratedDate);
        DatabaseUtils.setTimestamp(pst, ++i, this.quoteAcceptedDate);
        DatabaseUtils.setTimestamp(pst, ++i, this.quoteRejectedDate);
        pst.setString(++i, this.comment);
        DatabaseUtils.setInt(pst, ++i, this.modifiedBy);
        DatabaseUtils.setInt(pst, ++i, this.id);
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public boolean isValid() {
        return !this.hasErrors();
    }

    public boolean delete(Connection db) throws SQLException {
        PreparedStatement pst = null;
        pst = db.prepareStatement(" DELETE  FROM netapp_contractexpiration_log  WHERE id = ? ");
        pst.setInt(1, this.id);
        pst.execute();
        pst.close();
        return true;
    }

    public void createSysMsg(ContractExpirationLog source) {
        this.setEnteredByName(source.getEnteredByName());
        this.setEnteredBy(source.getEnteredBy());
        this.setEntered(source.getEntered());
        this.setQuoteAmount(source.getQuoteAmount());
        this.setQuoteGeneratedDate(source.getQuoteGeneratedDate());
        this.setQuoteAcceptedDate(source.getQuoteAcceptedDate());
        this.setQuoteRejectedDate(source.getQuoteRejectedDate());
        this.setComment(source.getComment());
        this.setSystemMessage(true);
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = DatabaseUtils.getInt(rs, "id");
        this.expirationId = DatabaseUtils.getInt(rs, "expiration_id");
        this.quoteAmount = DatabaseUtils.getDouble(rs, "quote_amount");
        this.quoteGeneratedDate = rs.getTimestamp("quotegenerateddate");
        this.quoteAcceptedDate = rs.getTimestamp("quoteaccepteddate");
        this.quoteRejectedDate = rs.getTimestamp("quoterejecteddate");
        this.comment = rs.getString("comment");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = DatabaseUtils.getInt(rs, "enteredBy");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = DatabaseUtils.getInt(rs, "modifiedBy");
        this.enteredByName = Contact.getNameLastFirst(rs.getString("eb_namelast"), rs.getString("eb_namefirst"));
    }
}

