/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.netapps.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.modules.netapps.base.ContractExpirationLog;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class ContractExpirationLogList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int expirationId = -1;
    public static final String tableName = "netapp_contractexpiration_log";
    public static final String uniqueField = "id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private boolean doSystemMessages = true;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setExpirationId(int tmp) {
        this.expirationId = tmp;
    }

    public void setExpirationId(String tmp) {
        this.expirationId = Integer.parseInt(tmp);
    }

    public int getExpirationId() {
        return this.expirationId;
    }

    public boolean getDoSystemMessages() {
        return this.doSystemMessages;
    }

    public void setDoSystemMessages(boolean doSystemMessages) {
        this.doSystemMessages = doSystemMessages;
    }

    public boolean setSystemMessages(HttpServletRequest request, ContractExpirationLog current, ContractExpirationLog prev) {
        ContractExpirationLog tempLog = null;
        Locale locale = ((UserBean)((Object)request.getSession().getAttribute("User"))).getUserRecord().getLocale();
        SimpleDateFormat formatter = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3, locale);
        formatter.applyPattern(DateUtils.get4DigitYearDateFormat(formatter.toPattern()));
        if (prev == null) {
            if (current.getQuoteGeneratedDate() != null) {
                tempLog = new ContractExpirationLog();
                tempLog.createSysMsg(current);
                tempLog.setEntryText("[ Quote generated on " + formatter.format(current.getQuoteGeneratedDate()) + " ]");
                this.add(tempLog);
            }
            if (current.getQuoteAcceptedDate() != null) {
                tempLog = new ContractExpirationLog();
                tempLog.createSysMsg(current);
                tempLog.setEntryText("[ Quote accepted on " + formatter.format(current.getQuoteAcceptedDate()) + " ]");
                this.add(tempLog);
            }
            if (current.getQuoteRejectedDate() != null) {
                tempLog = new ContractExpirationLog();
                tempLog.createSysMsg(current);
                tempLog.setEntryText("[ Quote rejected on " + formatter.format(current.getQuoteRejectedDate()) + " ]");
                this.add(tempLog);
            }
            if (current.getComment() != null) {
                tempLog = new ContractExpirationLog();
                tempLog.createSysMsg(current);
                tempLog.setEntryText("Comment:" + ("".equals(current.getComment()) ? "[blank]" : current.getComment()));
                this.add(tempLog);
            }
            return true;
        }
        if (current.getQuoteGeneratedDate() != null && !current.getQuoteGeneratedDate().equals(prev.getQuoteGeneratedDate())) {
            tempLog = new ContractExpirationLog();
            tempLog.createSysMsg(current);
            tempLog.setEntryText("[ Quote generated on " + formatter.format(current.getQuoteGeneratedDate()) + " ]");
            this.add(tempLog);
        }
        if (current.getQuoteAcceptedDate() != null && !current.getQuoteAcceptedDate().equals(prev.getQuoteAcceptedDate())) {
            tempLog = new ContractExpirationLog();
            tempLog.createSysMsg(current);
            tempLog.setEntryText("[ Quote accepted on " + formatter.format(current.getQuoteAcceptedDate()) + " ]");
            this.add(tempLog);
        }
        if (current.getQuoteRejectedDate() != null && !current.getQuoteRejectedDate().equals(prev.getQuoteRejectedDate())) {
            tempLog = new ContractExpirationLog();
            tempLog.createSysMsg(current);
            tempLog.setEntryText("[ Quote rejected on " + formatter.format(current.getQuoteRejectedDate()) + " ]");
            this.add(tempLog);
        }
        if (current.getComment() != null) {
            tempLog = new ContractExpirationLog();
            tempLog.createSysMsg(current);
            tempLog.setEntryText("Comment:" + ("".equals(current.getComment()) ? "[blank]" : current.getComment()));
            if (prev.getComment() == null) {
                this.add(tempLog);
            } else if (!((Object)((Object)prev)).equals(current.getComment())) {
                this.add(tempLog);
            }
        }
        if (current.getComment() == null && prev.getComment() != null) {
            tempLog = new ContractExpirationLog();
            tempLog.createSysMsg(current);
            tempLog.setEntryText("Comment: [blank]");
            this.add(tempLog);
        }
        return true;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public Timestamp getLastAnchor() {
        return this.lastAnchor;
    }

    public Timestamp getNextAnchor() {
        return this.nextAnchor;
    }

    public int getSyncType() {
        return this.syncType;
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void buildList(HttpServletRequest request, Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM netapp_contractexpiration_log ncl WHERE id > 0 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
        }
        sqlOrder.append(" ORDER BY ncl.entered ");
        sqlSelect.append("SELECT ");
        sqlSelect.append("ncl.* , ct_eb.namelast AS eb_namelast, ct_eb.namefirst AS eb_namefirst FROM netapp_contractexpiration_log ncl LEFT JOIN contact ct_eb ON (ncl.enteredby = ct_eb.user_id) WHERE ncl.id > 0 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        ContractExpirationLog prevContractExpirationLog = null;
        int count = 0;
        while (rs.next() && (this.pagedListInfo == null || this.pagedListInfo.getItemsPerPage() <= 0 || DatabaseUtils.getType(db) != 2 || count < this.pagedListInfo.getItemsPerPage())) {
            ++count;
            ContractExpirationLog thisContractExpirationLog = new ContractExpirationLog(rs);
            if (this.doSystemMessages) {
                this.setSystemMessages(request, thisContractExpirationLog, prevContractExpirationLog);
                if (thisContractExpirationLog.getEntryText() != null && !thisContractExpirationLog.getEntryText().equals("")) {
                    this.add(thisContractExpirationLog);
                }
            } else {
                this.add(thisContractExpirationLog);
            }
            prevContractExpirationLog = thisContractExpirationLog;
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (this.expirationId > -1) {
            sqlFilter.append("AND ncl.expiration_id = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.expirationId > -1) {
            pst.setInt(++i, this.expirationId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public String getComments() {
        StringBuffer comments = new StringBuffer("");
        for (ContractExpirationLog log : this) {
            comments.append(log.getEntryText() + " | ");
        }
        return comments.toString();
    }

    public void deleteList(Connection db) throws SQLException {
        for (ContractExpirationLog contractExpirationLog : this) {
            contractExpirationLog.delete(db);
        }
    }
}

